/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class NormalMethodElement
extends MethodWithBodyElement {
    public static final String ELEMENT = "method";
    private boolean staticModifier = false;
    private boolean finalModifier = false;
    private final TypeSlotFragment returnType;
    private final NameDefSlotFragment name;

    public NormalMethodElement(NormalMethodFrame frame, AccessPermissionFragment access, boolean staticModifier, boolean finalModifier, TypeSlotFragment returnType, NameDefSlotFragment name, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, List<CodeElement> contents, JavadocUnit documentation, boolean enabled) {
        super(frame, access, params, throwsTypes, contents, documentation, enabled);
        this.staticModifier = staticModifier;
        this.finalModifier = finalModifier;
        this.returnType = returnType;
        this.name = name;
    }

    public NormalMethodElement(Element el) {
        super(el);
        Attribute staticAttribute = el.getAttribute("static");
        this.staticModifier = staticAttribute == null ? false : new Boolean(staticAttribute.getValue());
        Attribute finalAttribute = el.getAttribute("final");
        this.finalModifier = finalAttribute == null ? false : new Boolean(finalAttribute.getValue());
        this.returnType = new TypeSlotFragment(el.getAttributeValue("type"));
        this.name = new NameDefSlotFragment(el.getAttributeValue("name"));
    }

    public NormalMethodElement(String access, String returnType, String name, List<Map.Entry<String, String>> params, List<CodeElement> contents, String documentation) {
        super(access, params, contents, documentation);
        this.returnType = new TypeSlotFragment(returnType);
        this.name = new NameDefSlotFragment(name);
    }

    @Override
    public JavaSource toJavaSource() {
        ArrayList<JavaFragment> header = new ArrayList<JavaFragment>();
        if (this.staticModifier) {
            header.add(NormalMethodElement.f(this.frame, "static "));
        }
        if (this.finalModifier) {
            header.add(NormalMethodElement.f(this.frame, "final "));
        }
        Collections.addAll(header, this.access, NormalMethodElement.space(), this.returnType, NormalMethodElement.space(), this.name, NormalMethodElement.f(this.frame, "("));
        ParamFragment.addParamsToHeader(this.frame, this.params, header);
        header.add(NormalMethodElement.f(this.frame, ")"));
        return JavaSource.createMethod(this.frame, this, this.documentation, header, CodeElement.toJavaCodes(this.contents));
    }

    @Override
    public Element toXML() {
        Element methodEl = new Element(ELEMENT);
        this.accessToXML(methodEl);
        if (this.staticModifier) {
            methodEl.addAttribute(new Attribute("static", "true"));
        }
        if (this.finalModifier) {
            methodEl.addAttribute(new Attribute("final", "true"));
        }
        methodEl.addAttribute(new Attribute("type", this.returnType.getContent()));
        methodEl.addAttribute(new Attribute("name", this.name.getContent()));
        this.addEnableAttribute(methodEl);
        methodEl.appendChild((Node)this.documentation.toXML());
        this.paramsToXML(methodEl);
        this.throwsToXML(methodEl);
        this.bodyToXML(methodEl);
        return methodEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new NormalMethodFrame(editor, this.access, this.staticModifier, this.finalModifier, this.returnType.getContent(), this.name.getContent(), this.documentation.toString(), this.isEnable());
        this.makeFrame(editor);
        return this.frame;
    }

    @Override
    public String getType() {
        return this.returnType.getContent();
    }

    public String getName() {
        return this.name.getContent();
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @OnThread(value=Tag.Swing)
    public boolean equalDeclaration(String name, List<AssistContent.ParamInfo> params, ClassElement el) {
        if (!this.name.getContent().equals(name)) {
            return false;
        }
        if (this.params.size() != params.size()) {
            return false;
        }
        List<String> ourQualParams = this.getQualifiedParamTypes(el);
        for (int i = 0; i < params.size(); ++i) {
            if (ourQualParams.get(i).equals(params.get(i).getQualifiedType())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        Stream s = this.params.stream().flatMap(p -> Stream.of(p.getParamType(), p.getParamName()));
        return Stream.concat(Stream.of(this.returnType, this.name), s);
    }

    public NormalMethodFrame getFrame() {
        return (NormalMethodFrame)this.frame;
    }

    public boolean isStatic() {
        return this.staticModifier;
    }

    public boolean isFinal() {
        return this.finalModifier;
    }
}

