/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.debugger.gentype.Reflective;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.DocumentContainerCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class MethodWithBodyElement
extends DocumentContainerCodeElement
implements JavaSingleLineDebugHandler {
    protected final List<ParamFragment> params;
    protected final List<ThrowsTypeFragment> throwsTypes;
    protected final List<CodeElement> contents;
    protected MethodFrameWithBody<?> frame;
    protected AccessPermissionFragment access;

    public MethodWithBodyElement(MethodFrameWithBody<?> frame, AccessPermissionFragment access, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, List<CodeElement> contents, JavadocUnit documentation, boolean enabled) {
        this.frame = frame;
        this.access = access;
        this.params = params;
        this.throwsTypes = throwsTypes;
        this.contents = contents;
        this.documentation = documentation;
        for (CodeElement c : this.contents) {
            c.setParent(this);
        }
        this.enable = enabled;
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
    }

    public MethodWithBodyElement(Element el) {
        this.access = new AccessPermissionFragment(AccessPermission.fromString(el.getAttributeValue("access")));
        this.params = new ArrayList<ParamFragment>();
        this.throwsTypes = new ArrayList<ThrowsTypeFragment>();
        this.contents = new ArrayList<CodeElement>();
        block12: for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            switch (child.getLocalName()) {
                case "params": {
                    int j;
                    for (j = 0; j < child.getChildElements().size(); ++j) {
                        this.params.add(new ParamFragment(child.getChildElements().get(j)));
                    }
                    continue block12;
                }
                case "throws": {
                    int j;
                    for (j = 0; j < child.getChildElements().size(); ++j) {
                        this.throwsTypes.add(new ThrowsTypeFragment(child.getChildElements().get(j)));
                    }
                    continue block12;
                }
                case "body": {
                    int j;
                    for (j = 0; j < child.getChildElements().size(); ++j) {
                        CodeElement member = Loader.loadElement(child.getChildElements().get(j));
                        this.contents.add(member);
                        member.setParent(this);
                    }
                    continue block12;
                }
                case "javadoc": {
                    this.documentation = new JavadocUnit(child);
                }
            }
        }
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    public MethodWithBodyElement(String access, List<Map.Entry<String, String>> params, List<CodeElement> contents, String documentation) {
        this.access = new AccessPermissionFragment(AccessPermission.fromString(access));
        this.contents = contents;
        this.documentation = new JavadocUnit(documentation);
        this.throwsTypes = new ArrayList<ThrowsTypeFragment>();
        this.params = new ArrayList<ParamFragment>();
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Map.Entry<String, String> entry = params.get(i);
                this.params.add(new ParamFragment(new TypeSlotFragment(entry.getKey()), new NameDefSlotFragment(entry.getValue())));
            }
        }
    }

    protected void accessToXML(Element methodEl) {
        if (this.access != null) {
            methodEl.addAttribute(new Attribute("access", this.access.getContent()));
        }
    }

    protected void paramsToXML(Element methodEl) {
        Element paramsEl = new Element("params");
        for (ParamFragment param : this.params) {
            paramsEl.appendChild((Node)param.toXML());
        }
        methodEl.appendChild((Node)paramsEl);
    }

    protected void throwsToXML(Element methodEl) {
        Element throwsEl = new Element("throws");
        for (ThrowsTypeFragment t : this.throwsTypes) {
            throwsEl.appendChild((Node)t.toXML());
        }
        methodEl.appendChild((Node)throwsEl);
    }

    protected void bodyToXML(Element methodEl) {
        Element bodyEl = new Element("body");
        for (CodeElement c : this.contents) {
            bodyEl.appendChild((Node)c.toXML());
        }
        methodEl.appendChild((Node)bodyEl);
    }

    @OnThread(value=Tag.FX)
    protected void makeFrame(InteractionManager editor) {
        this.frame.setAccess(this.access.getValue());
        this.frame.setDocumentation(this.documentation.toString());
        this.params.forEach(item -> this.frame.getParamsPane().addFormal(item.getParamType(), item.getParamName()));
        this.contents.forEach(c -> this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null));
        this.throwsTypes.forEach(t -> this.frame.addThrows(t.getType()));
    }

    @Override
    public List<CodeElement.LocalParamInfo> getDeclaredVariablesWithin() {
        ArrayList<CodeElement.LocalParamInfo> vars = new ArrayList<CodeElement.LocalParamInfo>();
        this.params.forEach(param -> vars.add(new CodeElement.LocalParamInfo(param.getParamType().getContent(), param.getParamName().getContent(), true, this)));
        return vars;
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public MethodWithBodyElement getMethodElement() {
        return this;
    }

    public List<CodeElement> getContents() {
        return this.contents;
    }

    public abstract String getType();

    @Override
    public Stream<CodeElement> streamContained() {
        return MethodWithBodyElement.streamContained(this.contents);
    }

    @OnThread(value=Tag.Swing)
    public List<String> getQualifiedParamTypes(ClassElement topLevel) {
        return this.params.stream().map(p -> {
            TypeSlotFragment paramType = p.getParamType();
            Reflective qualifyType = topLevel.qualifyType(paramType.getContent(), paramType.getPosInSourceDoc());
            if (qualifyType == null) {
                return paramType.getContent();
            }
            return qualifyType.getName();
        }).collect(Collectors.toList());
    }

    public AccessPermission getAccessPermission() {
        return this.access.getValue();
    }

    public List<String> getThrowsTypes() {
        return Utility.mapList(this.throwsTypes, ThrowsTypeFragment::getType);
    }

    public List<ParamFragment> getParams() {
        return this.params;
    }
}

