/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.frames.IfFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SandwichCanvasesFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

public class IfElement
extends SandwichCanvasesElement {
    public static final String ELEMENT = "if";
    private static final String ELSE_IF_LABEL = "elseIf";
    private static final String ELSE_IF_JAVA_LABEL = "else if";
    private static final String ELSE_LABEL = "else";
    private static final String CONDITION_LABEL = "condition";
    private static final String CONDITION_JAVA_LABEL = "condition-java";
    private FilledExpressionSlotFragment condition;
    private List<ExpressionSlotFragment> elseIfConditions = new ArrayList<ExpressionSlotFragment>();
    private IfFrame frame;

    public IfElement(IfFrame frame, FilledExpressionSlotFragment condition, List<CodeElement> thenContents, List<ExpressionSlotFragment> elseIfConditions, List<List<CodeElement>> elseIfContents, List<CodeElement> elseContents, boolean enabled) {
        super(frame, ELEMENT, thenContents, ELSE_IF_LABEL, ELSE_IF_JAVA_LABEL, elseIfContents, ELSE_LABEL, elseContents, enabled);
        this.condition = condition;
        this.elseIfConditions = elseIfConditions;
    }

    public IfElement(Element element) {
        super(ELEMENT, ELSE_IF_LABEL, ELSE_IF_JAVA_LABEL, ELSE_LABEL);
        this.loadElement(element);
    }

    @Override
    protected void loadMainAttributes(Element element) {
        this.condition = new FilledExpressionSlotFragment(element.getAttributeValue(CONDITION_LABEL), element.getAttributeValue(CONDITION_JAVA_LABEL));
    }

    @Override
    protected void loadIntermediateAttributes(Element element) {
        this.elseIfConditions.add(new FilledExpressionSlotFragment(element.getAttributeValue(CONDITION_LABEL), element.getAttributeValue(CONDITION_JAVA_LABEL)));
    }

    @Override
    protected List<JavaFragment> getFirstHeaderFragment() {
        List<JavaFragment> headerFragment = super.getFirstHeaderFragment();
        headerFragment.addAll(Arrays.asList(IfElement.f(this.frame, " ("), this.condition, IfElement.f(this.frame, ")")));
        return headerFragment;
    }

    @Override
    protected List<JavaFragment> getIntermediateHeaderFragment(int index) {
        List<JavaFragment> headerFragment = super.getIntermediateHeaderFragment(index);
        headerFragment.addAll(Arrays.asList(IfElement.f(this.frame, " ("), this.elseIfConditions.get(index), IfElement.f(this.frame, ")")));
        return headerFragment;
    }

    @Override
    protected void addMainAttributes(Element element) {
        element.addAttribute(new Attribute(CONDITION_LABEL, this.condition.getContent()));
        element.addAttribute(new Attribute(CONDITION_JAVA_LABEL, this.condition.getJavaCode()));
    }

    @Override
    protected void addIntermediateAttributes(Element element, int index) {
        element.addAttribute(new Attribute(CONDITION_LABEL, this.elseIfConditions.get(index).getContent()));
        element.addAttribute(new Attribute(CONDITION_JAVA_LABEL, this.elseIfConditions.get(index).getJavaCode()));
    }

    @Override
    @OnThread(value=Tag.FX)
    protected SandwichCanvasesFrame buildFrame(InteractionManager editor, List<Frame> firstCanvasFrames, List<List<Frame>> intermediateCanvasFrames, List<Frame> tailCanvasFrames, boolean enable) {
        this.frame = new IfFrame(editor, this.condition, firstCanvasFrames, this.elseIfConditions, intermediateCanvasFrames, tailCanvasFrames, enable);
        return this.frame;
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.condition);
    }
}

