/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.ForeachFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;

public class ForeachElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler,
JavaContainerDebugHandler {
    public static final String ELEMENT = "foreach";
    private final TypeSlotFragment type;
    private final NameDefSlotFragment var;
    private final FilledExpressionSlotFragment collection;
    private final List<CodeElement> contents;
    private ForeachFrame frame;

    public ForeachElement(ForeachFrame frame, TypeSlotFragment type, NameDefSlotFragment var, FilledExpressionSlotFragment collection, List<CodeElement> contents, boolean enabled) {
        this.frame = frame;
        this.type = type;
        this.var = var;
        this.collection = collection;
        this.contents = contents;
        this.enable = enabled;
        contents.forEach(c -> c.setParent(this));
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createCompoundStatement(this.frame, this, this, Arrays.asList(ForeachElement.f(this.frame, "for (final "), this.type, ForeachElement.space(), this.var, ForeachElement.f(this.frame, " : "), this.collection, ForeachElement.f(this.frame, ")")), CodeElement.toJavaCodes(this.contents));
    }

    @Override
    public Element toXML() {
        Element loopEl = new Element(ELEMENT);
        loopEl.addAttribute(new Attribute("type", this.type.getContent()));
        loopEl.addAttribute(new Attribute("var", this.var.getContent()));
        loopEl.addAttribute(new Attribute("collection", this.collection.getContent()));
        loopEl.addAttribute(new Attribute("collection-java", this.collection.getJavaCode()));
        this.addEnableAttribute(loopEl);
        for (CodeElement c : this.contents) {
            loopEl.appendChild((Node)c.toXML());
        }
        return loopEl;
    }

    public ForeachElement(Element el) {
        this.type = new TypeSlotFragment(el.getAttributeValue("type"));
        this.var = new NameDefSlotFragment(el.getAttributeValue("var"));
        this.collection = new FilledExpressionSlotFragment(el.getAttributeValue("collection"), el.getAttributeValue("collection-java"));
        this.contents = new ArrayList<CodeElement>();
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.contents.add(member);
            member.setParent(this);
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new ForeachFrame(editor, this.type, this.var, this.collection, this.isEnable());
        for (CodeElement c : this.contents) {
            this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null);
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return this.frame.showDebugAtEnd(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return ForeachElement.streamContained(this.contents);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.type, this.var, this.collection);
    }

    @Override
    public List<CodeElement.LocalParamInfo> getDeclaredVariablesWithin() {
        return Collections.singletonList(new CodeElement.LocalParamInfo(this.type.getContent(), this.var.getContent(), false, this));
    }
}

