/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DefaultCaseFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;

public class DefaultCaseElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler,
JavaContainerDebugHandler {
    public static final String ELEMENT = "default";
    private final List<CodeElement> contents;
    private DefaultCaseFrame frame;

    public DefaultCaseElement(DefaultCaseFrame frame, ArrayList<CodeElement> contents, boolean enabled) {
        this.frame = frame;
        this.contents = contents;
        this.enable = enabled;
        contents.forEach(c -> c.setParent(this));
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createCompoundStatement(this.frame, this, this, Arrays.asList(DefaultCaseElement.f(this.frame, "default: ")), CodeElement.toJavaCodes(this.contents), DefaultCaseElement.f(this.frame, "break;"));
    }

    @Override
    public Element toXML() {
        Element el = new Element(ELEMENT);
        this.addEnableAttribute(el);
        for (CodeElement c : this.contents) {
            el.appendChild((Node)c.toXML());
        }
        return el;
    }

    public DefaultCaseElement(Element el) {
        this.contents = new ArrayList<CodeElement>();
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.contents.add(member);
            member.setParent(this);
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new DefaultCaseFrame(editor, this.isEnable());
        for (CodeElement c : this.contents) {
            this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null);
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return this.frame.showDebugAtEnd(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return DefaultCaseElement.streamContained(this.contents);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.empty();
    }
}

