/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.frames.CatchFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;

public class CatchElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "catch";
    private final TypeSlotFragment exceptionTypeFragment;
    private final NameDefSlotFragment exceptionNameFragment;
    private final List<CodeElement> contents;
    private CatchFrame frame;

    public CatchElement(CatchFrame frame, TypeSlotFragment exceptionTypeFragment, NameDefSlotFragment exceptionNameFragment, List<CodeElement> contents, boolean enabled) {
        this.frame = frame;
        this.exceptionTypeFragment = exceptionTypeFragment;
        this.exceptionNameFragment = exceptionNameFragment;
        this.contents = contents;
        this.enable = enabled;
        contents.forEach(c -> c.setParent(this));
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createCompoundStatement(this.frame, this, null, Arrays.asList(CatchElement.f(this.frame, "catch ("), this.exceptionTypeFragment, CatchElement.f(this.frame, " "), this.exceptionNameFragment, CatchElement.f(this.frame, ")")), CodeElement.toJavaCodes(this.contents));
    }

    @Override
    public Element toXML() {
        Element catchEl = new Element(ELEMENT);
        catchEl.addAttribute(new Attribute("type", this.exceptionTypeFragment.getContent()));
        catchEl.addAttribute(new Attribute("name", this.exceptionNameFragment.getContent()));
        this.addEnableAttribute(catchEl);
        for (CodeElement c : this.contents) {
            catchEl.appendChild((Node)c.toXML());
        }
        return catchEl;
    }

    public CatchElement(Element el) {
        this.exceptionTypeFragment = new TypeSlotFragment(el.getAttributeValue("type"));
        this.exceptionNameFragment = new NameDefSlotFragment(el.getAttributeValue("name"));
        this.contents = new ArrayList<CodeElement>();
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.contents.add(member);
            member.setParent(this);
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new CatchFrame(editor, this.exceptionTypeFragment, this.exceptionNameFragment, this.isEnable());
        for (CodeElement c : this.contents) {
            this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null);
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return CatchElement.streamContained(this.contents);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.exceptionTypeFragment, this.exceptionNameFragment);
    }
}

