/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;

public class CallElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "call";
    private final FilledExpressionSlotFragment call;
    private CallFrame frame;

    public CallElement(CallFrame frame, FilledExpressionSlotFragment call, boolean enabled) {
        this.frame = frame;
        this.call = call;
        this.enable = enabled;
    }

    public CallElement(Element el) {
        this.call = new FilledExpressionSlotFragment(el.getAttributeValue("expression"), el.getAttributeValue("expression-java"));
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    public CallElement(String call, String javaCode) {
        this.call = new FilledExpressionSlotFragment(call, javaCode);
    }

    @Override
    public JavaSource toJavaSource() {
        return new JavaSource((JavaSingleLineDebugHandler)this, this.call, CallElement.f(this.frame, ";"));
    }

    @Override
    public Element toXML() {
        Element callEl = new Element(ELEMENT);
        callEl.addAttribute(new Attribute("expression", this.call.getContent()));
        callEl.addAttribute(new Attribute("expression-java", this.call.getJavaCode()));
        this.addEnableAttribute(callEl);
        return callEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new CallFrame(editor, this.call, this.isEnable());
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.call);
    }
}

