/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;

public class AssignElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "assign";
    private final FilledExpressionSlotFragment lhs;
    private final FilledExpressionSlotFragment rhs;
    private AssignFrame frame;

    public AssignElement(AssignFrame frame, FilledExpressionSlotFragment lhs, FilledExpressionSlotFragment rhs, boolean enabled) {
        this.frame = frame;
        this.lhs = lhs;
        this.lhs.markAssignmentLHS(frame);
        this.rhs = rhs;
        this.enable = enabled;
    }

    @Override
    public JavaSource toJavaSource() {
        return new JavaSource((JavaSingleLineDebugHandler)this, this.lhs, AssignElement.f(this.frame, " = "), this.rhs, AssignElement.f(this.frame, ";"));
    }

    @Override
    public Element toXML() {
        Element assignEl = new Element(ELEMENT);
        assignEl.addAttribute(new Attribute("dest", this.lhs.getContent()));
        assignEl.addAttribute(new Attribute("dest-java", this.lhs.getJavaCode()));
        assignEl.addAttribute(new Attribute("src", this.rhs.getContent()));
        assignEl.addAttribute(new Attribute("src-java", this.rhs.getJavaCode()));
        this.addEnableAttribute(assignEl);
        return assignEl;
    }

    public AssignElement(Element el) {
        this.lhs = new FilledExpressionSlotFragment(el.getAttributeValue("dest"), el.getAttributeValue("dest-java"));
        this.rhs = new FilledExpressionSlotFragment(el.getAttributeValue("src"), el.getAttributeValue("src-java"));
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new AssignFrame(editor, this.lhs, this.rhs, this.isEnable());
        this.lhs.markAssignmentLHS(this.frame);
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.lhs, this.rhs);
    }
}

