/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.JavaParser;
import bluej.parser.ParseFailure;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import java.io.StringReader;
import java.util.UUID;

public class Parser {
    public static boolean parseableAsType(String s) {
        JavaParser p = new JavaParser(new StringReader(s), false);
        try {
            p.parseTypeSpec(true);
            LocatableToken tok = p.getTokenStream().nextToken();
            return tok.getType() == 1;
        }
        catch (ParseFailure pf) {
            return false;
        }
    }

    public static boolean parseableAsImportTarget(String s) {
        JavaParser p = new JavaParser(new StringReader("import " + s + ";"), false);
        try {
            p.parseImportStatement();
            LocatableToken tok = p.getTokenStream().nextToken();
            return tok.getType() == 1;
        }
        catch (ParseFailure pf) {
            return false;
        }
    }

    public static String generateNewDummyName() {
        return "code__dummy__gf3gen__" + UUID.randomUUID().toString().replace('-', '_');
    }

    public static boolean isDummyName(String name) {
        return name.startsWith("code__dummy__gf3gen__");
    }

    public static boolean parseableAsNameDef(String s) {
        JavaLexer lexer = new JavaLexer(new StringReader(s));
        LocatableToken t = lexer.nextToken();
        LocatableToken t2 = lexer.nextToken();
        return t.getType() == 69 && t2.getType() == 1;
    }

    public static boolean parseableAsExpression(String e) {
        return Parser.parseAsExpression(new JavaParser(new StringReader(e), false));
    }

    public static boolean parseAsExpression(JavaParser p) {
        try {
            p.parseExpression();
            LocatableToken tok = p.getTokenStream().nextToken();
            if (tok.getType() != 1) {
                return false;
            }
        }
        catch (ParseFailure pf) {
            return false;
        }
        return true;
    }
}

