/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.generic.Frame;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;

public class ParamFragment {
    public static final String ELEMENT = "param";
    private final TypeSlotFragment paramType;
    private final NameDefSlotFragment paramName;

    public ParamFragment(TypeSlotFragment paramType, NameDefSlotFragment paramName) {
        this.paramType = paramType;
        this.paramName = paramName;
    }

    public ParamFragment(Element el) {
        this.paramType = new TypeSlotFragment(el.getAttributeValue("type"));
        this.paramName = new NameDefSlotFragment(el.getAttributeValue("name"));
    }

    public Element toXML() {
        Element paramEl = new Element(ELEMENT);
        paramEl.addAttribute(new Attribute("type", this.paramType.getContent()));
        paramEl.addAttribute(new Attribute("name", this.paramName.getContent()));
        return paramEl;
    }

    public TypeSlotFragment getParamType() {
        return this.paramType;
    }

    public NameDefSlotFragment getParamName() {
        return this.paramName;
    }

    public static void addParamsToHeader(Frame frame, List<ParamFragment> params, List<JavaFragment> header) {
        for (int i = 0; i < params.size(); ++i) {
            header.add(params.get(i).getParamType());
            header.add(new FrameFragment(frame, " "));
            header.add(params.get(i).getParamName());
            if (i == params.size() - 1) continue;
            header.add(new FrameFragment(frame, ", "));
        }
    }
}

