/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.elements.AssignElement;
import bluej.stride.framedjava.elements.BlankElement;
import bluej.stride.framedjava.elements.BreakElement;
import bluej.stride.framedjava.elements.BreakpointElement;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CaseElement;
import bluej.stride.framedjava.elements.CatchElement;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.CommentElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.DefaultCaseElement;
import bluej.stride.framedjava.elements.ForeachElement;
import bluej.stride.framedjava.elements.IfElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.InterfaceElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.ReturnElement;
import bluej.stride.framedjava.elements.SwitchElement;
import bluej.stride.framedjava.elements.ThrowElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.elements.TryElement;
import bluej.stride.framedjava.elements.VarElement;
import bluej.stride.framedjava.elements.WhileElement;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public class Loader {
    public static TopLevelCodeElement loadTopLevelElement(Element el, EntityResolver resolver) {
        switch (el.getLocalName()) {
            case "class": {
                return new ClassElement(el, resolver);
            }
            case "interface": {
                return new InterfaceElement(el, resolver);
            }
        }
        throw new IllegalArgumentException("Unknown top level element: " + el.getLocalName());
    }

    public static CodeElement loadElement(Element el) {
        switch (el.getLocalName()) {
            case "assign": {
                return new AssignElement(el);
            }
            case "blank": {
                return new BlankElement(el);
            }
            case "break": {
                return new BreakElement(el);
            }
            case "breakpoint": {
                return new BreakpointElement(el);
            }
            case "call": {
                return new CallElement(el);
            }
            case "case": {
                return new CaseElement(el);
            }
            case "catch": {
                return new CatchElement(el);
            }
            case "class": {
                throw new IllegalArgumentException("Cannot load top level element via loadElement: " + el.getLocalName());
            }
            case "comment": {
                return new CommentElement(el);
            }
            case "constructor": {
                return new ConstructorElement(el);
            }
            case "default": {
                return new DefaultCaseElement(el);
            }
            case "foreach": {
                return new ForeachElement(el);
            }
            case "if": {
                return new IfElement(el);
            }
            case "import": {
                return new ImportElement(el);
            }
            case "interface": {
                throw new IllegalArgumentException("Cannot load top level element via loadElement: " + el.getLocalName());
            }
            case "methodproto": {
                return new MethodProtoElement(el);
            }
            case "method": {
                return new NormalMethodElement(el);
            }
            case "return": {
                return new ReturnElement(el);
            }
            case "switch": {
                return new SwitchElement(el);
            }
            case "throw": {
                return new ThrowElement(el);
            }
            case "try": {
                return new TryElement(el);
            }
            case "variable": {
                return new VarElement(el);
            }
            case "while": {
                return new WhileElement(el);
            }
        }
        return null;
    }

    public static CodeElement loadElement(String elementString) {
        try {
            return Loader.loadElement(new Element(new Builder().build((Reader)new StringReader(elementString)).getRootElement()));
        }
        catch (IOException | ParsingException e) {
            Debug.reportError(e);
            return null;
        }
    }

    public static TopLevelCodeElement loadTopLevelElement(File file, EntityResolver resolver) {
        try {
            Document xml = new Builder().build(file);
            return Loader.loadTopLevelElement(xml.getRootElement(), resolver);
        }
        catch (IOException | ParsingException e) {
            Debug.reportError(e);
            return null;
        }
    }
}

