/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.print;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;

public class ClassDiagramPrinter
implements Printable {
    private PrinterJob printerJob;
    private Package pkg;
    private PageFormat pageFormat;
    private int pageColumns = 0;
    private int pageRows = 0;
    private int pages;
    private int currentPage;
    private int currentColumn = 0;
    private int currentRow = 0;
    private double scaleFactor = (double)Config.getPropInteger("bluej.print.scale", 50) / 100.0;
    private final String projName;
    private final String pkgQualName;
    static final int TITLEBOX_HEIGHT = 20;
    static final int PRINT_HMARGIN = 1;
    static final int PRINT_VMARGIN = 21;
    static final Font printTitleFont = new Font("SansSerif", 0, 12);
    static final Font printInfoFont = new Font("SansSerif", 2, 9);
    private final Dimension graphSize;

    public ClassDiagramPrinter(PrinterJob printer, Package pkg, Dimension graphSize, PageFormat pageFormat) {
        this.printerJob = printer;
        this.pkg = pkg;
        this.projName = pkg.getProject().getProjectName();
        this.pkgQualName = pkg.getQualifiedName();
        this.pageFormat = pageFormat;
        this.graphSize = graphSize;
    }

    public void printPackage() {
        this.printerJob.setPrintable(this, this.pageFormat);
        this.calculatePages();
        try {
            this.printerJob.print();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> this.pkg.setStatus(Config.getString("pkgmgr.info.printed")));
    }

    private void calculatePages() {
        this.graphSize.setSize(this.graphSize.getWidth() * this.scaleFactor, this.graphSize.getHeight() * this.scaleFactor);
        Rectangle printArea = this.getPrintArea(this.pageFormat);
        this.pageColumns = (this.graphSize.width + printArea.width - 1) / printArea.width;
        this.pageRows = (this.graphSize.height + printArea.height - 1) / printArea.height;
        this.pages = this.pageColumns * this.pageRows;
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.pages) {
            return 1;
        }
        Rectangle printArea = this.getPrintArea(pageFormat);
        if (this.currentColumn < this.pageColumns) {
            if (this.currentPage < pageIndex) {
                ++this.currentColumn;
            }
        } else if (this.currentRow < this.pageRows) {
            ++this.currentRow;
            this.currentColumn = 0;
        }
        this.printTitle(g, pageFormat, pageIndex + 1);
        g.translate(printArea.x - this.currentColumn * printArea.width, printArea.y - this.currentRow * printArea.height);
        g.setClip(this.currentColumn * printArea.width, this.currentRow * printArea.height, printArea.width, printArea.height);
        ((Graphics2D)g).scale(this.scaleFactor, this.scaleFactor);
        this.pkg.getEditor().paint(g);
        this.currentPage = pageIndex;
        return 0;
    }

    private Rectangle getPrintArea(PageFormat pageFormat) {
        return new Rectangle((int)pageFormat.getImageableX() + 1, (int)pageFormat.getImageableY() + 21, (int)pageFormat.getImageableWidth() - 2, (int)pageFormat.getImageableHeight() - 42);
    }

    private void printTitle(Graphics g, PageFormat pageFormat, int pageNum) {
        FontMetrics ifm = g.getFontMetrics(printInfoFont);
        Rectangle printArea = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        g.setColor(Color.lightGray);
        g.fillRect(printArea.x, printArea.y, printArea.width - 1, 20);
        g.setColor(Color.black);
        g.drawRect(printArea.x, printArea.y, printArea.width - 1, 20);
        g.drawRect(printArea.x, printArea.y, printArea.width - 1, printArea.height - 21);
        String title = "Project " + this.projName;
        String packageName = this.pkgQualName;
        if (packageName.length() > 0) {
            title = title + " [package " + packageName + "]";
        }
        g.setFont(printTitleFont);
        Utility.drawCentredText(g, title, printArea.x, printArea.y, printArea.width, 20);
        g.setFont(printInfoFont);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Utility.drawRightText(g, dateFormat.format(new Date()) + "     Page " + pageNum + " of " + this.pages, printArea.x, printArea.y + printArea.height - 21, printArea.width, ifm.getHeight());
    }
}

