/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerTestResult;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.testmgr.TestDisplayFrame;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class TestRunnerThread
extends Thread {
    private Iterator<ClassTarget> testIterator;
    private DebuggerTestResult lastResult = null;
    private PkgMgrFrame pmf;
    private ClassTarget ct;
    private String[] allMethods;
    private String methodName;
    private int state;

    public TestRunnerThread(PkgMgrFrame pmf, Iterator<ClassTarget> i) {
        this.pmf = pmf;
        this.testIterator = i;
        this.state = 0;
    }

    public TestRunnerThread(PkgMgrFrame pmf, ClassTarget ct, String methodName) {
        this.pmf = pmf;
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>(1);
        l.add(ct);
        this.testIterator = l.iterator();
        this.methodName = methodName;
        this.state = 0;
    }

    public void setMethods(String[] methods) {
        this.allMethods = methods;
    }

    @Override
    @OnThread(value=Tag.Swing, ignoreParent=true)
    public void run() {
        switch (this.state) {
            case 0: {
                try {
                    while (this.testIterator.hasNext()) {
                        this.ct = this.testIterator.next();
                        if (this.methodName == null) {
                            this.state = 1;
                            EventQueue.invokeAndWait(this);
                        } else {
                            this.allMethods = new String[]{this.methodName};
                        }
                        for (int i = 0; i < this.allMethods.length; ++i) {
                            this.lastResult = this.pmf.getProject().getDebugger().runTestMethod(this.ct.getQualifiedName(), this.allMethods[i]);
                            this.state = 2;
                            EventQueue.invokeAndWait(this);
                        }
                    }
                    this.state = 3;
                    EventQueue.invokeAndWait(this);
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                catch (InterruptedException ite) {}
                break;
            }
            case 1: {
                if (this.ct.isCompiled() && this.ct.isUnitTest() && !this.ct.isAbstract()) {
                    UnitTestClassRole utcr = (UnitTestClassRole)this.ct.getRole();
                    utcr.doRunTest(this.pmf, this.ct, this);
                    break;
                }
                this.allMethods = new String[0];
                break;
            }
            case 2: {
                boolean quiet = this.methodName != null && this.lastResult.isSuccess();
                TestDisplayFrame.getTestDisplay().addResult(this.lastResult, quiet);
                if (quiet) {
                    this.pmf.setStatus(this.methodName + " " + Config.getString("pkgmgr.test.succeeded"));
                }
                DataCollector.testResult(this.pmf.getPackage(), this.lastResult);
                break;
            }
            case 3: {
                if (this.methodName != null) break;
                this.pmf.endTestRun();
            }
        }
    }
}

