/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.collect.DataCollector;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.LibraryCallDialog;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.debugmgr.texteval.TextEvalArea;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.MenuManager;
import bluej.extmgr.ToolsExtensionMenu;
import bluej.extmgr.ViewExtensionMenu;
import bluej.groupwork.actions.CheckoutAction;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.pkgmgr.AboutBlue;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.FileTransferHandler;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.MIDletDeployer;
import bluej.pkgmgr.MachineIcon;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.NoProjectMessagePanel;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.actions.AddClassAction;
import bluej.pkgmgr.actions.CancelTestRecordAction;
import bluej.pkgmgr.actions.CheckExtensionsAction;
import bluej.pkgmgr.actions.CheckVersionAction;
import bluej.pkgmgr.actions.CloseProjectAction;
import bluej.pkgmgr.actions.CompileAction;
import bluej.pkgmgr.actions.CompileSelectedAction;
import bluej.pkgmgr.actions.DeployMIDletAction;
import bluej.pkgmgr.actions.EndTestRecordAction;
import bluej.pkgmgr.actions.ExportProjectAction;
import bluej.pkgmgr.actions.GenerateDocsAction;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.ImportProjectAction;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewInheritsAction;
import bluej.pkgmgr.actions.NewMEprojectAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.actions.NewProjectAction;
import bluej.pkgmgr.actions.NewUsesAction;
import bluej.pkgmgr.actions.OpenNonBlueJAction;
import bluej.pkgmgr.actions.OpenProjectAction;
import bluej.pkgmgr.actions.PageSetupAction;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.PrintAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.pkgmgr.actions.RebuildAction;
import bluej.pkgmgr.actions.RemoveAction;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.pkgmgr.actions.RunTestsAction;
import bluej.pkgmgr.actions.SaveProjectAction;
import bluej.pkgmgr.actions.SaveProjectAsAction;
import bluej.pkgmgr.actions.ShowCopyrightAction;
import bluej.pkgmgr.actions.ShowDebuggerAction;
import bluej.pkgmgr.actions.ShowInheritsAction;
import bluej.pkgmgr.actions.ShowTerminalAction;
import bluej.pkgmgr.actions.ShowTestResultsAction;
import bluej.pkgmgr.actions.ShowTextEvalAction;
import bluej.pkgmgr.actions.ShowUsesAction;
import bluej.pkgmgr.actions.StandardAPIHelpAction;
import bluej.pkgmgr.actions.TutorialAction;
import bluej.pkgmgr.actions.UseLibraryAction;
import bluej.pkgmgr.actions.WebsiteAction;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.print.PackagePrintManager;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.GradientFillPanel;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PkgMgrFrame
extends JFrame
implements BlueJEventListener,
MouseListener,
PackageEditorListener {
    static final int DEFAULT_WIDTH = 560;
    static final int DEFAULT_HEIGHT = 400;
    private static final Font pkgMgrFont = PrefMgr.getStandardFont();
    private static boolean testToolsShown = PkgMgrFrame.wantToSeeTestingTools();
    private static boolean teamToolsShown = PkgMgrFrame.wantToSeeTeamTools();
    private static boolean javaMEtoolsShown = PkgMgrFrame.wantToSeeJavaMEtools();
    private static PkgMgrFrame recentFrame = null;
    private static final AtomicInteger nextTestIdentifier = new AtomicInteger(0);
    private static PageFormat pageFormat = null;
    private static final List<PkgMgrFrame> frames = new ArrayList<PkgMgrFrame>();
    private static final ExtensionsManager extMgr = ExtensionsManager.getInstance();
    private JPanel buttonPanel;
    private JPanel testPanel;
    private JPanel javaMEPanel;
    private JPanel teamPanel;
    private JCheckBoxMenuItem showUsesMenuItem;
    private JCheckBoxMenuItem showExtendsMenuItem;
    private AbstractButton imgExtendsButton;
    private AbstractButton imgDependsButton;
    private AbstractButton runButton;
    private JLabel statusbar;
    private ActivityIndicator progressbar;
    private JLabel testStatusMessage;
    private JLabel recordingLabel;
    private AbstractButton endTestButton;
    private AbstractButton cancelTestButton;
    private JMenuItem endTestMenuItem;
    private JMenuItem cancelTestMenuItem;
    private ClassTarget testTarget = null;
    private String testTargetMethod;
    private int testIdentifier = 0;
    private JMenuBar menubar = null;
    private JMenu recentProjectsMenu;
    private JMenu testingMenu;
    private MenuManager toolsMenuManager;
    private MenuManager viewMenuManager;
    private JMenu teamMenu;
    private JMenuItem shareProjectMenuItem;
    private JMenuItem teamSettingsMenuItem;
    private JMenuItem showLogMenuItem;
    private JMenuItem updateMenuItem;
    private JMenuItem commitMenuItem;
    private JMenuItem statusMenuItem;
    private AbstractButton updateButton;
    private AbstractButton commitButton;
    private AbstractButton teamStatusButton;
    private List<JComponent> teamItems;
    private JMenuItem javaMEnewProjMenuItem;
    private JMenuItem javaMEdeployMenuItem;
    private TeamActionGroup teamActions;
    private JMenuItem showTestResultsItem;
    private List<JComponent> itemsToDisable;
    private List<Action> actionsToDisable;
    private List<JComponent> testItems;
    private MachineIcon machineIcon;
    private final Action closeProjectAction = new CloseProjectAction();
    private final Action saveProjectAction = new SaveProjectAction();
    private final Action saveProjectAsAction = new SaveProjectAsAction();
    private final Action importProjectAction = new ImportProjectAction();
    private final Action exportProjectAction = new ExportProjectAction();
    private final Action pageSetupAction = new PageSetupAction();
    private final Action printAction = new PrintAction();
    private final Action newClassAction = new NewClassAction();
    private final Action newPackageAction = new NewPackageAction();
    private final Action addClassAction = new AddClassAction();
    private final Action removeAction = new RemoveAction();
    private final Action newUsesAction = new NewUsesAction();
    private final Action newInheritsAction = new NewInheritsAction();
    private final Action compileAction = new CompileAction();
    private final Action compileSelectedAction = new CompileSelectedAction();
    private final Action rebuildAction = new RebuildAction();
    private final Action restartVMAction = RestartVMAction.getInstance();
    private final Action useLibraryAction = new UseLibraryAction();
    private final Action generateDocsAction = new GenerateDocsAction();
    private final PkgMgrAction showUsesAction = new ShowUsesAction();
    private final PkgMgrAction showInheritsAction = new ShowInheritsAction();
    private final PkgMgrAction showDebuggerAction = new ShowDebuggerAction();
    private final PkgMgrAction showTerminalAction = new ShowTerminalAction();
    private final PkgMgrAction showTextEvalAction = new ShowTextEvalAction();
    private final Action runTestsAction = new RunTestsAction();
    private final Action deployMIDletAction = new DeployMIDletAction();
    private JScrollPane classScroller = null;
    private Package pkg = null;
    private PackageEditor editor = null;
    private final ObjectBench objbench;
    private TextEvalArea textEvaluator;
    private JSplitPane splitPane;
    private JSplitPane objectBenchSplitPane;
    private boolean showingTextEvaluator = false;
    private LibraryCallDialog libraryCallDialog = null;
    private ProjectPrintDialog projectPrintDialog = null;
    private ExportManager exporter;
    private final NoProjectMessagePanel noProjectMessagePanel = new NoProjectMessagePanel();

    private PkgMgrFrame() {
        this.objbench = new ObjectBench(this);
        this.addCtrlTabShortcut(this.objbench);
        if (!Config.isGreenfoot()) {
            this.teamActions = new TeamActionGroup(false);
            this.teamActions.setAllDisabled();
            this.setupActionDisableSet();
            this.makeFrame();
            this.updateWindow();
            this.setStatus("BlueJ 3.1.6");
        }
    }

    public static PkgMgrFrame createFrame() {
        PkgMgrFrame frame = new PkgMgrFrame();
        frames.add(frame);
        BlueJEvent.addListener(frame);
        frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Window w = e.getWindow();
                if (w instanceof PkgMgrFrame) {
                    recentFrame = (PkgMgrFrame)w;
                }
            }
        });
        return frame;
    }

    public static PkgMgrFrame createFrame(Package pkg) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
        if (pmf == null) {
            if (frames.size() == 1) {
                pmf = frames.get(0);
            }
            if (pmf == null || !pmf.isEmptyFrame()) {
                pmf = PkgMgrFrame.createFrame();
            }
            pmf.openPackage(pkg);
        }
        return pmf;
    }

    public static void closeFrame(PkgMgrFrame frame) {
        if (!frame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        frames.remove(frame);
        BlueJEvent.removeListener(frame);
        PrefMgr.setFlag("bluej.startWithTextEval", frame.showingTextEvaluator);
        frame.dispose();
    }

    public static PkgMgrFrame findFrame(Package pkg) {
        for (PkgMgrFrame pmf : frames) {
            if (pmf.isEmptyFrame() || pmf.getPackage() != pkg) continue;
            return pmf;
        }
        return null;
    }

    public static int frameCount() {
        return frames.size();
    }

    public static PkgMgrFrame[] getAllFrames() {
        PkgMgrFrame[] openFrames = new PkgMgrFrame[frames.size()];
        frames.toArray(openFrames);
        return openFrames;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj) {
        return PkgMgrFrame.getAllProjectFrames(proj, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj, String pkgPrefix) {
        ArrayList<PkgMgrFrame> list = new ArrayList<PkgMgrFrame>();
        String pkgPrefixWithDot = pkgPrefix + ".";
        for (PkgMgrFrame pmf : frames) {
            if (pmf.isEmptyFrame() || pmf.getProject() != proj) continue;
            String fullName = pmf.getPackage().getQualifiedName();
            if (fullName.startsWith(pkgPrefixWithDot)) {
                list.add(pmf);
                continue;
            }
            if (!fullName.equals(pkgPrefix) && pkgPrefix.length() != 0) continue;
            list.add(pmf);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new PkgMgrFrame[list.size()]);
    }

    public static PkgMgrFrame getMostRecent() {
        if (recentFrame != null) {
            return recentFrame;
        }
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllFrames();
        if (allFrames.length < 1) {
            return null;
        }
        PkgMgrFrame mostRecent = allFrames[0];
        for (PkgMgrFrame allFrame : allFrames) {
            if (allFrame.getFocusOwner() == null) continue;
            mostRecent = allFrame;
        }
        return mostRecent;
    }

    public static void handleAbout() {
        HelpAboutAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handlePreferences() {
        PreferencesAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handleQuit() {
        QuitAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void updateTestingStatus() {
        if (testToolsShown != PkgMgrFrame.wantToSeeTestingTools()) {
            frames.stream().forEach(pmf -> {
                if (pmf.isJavaMEpackage()) {
                    pmf.showTestingTools(false);
                } else {
                    pmf.showTestingTools(!testToolsShown);
                }
            });
            testToolsShown = !testToolsShown;
        }
    }

    private static boolean wantToSeeTestingTools() {
        return PrefMgr.getFlag("bluej.testing.showtools");
    }

    public static void updateTeamStatus() {
        if (teamToolsShown != PkgMgrFrame.wantToSeeTeamTools()) {
            Iterator<PkgMgrFrame> i = frames.iterator();
            while (i.hasNext()) {
                i.next().showTeamTools(!teamToolsShown);
            }
            teamToolsShown = !teamToolsShown;
        }
    }

    private static boolean wantToSeeTeamTools() {
        return PrefMgr.getFlag("bluej.teamwork.showtools");
    }

    public static void updateJavaMEstatus() {
        if (javaMEtoolsShown != PkgMgrFrame.wantToSeeJavaMEtools()) {
            Iterator<PkgMgrFrame> i = frames.iterator();
            while (i.hasNext()) {
                i.next().showJavaMEtools(!javaMEtoolsShown);
            }
            javaMEtoolsShown = !javaMEtoolsShown;
        }
    }

    private static boolean wantToSeeJavaMEtools() {
        return PrefMgr.getFlag("bluej.javame.showtools");
    }

    public static void displayMessage(String message) {
        frames.stream().forEach(frame -> frame.setStatus(message));
    }

    public static void displayMessage(Package sourcePkg, String message) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            pmf.setStatus(message);
        }
    }

    public static void displayMessage(Project sourceProj, String message) {
        PkgMgrFrame[] pmf = PkgMgrFrame.getAllProjectFrames(sourceProj);
        if (pmf != null) {
            for (PkgMgrFrame pmf1 : pmf) {
                if (pmf1 == null) continue;
                pmf1.setStatus(message);
            }
        }
    }

    public static void showError(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showError(pmf, msgId);
        }
    }

    public static void showMessage(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessage(pmf, msgId);
        }
    }

    public static void showMessageWithText(Package sourcePkg, String msgId, String text) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessageWithText((Component)pmf, msgId, text);
        }
    }

    public static boolean doOpen(File projectPath, PkgMgrFrame pmf) {
        boolean createdNewFrame = false;
        if (pmf == null && frames.size() > 0) {
            pmf = frames.get(0);
        } else if (pmf == null) {
            pmf = PkgMgrFrame.createFrame();
            createdNewFrame = true;
        }
        boolean openedProject = false;
        if (projectPath != null) {
            if (projectPath.isDirectory() || Project.isProject(projectPath.toString())) {
                if (pmf.openProject(projectPath.getAbsolutePath())) {
                    openedProject = true;
                }
            } else if (pmf.openArchive(projectPath)) {
                openedProject = true;
            }
        }
        if (createdNewFrame && !openedProject) {
            PkgMgrFrame.closeFrame(pmf);
        }
        return openedProject;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllProjectFrames(project);
        if (allFrames != null) {
            for (PkgMgrFrame allFrame : allFrames) {
                allFrame.doClose(true, true);
            }
        }
    }

    @OnThread(value=Tag.Any)
    public static PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        int orientation = Config.getPropInteger("bluej.printer.paper.orientation", pageFormat.getOrientation());
        pageFormat.setOrientation(orientation);
        Paper paper = pageFormat.getPaper();
        int x = Config.getPropInteger("bluej.printer.paper.x", 72);
        int y = Config.getPropInteger("bluej.printer.paper.y", 72);
        int width = Config.getPropInteger("bluej.printer.paper.width", (int)paper.getWidth() - 72 - x);
        int height = Config.getPropInteger("bluej.printer.paper.height", (int)paper.getHeight() - 72 - y);
        paper.setImageableArea(x, y, width, height);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static void setPageFormat(PageFormat page) {
        pageFormat = page;
        Paper paper = pageFormat.getPaper();
        double x = paper.getImageableX();
        double y = paper.getImageableY();
        double width = paper.getImageableWidth();
        double height = paper.getImageableHeight();
        Config.putPropInteger("bluej.printer.paper.x", (int)x);
        Config.putPropInteger("bluej.printer.paper.y", (int)y);
        Config.putPropInteger("bluej.printer.paper.width", (int)width);
        Config.putPropInteger("bluej.printer.paper.height", (int)height);
        int orientation = pageFormat.getOrientation();
        Config.putPropInteger("bluej.printer.paper.orientation", orientation);
    }

    public void openPackage(Package pkg) {
        if (pkg == null) {
            throw new NullPointerException();
        }
        if (this.pkg != null) {
            this.closePackage();
        }
        this.pkg = pkg;
        if (!Config.isGreenfoot()) {
            this.editor = new PackageEditor(pkg, this);
            this.editor.getAccessibleContext().setAccessibleName(Config.getString("pkgmgr.graphEditor.title"));
            this.editor.setFocusable(true);
            this.editor.setTransferHandler(new FileTransferHandler(this));
            this.editor.addMouseListener(this);
            this.editor.startMouseListening();
            pkg.setEditor(this.editor);
            this.addCtrlTabShortcut(this.editor);
            this.classScroller.setViewportView(this.editor);
            Properties p = pkg.getLastSavedProperties();
            try {
                String width_str = p.getProperty("package.editor.width", Integer.toString(560));
                String height_str = p.getProperty("package.editor.height", Integer.toString(400));
                this.classScroller.setPreferredSize(new Dimension(Integer.parseInt(width_str), Integer.parseInt(height_str)));
                String objectBench_height_str = p.getProperty("objectbench.height");
                String objectBench_width_str = p.getProperty("objectbench.width");
                if (objectBench_height_str != null && objectBench_width_str != null) {
                    this.objbench.setPreferredSize(new Dimension(Integer.parseInt(objectBench_width_str), Integer.parseInt(objectBench_height_str)));
                }
                String x_str = p.getProperty("package.editor.x", "30");
                String y_str = p.getProperty("package.editor.y", "30");
                int x = Integer.parseInt(x_str);
                int y = Integer.parseInt(y_str);
                if (x > Config.screenBounds.width - 80) {
                    x = Config.screenBounds.width - 80;
                }
                if (y > Config.screenBounds.height - 80) {
                    y = Config.screenBounds.height - 80;
                }
                this.setLocation(x, y);
            }
            catch (NumberFormatException e) {
                Debug.reportError("Could not read preferred project screen position");
            }
            String uses_str = p.getProperty("package.showUses", "true");
            String extends_str = p.getProperty("package.showExtends", "true");
            this.showUsesMenuItem.setSelected(uses_str.equals("true"));
            this.showExtendsMenuItem.setSelected(extends_str.equals("true"));
            this.updateShowUsesInPackage();
            this.updateShowExtendsInPackage();
            this.pack();
            this.editor.revalidate();
            this.editor.requestFocus();
            this.enableFunctions(true);
            this.updateWindow();
            this.setVisible(true);
            this.updateTextEvalBackground(this.isEmptyFrame());
            this.toolsMenuManager.setMenuGenerator(new ToolsExtensionMenu(pkg));
            this.toolsMenuManager.addExtensionMenu(pkg.getProject());
            this.viewMenuManager.setMenuGenerator(new ViewExtensionMenu(pkg));
            this.viewMenuManager.addExtensionMenu(pkg.getProject());
            this.teamActions = pkg.getProject().getTeamActions();
            this.resetTeamActions();
            if (this.getProject().isJavaMEProject()) {
                this.showJavaMEcontrols(true);
                this.showTestingTools(false);
            } else {
                this.showTestingTools(PkgMgrFrame.wantToSeeTestingTools());
            }
        }
        DataCollector.packageOpened(pkg);
        extMgr.packageOpened(pkg);
    }

    private void showJavaMEcontrols(boolean show) {
        this.javaMEdeployMenuItem.setVisible(show);
        this.javaMEPanel.setVisible(show);
    }

    public void doDeployMIDlet() {
        MIDletDeployer deployer = new MIDletDeployer(this);
        deployer.deploy();
    }

    private void resetTeamActions() {
        this.teamStatusButton.setAction(this.teamActions.getStatusAction());
        this.updateButton.setAction(this.teamActions.getUpdateAction());
        this.teamSettingsMenuItem.setAction(this.teamActions.getTeamSettingsAction());
        this.commitButton.setAction(this.teamActions.getCommitCommentAction());
        this.shareProjectMenuItem.setAction(this.teamActions.getImportAction());
        this.statusMenuItem.setAction(this.teamActions.getStatusAction());
        this.commitMenuItem.setAction(this.teamActions.getCommitCommentAction());
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.updateMenuItem.setAction(this.teamActions.getUpdateAction());
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.showLogMenuItem.setAction(this.teamActions.getShowLogAction());
    }

    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        extMgr.packageClosing(this.pkg);
        if (!Config.isGreenfoot()) {
            this.classScroller.setViewportView(null);
            this.classScroller.setBorder(Config.getNormalBorder());
            this.editor.removeMouseListener(this);
            this.toolsMenuManager.setMenuGenerator(new ToolsExtensionMenu(this.pkg));
            this.viewMenuManager.setMenuGenerator(new ViewExtensionMenu(this.pkg));
            this.getObjectBench().removeAllObjects(this.getProject().getUniqueId());
            this.clearTextEval();
            this.updateTextEvalBackground(true);
            this.showJavaMEcontrols(false);
            this.editor.graphClosed();
        }
        this.getPackage().closeAllEditors();
        DataCollector.packageClosed(this.pkg);
        Project proj = this.getProject();
        this.editor = null;
        this.pkg = null;
        if (PkgMgrFrame.getAllProjectFrames(proj) == null) {
            Project.cleanUp(proj);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(false);
        } else if (!Config.isGreenfoot()) {
            super.setVisible(true);
            this.setState(0);
        }
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Project getProject() {
        return this.pkg == null ? null : this.pkg.getProject();
    }

    public boolean isEmptyFrame() {
        return this.pkg == null;
    }

    private void updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
        } else {
            String title = Config.getString("pkgmgr.title") + this.getProject().getProjectName();
            if (!this.getPackage().isUnnamedPackage()) {
                title = title + "  [" + this.getPackage().getQualifiedName() + "]";
            }
            if (this.getProject().isTeamProject()) {
                title = title + " (" + Config.getString("team.project.marker") + ")";
            }
            this.setTitle(title);
        }
    }

    private void updateWindow() {
        if (this.isEmptyFrame()) {
            this.classScroller.setViewportView(this.noProjectMessagePanel);
            this.repaint();
        }
        this.updateWindowTitle();
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public final void setStatus(String status) {
        EventQueue.invokeLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(status);
            }
        });
    }

    @OnThread(value=Tag.Any)
    public void startProgress() {
        this.progressbar.setRunning(true);
    }

    @OnThread(value=Tag.Any)
    public void stopProgress() {
        this.progressbar.setRunning(false);
    }

    @OnThread(value=Tag.Any)
    public void clearStatus() {
        EventQueue.invokeLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(" ");
            }
        });
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    public TextEvalArea getCodePad() {
        return this.textEvaluator;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.clearStatus();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void pkgEditorGotFocus() {
        this.classScroller.setBorder(Config.getFocusBorder());
    }

    @Override
    public void pkgEditorLostFocus() {
        this.classScroller.setBorder(Config.getNormalBorder());
    }

    @Override
    public void targetEvent(PackageEditorEvent e) {
        int evtId = e.getID();
        switch (evtId) {
            case 1: {
                this.callMethod(e.getCallable());
                break;
            }
            case 2: {
                ((Target)e.getSource()).remove();
                break;
            }
            case 3: {
                this.openPackageTarget(e.getName());
                break;
            }
            case 4: {
                ClassTarget ct = (ClassTarget)e.getSource();
                ct.getRole().run(this, ct, e.getName());
                break;
            }
            case 5: {
                this.objectBenchToTestFixture((ClassTarget)e.getSource());
                break;
            }
            case 6: {
                this.testFixtureToObjectBench((ClassTarget)e.getSource());
                break;
            }
            case 7: {
                this.makeTestCase((ClassTarget)e.getSource());
                break;
            }
            case 8: {
                DebuggerObject gotObj = e.getDebuggerObject();
                boolean tryAgain = true;
                do {
                    String newObjectName;
                    if ((newObjectName = DialogManager.askString((Component)e.getSource(), "getobject-new-name", this.getProject().getDebugger().guessNewName(gotObj))) == null) {
                        tryAgain = false;
                        continue;
                    }
                    if (JavaNames.isIdentifier(newObjectName)) {
                        DataCollector.benchGet(this.getPackage(), newObjectName, e.getDebuggerObject().getClassName(), this.getTestIdentifier());
                        this.putObjectOnBench(newObjectName, e.getDebuggerObject(), e.getIType(), e.getInvokerRecord());
                        tryAgain = false;
                        continue;
                    }
                    DialogManager.showError((Component)e.getSource(), "must-be-identifier");
                } while (tryAgain);
            }
        }
    }

    @Override
    public void recordInteraction(InvokerRecord ir) {
        this.getObjectBench().addInteraction(ir);
    }

    public int getTestIdentifier() {
        return this.testIdentifier;
    }

    public boolean newProject(String dirName, boolean isJavaMEproject) {
        if (Project.createNewProject(dirName, isJavaMEproject)) {
            Project proj = Project.openProject(dirName, this);
            Package unNamedPkg = proj.getPackage("");
            if (this.isEmptyFrame()) {
                this.openPackage(unNamedPkg);
            } else {
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(unNamedPkg);
                DialogManager.tileWindow(pmf, this);
                pmf.setVisible(true);
            }
            return true;
        }
        return false;
    }

    public File[] importProjectDir(File dir, boolean showFailureDialog) {
        Object[] fails = FileUtility.recursiveCopyFile(dir, this.getPackage().getPath());
        if (fails != null && showFailureDialog) {
            ImportFailedDialog importFailedDlg = new ImportFailedDialog(this, fails);
            importFailedDlg.setVisible(true);
        }
        List<File> dirsToConvert = Import.findInterestingDirectories(this.getPackage().getPath());
        Import.convertDirectory(dirsToConvert);
        this.getProject().reloadAll();
        return fails;
    }

    public boolean createNewClass(String name, String template, boolean showErr) {
        boolean success;
        if (this.pkg.getTarget(name) != null) {
            DialogManager.showError(this, "duplicate-name");
            return false;
        }
        String[] conflict = new String[1];
        Class<?> c = this.pkg.loadClass(this.pkg.getQualifiedName(name));
        if (c != null && !Package.checkClassMatchesFile(c, new File(this.getPackage().getPath(), name + ".class"))) {
            conflict[0] = Package.getResourcePath(c);
            if (DialogManager.askQuestion((Component)this, "class-library-conflict", conflict) == 0) {
                return false;
            }
        }
        ClassTarget target = new ClassTarget(this.pkg, name, template);
        if (template != null && !(success = target.generateSkeleton(template))) {
            return false;
        }
        this.pkg.findSpaceForVertex(target);
        this.pkg.addTarget(target);
        if (this.editor != null) {
            this.editor.revalidate();
            this.editor.scrollRectToVisible(target.getBounds());
            this.editor.repaint();
        }
        if (target.getRole() instanceof UnitTestClassRole) {
            this.pkg.compileQuiet(target);
        }
        this.pkg.getProject().scheduleCompilation(false);
        DataCollector.addClass(this.pkg, target.getSourceFile());
        return true;
    }

    public boolean doNewProject(boolean isJavaMEproject) {
        File newnameFile;
        String title = Config.getString("pkgmgr.newPkg.title");
        if (isJavaMEproject) {
            title = Config.getString("pkgmgr.newMEpkg.title");
        }
        if ((newnameFile = FileUtility.getDirName(this, title, Config.getString("pkgmgr.newPkg.buttonLabel"), false, true)) == null) {
            return false;
        }
        if (newnameFile.exists()) {
            if (!newnameFile.isDirectory()) {
                DialogManager.showError(null, "directory-exists-file");
                return false;
            }
            if (newnameFile.list().length > 0) {
                Debug.message("Attempt to create project with existing non-empty directory: " + newnameFile.getAbsolutePath());
                DialogManager.showError(null, "directory-exists-non-empty");
                return false;
            }
        }
        if (!this.newProject(newnameFile.getAbsolutePath(), isJavaMEproject)) {
            DialogManager.showErrorWithText(null, "cannot-create-directory", newnameFile.getPath());
            return false;
        }
        return true;
    }

    public void doOpen() {
        File dirName = FileUtility.getPackageName(this);
        PkgMgrFrame.doOpen(dirName, this);
    }

    private boolean openProject(String projectPath) {
        Project openProj = Project.openProject(projectPath, this);
        if (openProj == null) {
            return false;
        }
        Package initialPkg = openProj.getPackage(openProj.getInitialPackageName());
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(initialPkg);
        if (pmf == null) {
            if (this.isEmptyFrame()) {
                pmf = this;
                this.openPackage(initialPkg);
            } else {
                pmf = PkgMgrFrame.createFrame(initialPkg);
                DialogManager.tileWindow(pmf, this);
            }
        }
        pmf.setVisible(true);
        return true;
    }

    public void doOpenNonBlueJ() {
        File dirName = FileUtility.getNonBlueJDirectoryName(this);
        if (dirName == null) {
            return;
        }
        File absDirName = dirName.getAbsoluteFile();
        if (!absDirName.exists()) {
            DialogManager.showError(this, "file-does-not-exist");
            return;
        }
        if (absDirName.isDirectory()) {
            if (Project.isProject(absDirName.getPath())) {
                DialogManager.showError(this, "open-non-bluej-already-bluej");
                return;
            }
            if (!Import.convertNonBlueJ(this, absDirName)) {
                return;
            }
            this.openProject(absDirName.getPath());
        } else {
            this.openArchive(absDirName);
        }
    }

    private boolean openArchive(File archive) {
        File oPath = Utility.maybeExtractArchive(archive, this);
        if (oPath == null) {
            return false;
        }
        if (Project.isProject(oPath.getPath())) {
            return this.openProject(oPath.getPath());
        }
        if (Import.convertNonBlueJ(this, oPath)) {
            return this.openProject(oPath.getPath());
        }
        return false;
    }

    public void doClose(boolean keepLastFrame, boolean doSave) {
        if (doSave) {
            this.doSave();
        }
        if (PkgMgrFrame.frameCount() == 1) {
            if (keepLastFrame && !Config.isGreenfoot()) {
                this.testRecordingEnded();
                this.closePackage();
                this.updateRecentProjects();
                this.enableFunctions(false);
                this.updateWindow();
                this.toolsMenuManager.addExtensionMenu(null);
                this.viewMenuManager.addExtensionMenu(null);
            } else {
                Main.doQuit();
            }
        } else {
            this.closePackage();
            PkgMgrFrame.closeFrame(this);
        }
    }

    public void doSave() {
        if (this.isEmptyFrame()) {
            return;
        }
        Properties p = this.pkg.isUnnamedPackage() ? this.getProject().getProjectProperties() : new Properties();
        if (!Config.isGreenfoot()) {
            Dimension d = this.classScroller.getSize();
            p.put("package.editor.width", Integer.toString(d.width));
            p.put("package.editor.height", Integer.toString(d.height));
            Point point = this.getLocation();
            p.put("package.editor.x", Integer.toString(point.x));
            p.put("package.editor.y", Integer.toString(point.y));
            d = this.objbench.getSize();
            p.put("objectbench.width", Integer.toString(d.width));
            p.put("objectbench.height", Integer.toString(d.height));
            p.put("package.showUses", Boolean.toString(this.isShowUses()));
            p.put("package.showExtends", Boolean.toString(this.isShowExtends()));
        }
        this.pkg.save(p);
    }

    public void doImport() {
        File importDir = FileUtility.getDirName(this, Config.getString("pkgmgr.importPkg.title"), Config.getString("pkgmgr.importPkg.buttonLabel"), true, false);
        if (importDir == null) {
            return;
        }
        if (!importDir.isDirectory()) {
            return;
        }
        if (this.isEmptyFrame()) {
            return;
        }
        this.importProjectDir(importDir, true);
    }

    public void doAddFromFile() {
        File[] classes = FileUtility.getMultipleFiles(this, Config.getString("pkgmgr.addClass.title"), Config.getString("pkgmgr.addClass.buttonLabel"), FileUtility.getJavaSourceFilter());
        if (classes == null) {
            return;
        }
        this.importFromFile(classes);
    }

    public void addFiles(List<File> classes) {
        this.importFromFile(classes.toArray(new File[classes.size()]));
    }

    private void importFromFile(File[] classes) {
        block7: for (File cls : classes) {
            int result = this.pkg.importFile(cls);
            switch (result) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    DialogManager.showErrorWithText(this, "file-does-not-exist", cls.getName());
                    continue block7;
                }
                case 2: {
                    DialogManager.showErrorWithText(this, "cannot-import", cls.getName());
                    continue block7;
                }
                case 4: {
                    DialogManager.showErrorWithText(this, "duplicate-name", cls.getName());
                    continue block7;
                }
                case 3: {
                    DialogManager.showErrorWithText(this, "error-in-import", cls.getName());
                }
            }
        }
    }

    public void doExport() {
        if (this.exporter == null) {
            this.exporter = new ExportManager(this);
        }
        this.exporter.export();
    }

    public void doPageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pfmt = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat(pfmt);
    }

    public void doPrint() {
        if (this.projectPrintDialog == null) {
            this.projectPrintDialog = new ProjectPrintDialog(this);
        }
        if (this.projectPrintDialog.display()) {
            PackagePrintManager printManager = new PackagePrintManager(this.getPackage(), PkgMgrFrame.getPageFormat(), this.projectPrintDialog);
            printManager.start();
        }
    }

    public void showPreferences() {
        PrefMgrDialog.showDialog();
    }

    public void aboutBlueJ() {
        AboutBlue about = new AboutBlue(this, "3.1.6");
        about.setVisible(true);
    }

    public void showCopyright() {
        JOptionPane.showMessageDialog(this, new String[]{Config.getString("menu.help.copyright.line0"), " ", Config.getString("menu.help.copyright.line1"), Config.getString("menu.help.copyright.line2"), Config.getString("menu.help.copyright.line3"), Config.getString("menu.help.copyright.line4")}, Config.getString("menu.help.copyright.title"), 1);
    }

    private void callMethod(final CallableView cv) {
        ResultWatcher watcher = null;
        if (cv instanceof ConstructorView) {
            watcher = new ResultWatcher(){

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setWaitCursor(true);
                    PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.creating"));
                }

                @Override
                public void beginExecution(InvokerRecord ir) {
                    BlueJEvent.raiseEvent(3, ir);
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("Normal exit");
                    executionEvent.setResultObject(result);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.getPackage().getProject().updateInspectors();
                    PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.createDone"));
                    if (name == null || name.length() == 0) {
                        name = "result";
                    }
                    if (result != null) {
                        ObjectWrapper wrapper = ObjectWrapper.getWrapper(PkgMgrFrame.this, PkgMgrFrame.this.getObjectBench(), result, result.getGenType(), name);
                        PkgMgrFrame.this.getObjectBench().addObject(wrapper);
                        PkgMgrFrame.this.getPackage().getDebugger().addObject(PkgMgrFrame.this.pkg.getId(), wrapper.getName(), result);
                        PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    }
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    PkgMgrFrame.this.setStatus("");
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("An exception occurred");
                    executionEvent.setException(exception);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.setStatus("");
                    PkgMgrFrame.this.getPackage().exceptionMessage(exception);
                    PkgMgrFrame.this.getPackage().getProject().updateInspectors();
                }

                @Override
                public void putVMTerminated(InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("User terminated");
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.setStatus("");
                }
            };
        } else if (cv instanceof MethodView) {
            final MethodView mv = (MethodView)cv;
            watcher = new ResultWatcher(){
                private final ExpressionInformation expressionInformation;
                {
                    this.expressionInformation = new ExpressionInformation(mv, PkgMgrFrame.this.getName());
                }

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setWaitCursor(true);
                    if (mv.isMain()) {
                        PkgMgrFrame.this.getProject().removeClassLoader();
                        PkgMgrFrame.this.getProject().newRemoteClassLoaderLeavingBreakpoints();
                    }
                }

                @Override
                public void beginExecution(InvokerRecord ir) {
                    BlueJEvent.raiseEvent(3, ir);
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setMethodName(mv.getName());
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("Normal exit");
                    executionEvent.setResultObject(result);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.getPackage().getProject().updateInspectors();
                    this.expressionInformation.setArgumentValues(ir.getArgumentValues());
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    if (name == null) {
                        return;
                    }
                    if (result == null) {
                        return;
                    }
                    PkgMgrFrame.this.getProject().getResultInspectorInstance(result, name, PkgMgrFrame.this.getPackage(), ir, this.expressionInformation, PkgMgrFrame.this);
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("An exception occurred");
                    executionEvent.setException(exception);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.getPackage().getProject().updateInspectors();
                    PkgMgrFrame.this.getPackage().exceptionMessage(exception);
                }

                @Override
                public void putVMTerminated(InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("User terminated");
                    BlueJEvent.raiseEvent(5, executionEvent);
                }
            };
        }
        if (this.checkDebuggerState()) {
            new Invoker(this, cv, watcher).invokeInteractive();
        }
    }

    private void openPackageTarget(String newname) {
        Package p = this.getPackage().getProject().getPackage(newname);
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(p);
        if (pmf == null) {
            pmf = PkgMgrFrame.createFrame(p);
            DialogManager.tileWindow(pmf, this);
        }
        pmf.setVisible(true);
    }

    private void objectBenchToTestFixture(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doBenchToFixture(this, target);
        }
    }

    private void testFixtureToObjectBench(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doFixtureToBench(this, target);
        }
    }

    private void makeTestCase(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            if (!testToolsShown) {
                this.showTestingTools(true);
            }
            utcr.doMakeTestCase(this, target);
        }
    }

    public String putObjectOnBench(String newInstanceName, DebuggerObject object, GenTypeClass iType, InvokerRecord ir) {
        if (!object.isNullObject()) {
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this, this.getObjectBench(), object, iType, newInstanceName);
            this.getObjectBench().addObject(wrapper);
            newInstanceName = wrapper.getName();
            this.getPackage().getDebugger().addObject(this.pkg.getId(), newInstanceName, object);
            if (ir != null) {
                ir.setBenchName(newInstanceName, wrapper.getTypeName());
            }
            return newInstanceName;
        }
        return null;
    }

    public void doCreateNewClass() {
        NewClassDialog dlg = new NewClassDialog(this, this.isJavaMEpackage());
        boolean okay = dlg.display();
        if (okay) {
            String name = dlg.getClassName();
            String template = dlg.getTemplateName();
            this.createNewClass(name, template, true);
        }
    }

    public void doCreateNewPackage() {
        NewPackageDialog dlg = new NewPackageDialog(this);
        boolean okay = dlg.display();
        if (!okay) {
            return;
        }
        String name = dlg.getPackageName();
        if (name.length() == 0) {
            return;
        }
        this.createNewPackage(name, true);
    }

    public boolean createNewPackage(String name, boolean showErrDialog) {
        String fullName = name.indexOf(46) > -1 ? name : this.getPackage().getQualifiedName(name);
        String prefix = JavaNames.getPrefix(fullName);
        String base = JavaNames.getBase(fullName);
        Package basePkg = this.getProject().getPackage(prefix);
        if (basePkg != null && basePkg.getTarget(base) != null) {
            if (showErrDialog) {
                DialogManager.showError(this, "duplicate-name");
            }
            return false;
        }
        this.getProject().createPackageDirectory(fullName);
        Package newPackage = this.getProject().getPackage(fullName);
        if (newPackage == null) {
            Debug.reportError("creation of new package failed unexpectedly");
            return false;
        }
        for (newPackage = newPackage.getParent(); newPackage != null; newPackage = newPackage.getParent()) {
            newPackage.reload();
        }
        return true;
    }

    public void doRemove() {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (permanentFocusOwner == this.editor || Arrays.asList(this.editor.getComponents()).contains(permanentFocusOwner)) {
            if (!this.doRemoveTargets() && !this.doRemoveDependency()) {
                DialogManager.showError(this, "no-class-selected");
            }
        } else if (permanentFocusOwner == this.objbench || this.objbench.getObjects().contains(permanentFocusOwner)) {
            this.objbench.removeSelectedObject(this.pkg.getId());
        }
    }

    private boolean doRemoveTargets() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length <= 0) {
            return false;
        }
        if (this.askRemoveClass()) {
            for (Target target : targets) {
                target.remove();
            }
        }
        return true;
    }

    private boolean doRemoveDependency() {
        Dependency dependency = this.pkg.getSelectedDependency();
        if (dependency == null) {
            return false;
        }
        dependency.remove();
        return true;
    }

    public void doNewUses() {
        this.pkg.setState(1);
        this.setStatus(Config.getString("pkgmgr.chooseUsesFrom"));
        this.pkg.getEditor().clearSelection();
    }

    public void doNewInherits() {
        this.pkg.setState(3);
        this.setStatus(Config.getString("pkgmgr.chooseInhFrom"));
        this.editor.clearSelection();
    }

    public void doTest() {
        this.runButton.setEnabled(false);
        List<ClassTarget> l = this.pkg.getTestTargets();
        int numTests = 0;
        ListIterator<ClassTarget> i = l.listIterator();
        while (i.hasNext()) {
            ClassTarget ct = i.next();
            if (ct.isCompiled() && !ct.isAbstract()) {
                UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
                numTests += utcr.getTestCount(ct);
                continue;
            }
            i.remove();
        }
        Iterator<ClassTarget> it = l.iterator();
        TestDisplayFrame.getTestDisplay().startMultipleTests(numTests);
        TestRunnerThread trt = new TestRunnerThread(this, it);
        trt.start();
    }

    public void endTestRun() {
        TestDisplayFrame.getTestDisplay().endMultipleTests();
        this.runButton.setEnabled(true);
    }

    public void doEndTest() {
        if (this.testTarget != null) {
            this.testRecordingEnded();
            DataCollector.endTestMethod(this.getPackage(), this.testIdentifier);
            if (this.testTarget.getRole() instanceof UnitTestClassRole) {
                UnitTestClassRole utcr = (UnitTestClassRole)this.testTarget.getRole();
                utcr.doEndMakeTestCase(this, this.testTarget, this.testTargetMethod);
            }
            this.getPackage().compileQuiet(this.testTarget);
            this.getProject().removeClassLoader();
            this.getProject().newRemoteClassLoaderLeavingBreakpoints();
            this.testTarget = null;
        }
    }

    public void doCancelTest() {
        this.testRecordingEnded();
        DataCollector.cancelTestMethod(this.getPackage(), this.testIdentifier);
        this.getProject().removeClassLoader();
        this.getProject().newRemoteClassLoaderLeavingBreakpoints();
        this.testTarget = null;
    }

    public void testRecordingStarted(String message) {
        this.recordingLabel.setEnabled(true);
        this.testStatusMessage.setText(message);
        this.endTestButton.setEnabled(true);
        this.endTestMenuItem.setEnabled(true);
        this.cancelTestButton.setEnabled(true);
        this.cancelTestMenuItem.setEnabled(true);
        this.getProject().setTestMode(true);
    }

    private void testRecordingEnded() {
        this.recordingLabel.setEnabled(false);
        this.testStatusMessage.setText("");
        this.endTestButton.setEnabled(false);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestButton.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        Project proj = this.getProject();
        if (proj != null) {
            proj.setTestMode(false);
        }
    }

    public void setTestInfo(String testName, ClassTarget testClass) {
        this.testTargetMethod = testName;
        this.testTarget = testClass;
        this.testIdentifier = nextTestIdentifier.incrementAndGet();
        DataCollector.startTestMethod(this.getPackage(), this.testIdentifier, testClass.getSourceFile(), testName);
    }

    public boolean askRemoveClass() {
        int response = DialogManager.askQuestion(this, "really-remove-class");
        return response == 0;
    }

    public boolean askRemovePackage(PackageTarget removableTarget) {
        String name = removableTarget.getQualifiedName();
        PkgMgrFrame[] f = PkgMgrFrame.getAllProjectFrames(this.getProject(), name);
        if (f != null) {
            DialogManager.showError(this, "remove-package-open");
            return false;
        }
        int response = DialogManager.askQuestion(this, "really-remove-package");
        return response == 0;
    }

    public void compileSelected() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length > 0) {
            for (Target target : targets) {
                ClassTarget t;
                if (!(target instanceof ClassTarget) || !(t = (ClassTarget)target).hasSourceCode()) continue;
                this.pkg.compile(t);
            }
        } else {
            DialogManager.showError(this, "no-class-selected-compile");
        }
    }

    public void callLibraryClass() {
        if (this.libraryCallDialog == null) {
            this.libraryCallDialog = new LibraryCallDialog(this);
        }
        this.libraryCallDialog.setVisible(true);
    }

    public void generateProjectDocumentation() {
        String message = this.pkg.generateDocumentation();
        if (message.length() != 0) {
            DialogManager.showText(this, message);
        }
    }

    public boolean checkDebuggerState() {
        Debugger debugger = this.getProject().getDebugger();
        if (debugger.getStatus() == 4) {
            this.setVisible(true);
            DialogManager.showError(this, "stuck-at-breakpoint");
            return false;
        }
        if (debugger.getStatus() == 3) {
            this.setVisible(true);
            DialogManager.showError(this, "already-executing");
            return false;
        }
        return true;
    }

    public void showDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().getExecControls().showHide(true);
        }
    }

    public void restartDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().restartVM();
            DataCollector.restartVM(this.getProject());
        }
    }

    public void updateShowUsesInPackage() {
        this.pkg.setShowUses(this.isShowUses());
        this.editor.repaint();
    }

    public void updateShowExtendsInPackage() {
        this.pkg.setShowExtends(this.isShowExtends());
        this.editor.repaint();
    }

    public boolean isShowUses() {
        return this.showUsesMenuItem.isSelected();
    }

    public boolean isShowExtends() {
        return this.showExtendsMenuItem.isSelected();
    }

    public void showTestingTools(boolean show) {
        this.testItems.stream().forEach(component -> component.setVisible(show));
    }

    public void showTeamTools(boolean show) {
        this.teamItems.stream().forEach(component -> component.setVisible(show));
    }

    public void showJavaMEtools(boolean show) {
        this.javaMEnewProjMenuItem.setVisible(show);
    }

    public void updateSharedStatus(boolean shared) {
        this.updateWindow();
    }

    public boolean isTextEvalVisible() {
        return this.showingTextEvaluator;
    }

    public void showHideTextEval(boolean show) {
        if (this.showingTextEvaluator == show) {
            return;
        }
        if (show) {
            this.addTextEvaluatorPane();
            this.textEvaluator.requestFocus();
        } else {
            this.removeTextEvaluatorPane();
            this.editor.requestFocus();
        }
        this.pack();
        this.showingTextEvaluator = show;
    }

    public void clearTextEval() {
        if (this.textEvaluator != null) {
            this.textEvaluator.clear();
        }
    }

    public void updateTextEvalBackground(boolean emptyFrame) {
        if (this.textEvaluator != null) {
            this.textEvaluator.updateBackground(emptyFrame);
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 0: {
                this.setStatus(Config.getString("pkgmgr.creatingVM"));
                break;
            }
            case 2: {
                this.setStatus(Config.getString("pkgmgr.creatingVMDone"));
                break;
            }
            case 6: {
                this.setStatus(Config.getString("pkgmgr.generatingDocu"));
                break;
            }
            case 7: {
                this.setStatus(Config.getString("pkgmgr.docuGenerated"));
                break;
            }
            case 8: {
                this.setStatus(Config.getString("pkgmgr.docuAborted"));
                break;
            }
            case 1: {
                DialogManager.showError(this, "error-create-vm");
            }
        }
    }

    public void setDebuggerState(int state) {
        switch (state) {
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                if (this.machineIcon != null) {
                    this.machineIcon.setIdle();
                }
                this.getProject().getTerminal().activate(false);
                break;
            }
            case 3: {
                if (this.machineIcon != null) {
                    this.machineIcon.setRunning();
                }
                this.getProject().getTerminal().activate(true);
                break;
            }
            case 4: {
                if (this.machineIcon == null) break;
                this.machineIcon.setStopped();
            }
        }
    }

    @Override
    public String toString() {
        String str = "PkgMgrFrame(): ";
        str = this.isEmptyFrame() ? str + "empty" : str + this.getPackage().toString() + " " + this.getProject().toString();
        return str;
    }

    public void showWebPage(String url) {
        if (Utility.openWebBrowser(url)) {
            this.setStatus(Config.getString("pkgmgr.webBrowserMsg"));
        } else {
            this.setStatus(Config.getString("pkgmgr.webBrowserError"));
        }
    }

    private void makeFrame() {
        this.setFont(pkgMgrFont);
        Image icon = BlueJTheme.getIconImage();
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.testItems = new ArrayList<JComponent>();
        this.teamItems = new ArrayList<JComponent>();
        this.setupMenus();
        if (!Config.isRaspberryPi()) {
            this.setContentPane(new GradientFillPanel(this.getContentPane().getLayout()));
        } else {
            this.setContentPane(new JPanel(this.getContentPane().getLayout()));
        }
        Container contentPane = this.getContentPane();
        ((JPanel)contentPane).setBorder(BlueJTheme.generalBorderWithStatusBar);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        if (!Config.isRaspberryPi()) {
            mainPanel.setOpaque(false);
        }
        PkgMgrAction action = RestartVMAction.getInstance();
        mainPanel.getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), "restartVM");
        mainPanel.getActionMap().put("restartVM", action);
        JPanel toolPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            toolPanel.setOpaque(false);
        }
        this.buttonPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            this.buttonPanel.setOpaque(false);
        }
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        AbstractButton button = this.createButton(this.newClassAction, false, false, 4, 4);
        this.buttonPanel.add(button);
        if (!Config.isMacOSLeopard()) {
            this.buttonPanel.add(Box.createVerticalStrut(3));
        }
        this.imgDependsButton = this.createButton(this.newUsesAction, true, false, 4, 4);
        this.buttonPanel.add(this.imgDependsButton);
        if (!Config.isMacOSLeopard()) {
            this.buttonPanel.add(Box.createVerticalStrut(3));
        }
        this.imgExtendsButton = this.createButton(this.newInheritsAction, true, false, 4, 4);
        this.buttonPanel.add(this.imgExtendsButton);
        if (!Config.isMacOSLeopard()) {
            this.buttonPanel.add(Box.createVerticalStrut(3));
        }
        button = this.createButton(this.compileAction, false, false, 4, 4);
        this.buttonPanel.add(button);
        if (!Config.isMacOSLeopard()) {
            this.buttonPanel.add(Box.createVerticalStrut(3));
        }
        this.buttonPanel.setAlignmentX(0.5f);
        this.testPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            this.testPanel.setOpaque(false);
        }
        this.testPanel.setLayout(new BoxLayout(this.testPanel, 1));
        this.testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        this.runButton = this.createButton(this.runTestsAction, false, false, 2, 4);
        this.runButton.setText(Config.getString("pkgmgr.test.run"));
        this.runButton.setAlignmentX(0.15f);
        this.testPanel.add(this.runButton);
        this.testPanel.add(Box.createVerticalStrut(8));
        this.recordingLabel = new JLabel(Config.getString("pkgmgr.test.record"), Config.getFixedImageAsIcon("record.gif"), 10);
        this.recordingLabel.setFont(pkgMgrFont);
        this.recordingLabel.setEnabled(false);
        this.recordingLabel.setAlignmentX(0.15f);
        this.testPanel.add(this.recordingLabel);
        this.testPanel.add(Box.createVerticalStrut(3));
        action = EndTestRecordAction.getInstance();
        this.endTestButton = this.createButton(action, false, false, 2, 4);
        this.endTestButton.setText(Config.getString("pkgmgr.test.end"));
        this.endTestButton.setEnabled(false);
        this.testPanel.add(this.endTestButton);
        if (!Config.isMacOSLeopard()) {
            this.testPanel.add(Box.createVerticalStrut(3));
        }
        action = CancelTestRecordAction.getInstance();
        this.cancelTestButton = this.createButton(action, false, false, 2, 4);
        this.cancelTestButton.setText(Config.getString("cancel"));
        this.cancelTestButton.setEnabled(false);
        this.testPanel.add(this.cancelTestButton);
        this.testPanel.setAlignmentX(0.5f);
        this.testItems.add(this.testPanel);
        this.teamPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            this.teamPanel.setOpaque(false);
        }
        this.teamPanel.setLayout(new BoxLayout(this.teamPanel, 1));
        this.teamPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        this.updateButton = this.createButton(this.teamActions.getUpdateAction(), false, false, 2, 4);
        this.updateButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.updateButton);
        if (!Config.isMacOSLeopard()) {
            this.teamPanel.add(Box.createVerticalStrut(3));
        }
        this.commitButton = this.createButton(this.teamActions.getCommitCommentAction(), false, false, 2, 4);
        this.commitButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.commitButton);
        if (!Config.isMacOSLeopard()) {
            this.teamPanel.add(Box.createVerticalStrut(3));
        }
        this.teamStatusButton = this.createButton(this.teamActions.getStatusAction(), false, false, 2, 4);
        this.teamStatusButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.teamStatusButton);
        if (!Config.isMacOSLeopard()) {
            this.teamPanel.add(Box.createVerticalStrut(3));
        }
        this.teamPanel.setAlignmentX(0.5f);
        this.teamItems.add(this.teamPanel);
        this.javaMEPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            this.javaMEPanel.setOpaque(false);
        }
        this.javaMEPanel.setLayout(new BoxLayout(this.javaMEPanel, 1));
        this.javaMEPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        JLabel label = new JLabel("Java ME");
        label.setFont(new Font("SansSerif", 1, 12));
        label.setHorizontalAlignment(0);
        label.setForeground(label.getBackground().darker().darker());
        Dimension pref = label.getMinimumSize();
        pref.width = Integer.MAX_VALUE;
        label.setMaximumSize(pref);
        label.setAlignmentX(0.5f);
        this.javaMEPanel.add(label);
        this.javaMEPanel.add(Box.createVerticalStrut(4));
        AbstractButton button2 = this.createButton(this.deployMIDletAction, false, false, 4, 4);
        button2.setAlignmentX(0.5f);
        this.javaMEPanel.add(button2);
        this.javaMEPanel.add(Box.createVerticalStrut(4));
        if (!Config.isMacOSLeopard()) {
            this.javaMEPanel.add(Box.createVerticalStrut(3));
        }
        this.teamPanel.setAlignmentX(0.5f);
        this.machineIcon = new MachineIcon();
        this.machineIcon.setAlignmentX(0.5f);
        this.itemsToDisable.add(this.machineIcon);
        toolPanel.setLayout(new BoxLayout(toolPanel, 1));
        toolPanel.add(this.buttonPanel);
        toolPanel.add(Box.createVerticalGlue());
        toolPanel.add(this.teamPanel);
        toolPanel.add(this.javaMEPanel);
        toolPanel.add(this.testPanel);
        toolPanel.add(this.machineIcon);
        mainPanel.add((Component)toolPanel, "West");
        this.classScroller = new JScrollPane();
        this.classScroller.setBorder(Config.getNormalBorder());
        this.classScroller.setPreferredSize(new Dimension(560, 400));
        this.classScroller.setSize(new Dimension(560, 400));
        this.classScroller.setFocusable(false);
        this.classScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.classScroller.getHorizontalScrollBar().setUnitIncrement(20);
        if (!Config.isRaspberryPi()) {
            this.classScroller.setOpaque(false);
        }
        mainPanel.add((Component)this.classScroller, "Center");
        this.itemsToDisable.add(this.objbench);
        this.splitPane = new JSplitPane(0, mainPanel, this.objbench);
        this.splitPane.setBorder(null);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        if (!Config.isRaspberryPi()) {
            this.splitPane.setOpaque(false);
        }
        contentPane.add((Component)this.splitPane, "Center");
        JPanel statusArea = new JPanel(new BorderLayout());
        if (!Config.isRaspberryPi()) {
            statusArea.setOpaque(false);
        }
        statusArea.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 6));
        this.statusbar = new JLabel(" ");
        this.statusbar.setFont(pkgMgrFont);
        statusArea.add((Component)this.statusbar, "Center");
        this.testStatusMessage = new JLabel(" ");
        this.testStatusMessage.setFont(pkgMgrFont);
        statusArea.add((Component)this.testStatusMessage, "West");
        this.progressbar = new ActivityIndicator();
        this.progressbar.setRunning(false);
        statusArea.add((Component)this.progressbar, "East");
        contentPane.add((Component)statusArea, "South");
        if (!testToolsShown) {
            this.showTestingTools(false);
        }
        if (!teamToolsShown) {
            this.showTeamTools(false);
        }
        if (!javaMEtoolsShown) {
            this.showJavaMEtools(false);
        }
        this.javaMEPanel.setVisible(false);
        if (PrefMgr.getFlag("bluej.startWithTextEval")) {
            this.addTextEvaluatorPane();
        }
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                PkgMgrFrame pmf = (PkgMgrFrame)E.getWindow();
                pmf.doClose(false, true);
            }
        });
        if (this.isEmptyFrame()) {
            this.enableFunctions(false);
        }
    }

    private void addTextEvaluatorPane() {
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        if (this.textEvaluator == null) {
            this.textEvaluator = new TextEvalArea(this, pkgMgrFont);
            this.objectBenchSplitPane = new JSplitPane(1, this.objbench, this.textEvaluator);
            this.objectBenchSplitPane.setBorder(null);
            this.objectBenchSplitPane.setResizeWeight(1.0);
            this.objectBenchSplitPane.setDividerSize(5);
            if (!Config.isRaspberryPi()) {
                this.objectBenchSplitPane.setOpaque(false);
            }
            this.itemsToDisable.add(this.textEvaluator);
            this.addCtrlTabShortcut(this.textEvaluator.getFocusableComponent());
        } else {
            this.objectBenchSplitPane.setLeftComponent(this.objbench);
        }
        this.splitPane.setBottomComponent(this.objectBenchSplitPane);
        this.showingTextEvaluator = true;
    }

    private void removeTextEvaluatorPane() {
        this.textEvaluator.setPreferredSize(this.textEvaluator.getSize());
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        this.splitPane.setBottomComponent(this.objbench);
        this.showingTextEvaluator = false;
    }

    private AbstractButton createButton(Action action, boolean notext, boolean toggle, int hSpacing, int vSpacing) {
        AbstractButton button = toggle ? new JToggleButton(action) : new JButton(action);
        button.setFont(pkgMgrFont);
        Utility.changeToMacButton(button);
        button.setFocusable(false);
        if (notext) {
            button.setText(null);
        }
        Dimension pref = button.getMinimumSize();
        pref.width = Integer.MAX_VALUE;
        button.setMaximumSize(pref);
        if (!Config.isMacOSLeopard()) {
            button.setMargin(new Insets(vSpacing, hSpacing, vSpacing, hSpacing));
        }
        return button;
    }

    private void setupMenus() {
        this.menubar = new JMenuBar();
        this.itemsToDisable = new ArrayList<JComponent>();
        JMenu menu = new JMenu(Config.getString("menu.package"));
        int mnemonic = Config.getMnemonicKey("menu.package");
        menu.setMnemonic(mnemonic);
        this.menubar.add(menu);
        this.createMenuItem(NewProjectAction.getInstance(), menu);
        this.javaMEnewProjMenuItem = this.createMenuItem(NewMEprojectAction.getInstance(), menu);
        this.createMenuItem(OpenProjectAction.getInstance(), menu);
        this.recentProjectsMenu = new JMenu(Config.getString("menu.package.openRecent"));
        menu.add(this.recentProjectsMenu);
        this.createMenuItem(OpenNonBlueJAction.getInstance(), menu);
        this.createMenuItem(this.closeProjectAction, menu);
        this.createMenuItem(this.saveProjectAction, menu);
        this.createMenuItem(this.saveProjectAsAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.importProjectAction, menu);
        this.createMenuItem(this.exportProjectAction, menu);
        this.javaMEdeployMenuItem = this.createMenuItem(this.deployMIDletAction, menu);
        this.javaMEdeployMenuItem.setVisible(false);
        menu.addSeparator();
        this.createMenuItem(this.pageSetupAction, menu);
        this.createMenuItem(this.printAction, menu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(QuitAction.getInstance(), menu);
        }
        menu = new JMenu(Config.getString("menu.edit"));
        menu.setMnemonic(Config.getMnemonicKey("menu.edit"));
        this.menubar.add(menu);
        this.createMenuItem(this.newClassAction, menu);
        this.createMenuItem(this.newPackageAction, menu);
        this.createMenuItem(this.addClassAction, menu);
        this.createMenuItem(this.removeAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.newUsesAction, menu);
        this.createMenuItem(this.newInheritsAction, menu);
        menu = new JMenu(Config.getString("menu.tools"));
        menu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.menubar.add(menu);
        this.createMenuItem(this.compileAction, menu);
        this.createMenuItem(this.compileSelectedAction, menu);
        this.createMenuItem(this.rebuildAction, menu);
        this.createMenuItem(this.restartVMAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.useLibraryAction, menu);
        this.createMenuItem(this.generateDocsAction, menu);
        this.testingMenu = new JMenu(Config.getString("menu.tools.testing"));
        this.testingMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.createMenuItem(this.runTestsAction, this.testingMenu);
        this.endTestMenuItem = this.createMenuItem(EndTestRecordAction.getInstance(), this.testingMenu);
        this.cancelTestMenuItem = this.createMenuItem(CancelTestRecordAction.getInstance(), this.testingMenu);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        this.testItems.add(this.testingMenu);
        menu.add(this.testingMenu);
        this.teamMenu = new JMenu(Config.getString("menu.tools.teamwork"));
        this.teamMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        CheckoutAction checkoutAction = CheckoutAction.getInstance();
        this.createMenuItem(checkoutAction, this.teamMenu);
        this.shareProjectMenuItem = this.createMenuItem(this.teamActions.getImportAction(), this.teamMenu);
        this.teamMenu.addSeparator();
        this.updateMenuItem = this.createMenuItem(this.teamActions.getUpdateAction(), this.teamMenu);
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.commitMenuItem = this.createMenuItem(this.teamActions.getCommitCommentAction(), this.teamMenu);
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.statusMenuItem = this.createMenuItem(this.teamActions.getStatusAction(), this.teamMenu);
        this.showLogMenuItem = this.createMenuItem(this.teamActions.getShowLogAction(), this.teamMenu);
        this.teamMenu.addSeparator();
        this.teamSettingsMenuItem = this.createMenuItem(this.teamActions.getTeamSettingsAction(), this.teamMenu);
        this.teamItems.add(this.teamMenu);
        menu.add(this.teamMenu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(PreferencesAction.getInstance(), menu);
        }
        this.toolsMenuManager = new MenuManager(menu.getPopupMenu());
        if (frames.size() <= 1) {
            this.toolsMenuManager.setMenuGenerator(new ToolsExtensionMenu(null));
            this.toolsMenuManager.addExtensionMenu(null);
        }
        menu = new JMenu(Config.getString("menu.view"));
        menu.setMnemonic(Config.getMnemonicKey("menu.view"));
        this.menubar.add(menu);
        this.showUsesMenuItem = this.createCheckboxMenuItem(this.showUsesAction, menu, true);
        this.showExtendsMenuItem = this.createCheckboxMenuItem(this.showInheritsAction, menu, true);
        menu.addSeparator();
        this.createCheckboxMenuItem(this.showDebuggerAction, menu, false);
        this.createCheckboxMenuItem(this.showTerminalAction, menu, false);
        this.createCheckboxMenuItem(this.showTextEvalAction, menu, false);
        JSeparator testSeparator = new JSeparator();
        this.testItems.add(testSeparator);
        menu.add(testSeparator);
        this.showTestResultsItem = this.createCheckboxMenuItem(ShowTestResultsAction.getInstance(), menu, false);
        this.testItems.add(this.showTestResultsItem);
        this.viewMenuManager = new MenuManager(menu.getPopupMenu());
        if (frames.size() <= 1) {
            this.viewMenuManager.addExtensionMenu(null);
        }
        menu = new JMenu(Config.getString("menu.help"));
        menu.setMnemonic(Config.getMnemonicKey("menu.help"));
        this.menubar.add(menu);
        if (!Config.usingMacScreenMenubar()) {
            this.createMenuItem(HelpAboutAction.getInstance(), menu);
        }
        this.createMenuItem(CheckVersionAction.getInstance(), menu);
        this.createMenuItem(CheckExtensionsAction.getInstance(), menu);
        this.createMenuItem(ShowCopyrightAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(WebsiteAction.getInstance(), menu);
        this.createMenuItem(TutorialAction.getInstance(), menu);
        this.createMenuItem(StandardAPIHelpAction.getInstance(), menu);
        this.addUserHelpItems(menu);
        this.updateRecentProjects();
        this.setJMenuBar(this.menubar);
    }

    private JMenuItem createMenuItem(Action action, JMenu menu) {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(PkgMgrAction action, JMenu menu, boolean selected) {
        ButtonModel bmodel = action.getToggleModel(this);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        if (bmodel != null) {
            item.setModel(action.getToggleModel(this));
        } else {
            item.setState(selected);
        }
        menu.add(item);
        return item;
    }

    public void menuCall() {
        if (!this.isEmptyFrame()) {
            this.pkg.setState(0);
        }
        this.clearStatus();
    }

    private void setupActionDisableSet() {
        this.actionsToDisable = new ArrayList<Action>();
        this.actionsToDisable.add(this.closeProjectAction);
        this.actionsToDisable.add(this.saveProjectAction);
        this.actionsToDisable.add(this.saveProjectAsAction);
        this.actionsToDisable.add(this.importProjectAction);
        this.actionsToDisable.add(this.exportProjectAction);
        this.actionsToDisable.add(this.pageSetupAction);
        this.actionsToDisable.add(this.printAction);
        this.actionsToDisable.add(this.newClassAction);
        this.actionsToDisable.add(this.newPackageAction);
        this.actionsToDisable.add(this.addClassAction);
        this.actionsToDisable.add(this.removeAction);
        this.actionsToDisable.add(this.newUsesAction);
        this.actionsToDisable.add(this.newInheritsAction);
        this.actionsToDisable.add(this.compileAction);
        this.actionsToDisable.add(this.compileSelectedAction);
        this.actionsToDisable.add(this.rebuildAction);
        this.actionsToDisable.add(this.restartVMAction);
        this.actionsToDisable.add(this.useLibraryAction);
        this.actionsToDisable.add(this.generateDocsAction);
        this.actionsToDisable.add(this.showUsesAction);
        this.actionsToDisable.add(this.showInheritsAction);
        this.actionsToDisable.add(this.showDebuggerAction);
        this.actionsToDisable.add(this.showTerminalAction);
        this.actionsToDisable.add(this.showTextEvalAction);
        this.actionsToDisable.add(this.runTestsAction);
    }

    private void addUserHelpItems(JMenu menu) {
        String helpItems = Config.getPropString("bluej.help.items", "");
        if (helpItems != null && helpItems.length() > 0) {
            menu.addSeparator();
            URLDisplayer urlDisplayer = new URLDisplayer();
            StringTokenizer t = new StringTokenizer(helpItems);
            while (t.hasMoreTokens()) {
                String itemID = t.nextToken();
                String itemName = Config.getPropString("bluej.help." + itemID + ".label");
                String itemURL = Config.getPropString("bluej.help." + itemID + ".url");
                JMenuItem item = new JMenuItem(itemName);
                item.setActionCommand(itemURL);
                item.addActionListener(urlDisplayer);
                menu.add(item);
            }
        }
    }

    private void updateRecentProjects() {
        ProjectOpener opener = new ProjectOpener();
        this.recentProjectsMenu.removeAll();
        List<String> projects = PrefMgr.getRecentProjects();
        Iterator<String> it = projects.iterator();
        while (it.hasNext()) {
            JMenuItem item = this.recentProjectsMenu.add(it.next());
            item.addActionListener(opener);
        }
    }

    protected void enableFunctions(boolean enable) {
        if (!enable) {
            this.teamActions.setAllDisabled();
        }
        this.itemsToDisable.stream().forEach(component -> component.setEnabled(enable));
        this.actionsToDisable.stream().forEach(action -> action.setEnabled(enable));
    }

    public boolean isJavaMEpackage() {
        if (this.pkg == null) {
            return false;
        }
        return this.pkg.getProject().isJavaMEProject();
    }

    private void addCtrlTabShortcut(final JComponent toPane) {
        toPane.getInputMap(1).put(KeyStroke.getKeyStroke(9, 128), "nextPMFPane");
        toPane.getInputMap(1).put(KeyStroke.getKeyStroke(9, 192), "prevPMFPane");
        toPane.getActionMap().put("nextPMFPane", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PkgMgrFrame.this.movePaneFocus(toPane, 1);
            }
        });
        toPane.getActionMap().put("prevPMFPane", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PkgMgrFrame.this.movePaneFocus(toPane, -1);
            }
        });
    }

    private void movePaneFocus(JComponent fromPane, int direction) {
        ArrayList<JComponent> visiblePanes = new ArrayList<JComponent>();
        if (this.editor != null) {
            visiblePanes.add(this.editor);
        }
        visiblePanes.add(this.objbench);
        if (this.showingTextEvaluator) {
            visiblePanes.add(this.textEvaluator.getFocusableComponent());
        }
        for (int i = 0; i < visiblePanes.size(); ++i) {
            if (visiblePanes.get(i) != fromPane) continue;
            int destination = i + direction;
            if (destination >= visiblePanes.size()) {
                destination = 0;
            }
            if (destination < 0) {
                destination = visiblePanes.size() - 1;
            }
            ((JComponent)visiblePanes.get(destination)).requestFocusInWindow();
        }
    }

    class ProjectOpener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String project = evt.getActionCommand();
            if (!PkgMgrFrame.this.openProject(project)) {
                PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.error.open"));
            }
        }
    }

    class URLDisplayer
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String url = evt.getActionCommand();
            PkgMgrFrame.this.showWebPage(url);
        }
    }
}

