/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.collect.DataCollectionCompileObserverWrapper;
import bluej.collect.DataCollector;
import bluej.compiler.CompileObserver;
import bluej.compiler.Diagnostic;
import bluej.compiler.EDTCompileObserver;
import bluej.compiler.EventqueueCompileObserverAdapter;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.CallHistory;
import bluej.editor.Editor;
import bluej.editor.TextEditor;
import bluej.extensions.BDependency;
import bluej.extensions.BPackage;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.SourceType;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.DependencyEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.graph.Edge;
import bluej.graph.Graph;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.ParseUtils;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.GreenfootProjectFile;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageFile;
import bluej.pkgmgr.PackageFileFactory;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.ParentPackageTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.TargetCollection;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.MultiIterator;
import bluej.utility.SortedProperties;
import bluej.utility.Utility;
import bluej.utility.filefilter.FrameSourceFilter;
import bluej.utility.filefilter.JavaClassFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import bluej.utility.filefilter.SubPackageFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Package
extends Graph {
    static final String compiling = Config.getString("pkgmgr.compiling");
    static final String compileDone = Config.getString("pkgmgr.compileDone");
    static final String chooseUsesTo = Config.getString("pkgmgr.chooseUsesTo");
    static final String chooseInhTo = Config.getString("pkgmgr.chooseInhTo");
    private PackageFile packageFile;
    public static final String readmeName = "README.TXT";
    public static final int NO_ERROR = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ILLEGAL_FORMAT = 2;
    public static final int COPY_ERROR = 3;
    public static final int CLASS_EXISTS = 4;
    public static final int CREATE_ERROR = 5;
    public static final int FIXED_TARGET_X = 10;
    public static final int FIXED_TARGET_Y = 10;
    private final Project project;
    private final Package parentPackage;
    private final String baseName;
    private SortedProperties lastSavedProps = new SortedProperties();
    private TargetCollection targets;
    private List<Dependency> usesArrows;
    private List<Dependency> extendsArrows;
    private DependentTarget fromChoice;
    private CallHistory callHistory;
    private boolean showExtends = true;
    private boolean showUses = true;
    private String lastSourceName = "";
    public static final int S_IDLE = 0;
    public static final int S_CHOOSE_USES_FROM = 1;
    public static final int S_CHOOSE_USES_TO = 2;
    public static final int S_CHOOSE_EXT_FROM = 3;
    public static final int S_CHOOSE_EXT_TO = 4;
    public static final int HISTORY_LENGTH = 6;
    private int state = 0;
    private PackageEditor editor;
    private boolean waitingForIdleToCompile = false;
    private File dir;
    private BPackage singleBPackage;

    public Package(Project project, String baseName, Package parent) throws IOException {
        if (parent == null) {
            throw new NullPointerException("Package must have a valid parent package");
        }
        if (baseName.length() == 0) {
            throw new IllegalArgumentException("unnamedPackage must be created using Package(project)");
        }
        if (!JavaNames.isIdentifier(baseName)) {
            throw new IllegalArgumentException(baseName + " is not a valid name for a Package");
        }
        this.project = project;
        this.baseName = baseName;
        this.parentPackage = parent;
        this.init();
    }

    public Package(Project project) throws IOException {
        this.project = project;
        this.baseName = "";
        this.parentPackage = null;
        this.init();
    }

    private void init() throws IOException {
        this.targets = new TargetCollection();
        this.usesArrows = new ArrayList<Dependency>();
        this.extendsArrows = new ArrayList<Dependency>();
        this.callHistory = new CallHistory(6);
        this.dir = new File(this.project.getProjectDir(), this.getRelativePath().getPath());
        this.load();
    }

    @OnThread(value=Tag.Any)
    public boolean isUnnamedPackage() {
        return this.parentPackage == null;
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.Any)
    public final synchronized BPackage getBPackage() {
        if (this.singleBPackage == null) {
            this.singleBPackage = ExtensionBridge.newBPackage((Package)this);
        }
        return this.singleBPackage;
    }

    public String getId() {
        return this.getPath().getPath();
    }

    @OnThread(value=Tag.Any)
    public String getBaseName() {
        return this.baseName;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName(String identifier) {
        if (this.isUnnamedPackage()) {
            return identifier;
        }
        return this.getQualifiedName() + "." + identifier;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName() {
        Package currentPkg = this;
        String retName = "";
        while (!currentPkg.isUnnamedPackage()) {
            retName = retName.equals("") ? currentPkg.getBaseName() : currentPkg.getBaseName() + "." + retName;
            currentPkg = currentPkg.getParent();
        }
        return retName;
    }

    public ReadmeTarget getReadmeTarget() {
        ReadmeTarget readme = (ReadmeTarget)this.targets.get("@README");
        return readme;
    }

    private File getRelativePath() {
        Package currentPkg = this;
        File retFile = new File(currentPkg.getBaseName());
        while (!currentPkg.isUnnamedPackage()) {
            currentPkg = currentPkg.getParent();
            retFile = new File(currentPkg.getBaseName(), retFile.getPath());
        }
        return retFile;
    }

    public File getPath() {
        return this.dir;
    }

    @OnThread(value=Tag.Any)
    public Package getParent() {
        return this.parentPackage;
    }

    protected Package getBoringSubPackage() {
        PackageTarget pt = null;
        Iterator<Target> e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = e.next();
            if (target instanceof ClassTarget) {
                return null;
            }
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            if (pt != null) {
                return null;
            }
            pt = (PackageTarget)target;
        }
        if (pt == null) {
            return null;
        }
        return this.getProject().getPackage(pt.getQualifiedName());
    }

    protected List<Package> getChildren(boolean getUncached) {
        ArrayList<Package> children = new ArrayList<Package>();
        Iterator<Target> e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = e.next();
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            PackageTarget pt = (PackageTarget)target;
            Package child = getUncached ? this.getProject().getPackage(pt.getQualifiedName()) : this.getProject().getCachedPackage(pt.getQualifiedName());
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    public void setStatus(String msg) {
        PkgMgrFrame.displayMessage(this, msg);
    }

    public void repaint() {
        if (this.editor != null) {
            this.editor.repaint();
        }
    }

    void setEditor(PackageEditor editor) {
        this.editor = editor;
    }

    @OnThread(value=Tag.Any)
    public PackageEditor getEditor() {
        return this.editor;
    }

    public Properties getLastSavedProperties() {
        return this.lastSavedProps;
    }

    public Target[] getSelectedTargets() {
        Target[] targetArray = new Target[]{};
        LinkedList<Target> list = new LinkedList<Target>();
        Iterator<Target> it = this.getVertices();
        while (it.hasNext()) {
            Target target = it.next();
            if (!target.isSelected()) continue;
            list.add(target);
        }
        return list.toArray(targetArray);
    }

    public Dependency getSelectedDependency() {
        Iterator<? extends Edge> it = this.getEdges();
        while (it.hasNext()) {
            Edge edge = it.next();
            if (!(edge instanceof Dependency) || !edge.isSelected()) continue;
            return (Dependency)edge;
        }
        return null;
    }

    public Dependency getDependency(DependentTarget origin, DependentTarget target, BDependency.Type type) {
        List<Object> dependencies = new ArrayList();
        switch (type) {
            case USES: {
                dependencies = this.usesArrows;
                break;
            }
            case IMPLEMENTS: 
            case EXTENDS: {
                dependencies = this.extendsArrows;
                break;
            }
            case UNKNOWN: {
                return null;
            }
        }
        for (Dependency dependency : dependencies) {
            DependentTarget from = dependency.getFrom();
            DependentTarget to = dependency.getTo();
            if (!from.equals(origin) || !to.equals(target)) continue;
            return dependency;
        }
        return null;
    }

    private Set<String> findTargets(File path) {
        int i;
        File[] javaSrcFiles = path.listFiles(new JavaSourceFilter());
        File[] frameSrcFiles = path.listFiles(new FrameSourceFilter());
        File[] classFiles = path.listFiles(new JavaClassFilter());
        HashSet<String> interestingSet = new HashSet<String>();
        for (i = 0; i < javaSrcFiles.length; ++i) {
            if (javaSrcFiles[i].getName().startsWith("__SHELL")) {
                javaSrcFiles[i].delete();
                continue;
            }
            String javaFileName = JavaNames.stripSuffix(javaSrcFiles[i].getName(), "." + SourceType.Java.toString().toLowerCase());
            if (!JavaNames.isIdentifier(javaFileName) || javaFileName.indexOf(36) != -1) continue;
            interestingSet.add(javaFileName);
        }
        for (i = 0; i < frameSrcFiles.length; ++i) {
            String frameFileName = JavaNames.stripSuffix(frameSrcFiles[i].getName(), "." + SourceType.Stride.toString().toLowerCase());
            if (!JavaNames.isIdentifier(frameFileName)) continue;
            interestingSet.add(frameFileName);
        }
        for (i = 0; i < classFiles.length; ++i) {
            if (classFiles[i].getName().startsWith("__SHELL")) {
                classFiles[i].delete();
                continue;
            }
            String classFileName = JavaNames.stripSuffix(classFiles[i].getName(), ".class");
            if (!JavaNames.isIdentifier(classFileName) || classFileName.indexOf(36) != -1 || interestingSet.contains(classFileName)) continue;
            try {
                Class<?> c = this.loadClass(this.getQualifiedName(classFileName));
                if (c == null || !Modifier.isPublic(c.getModifiers())) continue;
                interestingSet.add(classFileName);
                continue;
            }
            catch (LinkageError e) {
                Debug.message(e.toString());
            }
        }
        return interestingSet;
    }

    public void load() throws IOException {
        this.packageFile = this.getPkgFile();
        this.packageFile.load(this.lastSavedProps);
    }

    public void refreshPackage() {
        Object ct;
        Target target;
        HashMap<String, ClassTarget> propTargets = new HashMap<String, ClassTarget>();
        int numTargets = 0;
        int numDependencies = 0;
        try {
            numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            numDependencies = Integer.parseInt(this.lastSavedProps.getProperty("package.numDependencies", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from package file " + this.packageFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            ClassTarget target2;
            String type = this.lastSavedProps.getProperty("target" + (i + 1) + ".type");
            String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            if ("PackageTarget".equals(type)) {
                PackageTarget target3 = new PackageTarget(this, identifierName);
            } else {
                target2 = new ClassTarget(this, identifierName);
            }
            ((Target)target2).load(this.lastSavedProps, "target" + (i + 1));
            propTargets.put(identifierName, target2);
        }
        this.addImmovableTargets();
        ArrayList<Target> targetsToPlace = new ArrayList<Target>();
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
            Target target4 = (Target)propTargets.get(subDirs[i].getName());
            if (target4 == null || !(target4 instanceof PackageTarget)) {
                target4 = new PackageTarget(this, subDirs[i].getName());
                targetsToPlace.add(target4);
            }
            this.addTarget(target4);
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String string : interestingSet) {
            Target target2 = (Target)propTargets.get(string);
            if (target2 == null || !(target2 instanceof ClassTarget)) {
                target2 = new ClassTarget(this, string);
                targetsToPlace.add(target2);
            }
            this.addTarget(target2);
        }
        for (Target t : targetsToPlace) {
            this.findSpaceForVertex(t);
        }
        Iterator<Target> iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            Target target3 = iterator.next();
            if (!(target3 instanceof ClassTarget)) continue;
            ClassTarget ct2 = (ClassTarget)target3;
            ct2.setState(0);
        }
        for (int i = 0; i < numDependencies; ++i) {
            UsesDependency dep = null;
            String type = this.lastSavedProps.getProperty("dependency" + (i + 1) + ".type");
            if (!"UsesDependency".equals(type) || !(dep = new UsesDependency(this)).load(this.lastSavedProps, "dependency" + (i + 1))) continue;
            this.addDependency(dep, false);
        }
        this.recalcArrows();
        LinkedList<Object> invalidated = new LinkedList<Object>();
        Iterator<Target> iterator2 = this.targets.iterator();
        while (iterator2.hasNext()) {
            target = iterator2.next();
            if (!(target instanceof ClassTarget) || !((ClassTarget)(ct = (ClassTarget)target)).isCompiled() || ((ClassTarget)ct).upToDate()) continue;
            ((ClassTarget)ct).setState(1);
            invalidated.add(ct);
        }
        while (!invalidated.isEmpty()) {
            ClassTarget ct2 = (ClassTarget)invalidated.removeFirst();
            for (Dependency dependent : ct2.dependentsAsList()) {
                ClassTarget dep;
                DependentTarget dt = dependent.getFrom();
                if (!(dt instanceof ClassTarget) || !(dep = (ClassTarget)dt).isCompiled()) continue;
                dep.setState(1);
                invalidated.add(dep);
            }
        }
        Iterator<Target> iterator3 = this.targets.iterator();
        while (iterator3.hasNext()) {
            target = iterator3.next();
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            if (((ClassTarget)ct).isCompiled()) {
                Class<?> cl = this.loadClass(((ClassTarget)ct).getQualifiedName());
                ((ClassTarget)ct).determineRole(cl);
                ((ClassTarget)ct).analyseDependencies(cl);
                if (cl != null) continue;
                ((ClassTarget)ct).setState(1);
                continue;
            }
            ((ClassTarget)ct).analyseSource();
            try {
                ((ClassTarget)ct).enforcePackage(this.getQualifiedName());
            }
            catch (IOException ioe) {
                Debug.message("Error enforcing class package: " + ioe.getLocalizedMessage());
            }
        }
        for (int i = 0; i < numTargets; ++i) {
            String assoc = this.lastSavedProps.getProperty("target" + (i + 1) + ".association");
            String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            if (assoc == null) continue;
            Target t1 = this.getTarget(identifierName);
            Target t2 = this.getTarget(assoc);
            if (t1 == null || t2 == null || !(t1 instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t1;
            dt.setAssociation((DependentTarget)t2);
        }
    }

    private PackageFile getPkgFile() {
        File dir = this.getPath();
        return PackageFileFactory.getPackageFile(dir);
    }

    public void positionNewTarget(Target t) {
        String targetName = t.getIdentifierName();
        try {
            int numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            for (int i = 0; i < numTargets; ++i) {
                String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
                if (!identifierName.equals(targetName)) continue;
                t.load(this.lastSavedProps, "target" + (i + 1));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.findSpaceForVertex(t);
    }

    private void addImmovableTargets() {
        Target t = new ReadmeTarget(this);
        ((Target)t).load(this.lastSavedProps, "readme");
        t.setPos(10, 10);
        this.addTarget(t);
        if (!this.isUnnamedPackage()) {
            t = new ParentPackageTarget(this);
            this.findSpaceForVertex(t);
            this.addTarget(t);
        }
    }

    public void reload() {
        ClassTarget ct;
        Target target;
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            Target target2;
            if (!JavaNames.isIdentifier(subDirs[i].getName()) || (target2 = this.targets.get(subDirs[i].getName())) != null) continue;
            PackageTarget newtarget = this.addPackage(subDirs[i].getName());
            this.findSpaceForVertex(newtarget);
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String targetName : interestingSet) {
            Target target3 = this.targets.get(targetName);
            if (target3 != null) continue;
            ClassTarget newtarget = this.addClass(targetName);
            this.findSpaceForVertex(newtarget);
        }
        Iterator<Object> it = this.targets.iterator();
        while (it.hasNext()) {
            target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            ct.analyseSource();
        }
        it = this.targets.iterator();
        while (it.hasNext()) {
            Class<?> cl;
            target = (Target)it.next();
            if (!(target instanceof ClassTarget) || (cl = this.loadClass((ct = (ClassTarget)target).getQualifiedName())) == null) continue;
            ct.determineRole(cl);
            if (ct.upToDate()) {
                ct.setState(0);
                continue;
            }
            ct.setState(1);
        }
        this.graphChanged();
    }

    public void reReadGraphLayout() throws IOException {
        SortedProperties props = new SortedProperties();
        this.packageFile.load(props);
        int numTargets = 0;
        try {
            numTargets = Integer.parseInt(props.getProperty("package.numTargets", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from bluej package file " + this.packageFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            Target target = null;
            String identifierName = props.getProperty("target" + (i + 1) + ".name");
            int x = Integer.parseInt(props.getProperty("target" + (i + 1) + ".x"));
            int y = Integer.parseInt(props.getProperty("target" + (i + 1) + ".y"));
            int height = Integer.parseInt(props.getProperty("target" + (i + 1) + ".height"));
            int width = Integer.parseInt(props.getProperty("target" + (i + 1) + ".width"));
            target = this.getTarget(identifierName);
            if (target == null) continue;
            target.setPos(x, y);
            target.setSize(width, height);
        }
        this.repaint();
    }

    public void save(Properties frameProperties) {
        Target t;
        File dir = this.getPath();
        if (!dir.exists() && !dir.mkdir()) {
            Debug.reportError("Error creating directory " + dir);
            return;
        }
        SortedProperties props = new SortedProperties();
        props.putAll((Map<?, ?>)frameProperties);
        props.put("package.numDependencies", String.valueOf(this.usesArrows.size()));
        int t_count = 0;
        Iterator<Target> t_enum = this.targets.iterator();
        while (t_enum.hasNext()) {
            t = t_enum.next();
            if (!t.isSaveable()) continue;
            t.save(props, "target" + (t_count + 1));
            ++t_count;
        }
        props.put("package.numTargets", String.valueOf(t_count));
        t = this.getTarget("@README");
        t.save(props, "readme");
        for (int i = 0; i < this.usesArrows.size(); ++i) {
            Dependency d = this.usesArrows.get(i);
            d.save(props, "dependency" + (i + 1));
        }
        try {
            this.packageFile.save(props);
        }
        catch (IOException e) {
            Debug.reportError("Exception when saving package file : " + e);
            return;
        }
        this.lastSavedProps = props;
    }

    public int importFile(File aFile) {
        if (!aFile.exists()) {
            return 1;
        }
        String fileName = aFile.getName();
        if (!fileName.endsWith("." + SourceType.Java.toString().toLowerCase())) {
            return 2;
        }
        String className = fileName.substring(0, fileName.length() - 5);
        if (this.getTarget(className) != null) {
            return 4;
        }
        File destFile = new File(this.getPath(), fileName);
        try {
            FileUtility.copyFile(aFile, destFile);
        }
        catch (IOException ioe) {
            return 3;
        }
        ClassTarget t = this.addClass(className);
        this.findSpaceForVertex(t);
        t.analyseSource();
        DataCollector.addClass(this, destFile);
        return 0;
    }

    public ClassTarget addClass(String className) {
        ClassTarget target = new ClassTarget(this, className);
        this.addTarget(target);
        try {
            target.enforcePackage(this.getQualifiedName());
        }
        catch (IOException ioe) {
            Debug.message(ioe.getLocalizedMessage());
        }
        return target;
    }

    public PackageTarget addPackage(String packageName) {
        PackageTarget target = new PackageTarget(this, packageName);
        this.addTarget(target);
        return target;
    }

    public Debugger getDebugger() {
        return this.getProject().getDebugger();
    }

    public Class<?> loadClass(String className) {
        return this.getProject().loadClass(className);
    }

    public Iterator<Target> getVertices() {
        return this.targets.sortediterator();
    }

    @Override
    public Iterator<? extends Edge> getEdges() {
        ArrayList iterations = new ArrayList();
        if (this.showUses) {
            iterations.add(this.usesArrows.iterator());
        }
        if (this.showExtends) {
            iterations.add(this.extendsArrows.iterator());
        }
        return new MultiIterator(iterations);
    }

    public List<ClassTarget> getTestTargets() {
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target target = it.next();
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isUnitTest()) continue;
            l.add(ct);
        }
        return l;
    }

    public void compile(CompileObserver compObserver) {
        block5: {
            if (!this.checkCompile()) {
                return;
            }
            HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
            try {
                for (Target target : this.targets.toArray()) {
                    ClassTarget ct;
                    if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isInvalidState() || ct.isQueued()) continue;
                    ct.ensureSaved();
                    toCompile.add(ct);
                    ct.setQueued(true);
                }
                if (toCompile.isEmpty()) break block5;
                this.project.removeClassLoader();
                this.project.newRemoteClassLoaderLeavingBreakpoints();
                this.doCompile(toCompile, new PackageCompileObserver(compObserver));
            }
            catch (IOException ioe) {
                Debug.log("Error saving class before compile: " + ioe.getLocalizedMessage());
                for (ClassTarget ct : toCompile) {
                    ct.setQueued(false);
                }
            }
        }
    }

    public void compile() {
        this.compile((CompileObserver)null);
    }

    public void compile(ClassTarget ct) {
        this.compile(ct, false, null);
    }

    public void compile(ClassTarget ct, boolean forceQuiet, CompileObserver compObserver) {
        if (!this.checkCompile()) {
            return;
        }
        ClassTarget assocTarget = (ClassTarget)ct.getAssociation();
        if (assocTarget != null && !assocTarget.hasSourceCode()) {
            assocTarget = null;
        }
        if (ct.hasSourceCode()) {
            ct.setInvalidState();
        } else {
            ct = null;
        }
        if (assocTarget != null) {
            assocTarget.setInvalidState();
        }
        if (ct != null || assocTarget != null) {
            this.project.removeClassLoader();
            this.project.newRemoteClassLoaderLeavingBreakpoints();
            if (ct != null) {
                QuietPackageCompileObserver observer = forceQuiet ? new QuietPackageCompileObserver(compObserver) : new PackageCompileObserver(compObserver);
                this.searchCompile(ct, observer);
            }
            if (assocTarget != null) {
                this.searchCompile(assocTarget, new QuietPackageCompileObserver(null));
            }
        }
    }

    public void compileQuiet(ClassTarget ct) {
        if (!this.isDebuggerIdle()) {
            return;
        }
        ct.setInvalidState();
        this.searchCompile(ct, new QuietPackageCompileObserver(null));
    }

    public void rebuild() {
        if (!this.checkCompile()) {
            return;
        }
        ArrayList<ClassTarget> compileTargets = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            compileTargets.add((ClassTarget)target);
        }
        try {
            Iterator i = compileTargets.iterator();
            while (i.hasNext()) {
                ClassTarget ct = (ClassTarget)i.next();
                if (ct.hasSourceCode()) {
                    ct.ensureSaved();
                    ct.setState(1);
                    ct.setQueued(true);
                    continue;
                }
                i.remove();
            }
            if (!compileTargets.isEmpty()) {
                this.project.removeClassLoader();
                this.project.newRemoteClassLoader();
                this.doCompile(compileTargets, new PackageCompileObserver(null));
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("file-save-error-before-compile", ioe.getLocalizedMessage());
        }
    }

    public void saveFilesInEditors() throws IOException {
        for (Target target : this.targets.toArray()) {
            ClassTarget ct;
            Editor ed;
            if (!(target instanceof ClassTarget) || (ed = (ct = (ClassTarget)target).getEditor()) == null) continue;
            ed.save();
        }
    }

    private void searchCompile(ClassTarget t, EDTCompileObserver observer) {
        if (!t.isInvalidState() || t.isQueued()) {
            return;
        }
        HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
        try {
            LinkedList<ClassTarget> queue = new LinkedList<ClassTarget>();
            toCompile.add(t);
            t.ensureSaved();
            queue.add(t);
            t.setQueued(true);
            while (!queue.isEmpty()) {
                ClassTarget head = (ClassTarget)queue.remove(0);
                Iterator<? extends Dependency> dependencies = head.dependencies();
                while (dependencies.hasNext()) {
                    ClassTarget to;
                    Dependency d = dependencies.next();
                    if (!(d.getTo() instanceof ClassTarget) || !(to = (ClassTarget)d.getTo()).isInvalidState() || to.isQueued() || !toCompile.add(to)) continue;
                    to.ensureSaved();
                    to.setQueued(true);
                    queue.add(to);
                }
            }
            this.doCompile(toCompile, observer);
        }
        catch (IOException ioe) {
            Debug.log("Failed to save source before compile; " + ioe.getLocalizedMessage());
            for (ClassTarget ct : toCompile) {
                ct.setQueued(false);
            }
        }
    }

    private void doCompile(Collection<ClassTarget> targetList, EDTCompileObserver edtObserver) {
        EventqueueCompileObserverAdapter observer = new EventqueueCompileObserverAdapter(new DataCollectionCompileObserverWrapper(this.project, edtObserver));
        if (targetList.isEmpty()) {
            return;
        }
        List<File> srcFiles = Utility.mapList(targetList, ClassTarget::getCompileInputFile);
        if (srcFiles.size() > 0) {
            JobQueue.getJobQueue().addJob(srcFiles.toArray(new File[0]), observer, this.project.getClassLoader(), this.project.getProjectDir(), !PrefMgr.getFlag("bluej.compiler.showunchecked"), this.project.getProjectCharset());
        }
    }

    public boolean isDebuggerIdle() {
        int status = this.getDebugger().getStatus();
        return status == 2 || status == 1;
    }

    private boolean checkCompile() {
        if (this.isDebuggerIdle()) {
            return true;
        }
        this.showMessage("compile-while-executing");
        return false;
    }

    public void compileOnceIdle() {
        if (this.isDebuggerIdle()) {
            this.compile();
        } else if (!this.waitingForIdleToCompile) {
            this.waitingForIdleToCompile = true;
            this.getDebugger().addDebuggerListener(new DebuggerListener(){

                @Override
                public void processDebuggerEvent(DebuggerEvent e, boolean skipUpdate) {
                    if (e.getNewState() == 2) {
                        Package.this.getDebugger().removeDebuggerListener(this);
                        SwingUtilities.invokeLater(() -> {
                            Package.this.waitingForIdleToCompile = false;
                            Package.this.compileOnceIdle();
                        });
                    }
                }
            });
        }
    }

    public String generateDocumentation() {
        return this.project.generateDocumentation();
    }

    public void generateDocumentation(ClassTarget ct) {
        String filename = ct.getSourceFile().getPath();
        this.project.generateDocumentation(filename);
    }

    public void reInitBreakpoints() {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).reInitBreakpoints();
        }
    }

    public void removeStepMarks() {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeStepMark();
        }
    }

    public void addTarget(Target t) {
        if (t.getPackage() != this) {
            throw new IllegalArgumentException();
        }
        this.targets.add(t.getIdentifierName(), t);
        this.graphChanged();
    }

    public void removeTarget(Target t) {
        this.targets.remove(t.getIdentifierName());
        this.removedSelectableElement(t);
        t.setRemoved();
        this.graphChanged();
    }

    public void updateTargetIdentifier(Target t, String oldIdentifier, String newIdentifier) {
        if (t == null || newIdentifier == null) {
            Debug.reportError("cannot properly update target name...");
            return;
        }
        this.targets.remove(oldIdentifier);
        this.targets.add(newIdentifier, t);
    }

    public void removeArrow(Dependency d) {
        if (!(d instanceof UsesDependency)) {
            this.userRemoveDependency(d);
        }
        this.removeDependency(d, true);
        this.graphChanged();
    }

    public void addDependency(Dependency d, boolean recalc) {
        DependentTarget from = d.getFrom();
        DependentTarget to = d.getTo();
        if (from == null || to == null) {
            return;
        }
        if (d instanceof UsesDependency) {
            int index = this.usesArrows.indexOf(d);
            if (index != -1) {
                ((UsesDependency)this.usesArrows.get(index)).setFlag(true);
                return;
            }
            this.usesArrows.add(d);
        } else {
            if (this.extendsArrows.contains(d)) {
                return;
            }
            this.extendsArrows.add(d);
        }
        from.addDependencyOut(d, recalc);
        to.addDependencyIn(d, recalc);
        DependencyEvent event = new DependencyEvent(d, this, DependencyEvent.Type.DEPENDENCY_ADDED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    public void userAddImplementsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        TextEditor ed = from.getEditor().assumeText();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" implements " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddImplementsInterfaceDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        TextEditor ed = from.getEditor().assumeText();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" extends " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddExtendsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        TextEditor ed = from.getEditor().assumeText();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(" extends " + to.getBaseName(), false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userRemoveDependency(Dependency d) {
        if (!(d.getFrom() instanceof ClassTarget) || !(d.getTo() instanceof ClassTarget)) {
            return;
        }
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        TextEditor ed = from.getEditor().assumeText();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = null;
                if (d instanceof ImplementsDependency) {
                    List<Selection> vsels = info.getInterfaceSelections();
                    List<String> vtexts = this.getInterfaceTexts(ed, vsels);
                    int where = vtexts.indexOf(to.getBaseName());
                    if (where == 1 && vsels.size() > 2) {
                        where = 2;
                    }
                    if (where > 0) {
                        s1 = vsels.get(where - 1);
                        s1.combineWith(vsels.get(where));
                    }
                } else if (d instanceof ExtendsDependency) {
                    s1 = info.getExtendsReplaceSelection();
                    s1.combineWith(info.getSuperReplaceSelection());
                }
                if (s1 != null) {
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText("", false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    private List<String> getInterfaceTexts(TextEditor ed, List<Selection> selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        for (Selection sel : selections) {
            String text = ed.getText(new bluej.parser.SourceLocation(sel.getLine(), sel.getColumn()), new bluej.parser.SourceLocation(sel.getEndLine(), sel.getEndColumn()));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    public void removeDependency(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.usesArrows.remove(d);
        } else {
            this.extendsArrows.remove(d);
        }
        DependentTarget from = d.getFrom();
        from.removeDependencyOut(d, recalc);
        DependentTarget to = d.getTo();
        to.removeDependencyIn(d, recalc);
        this.removedSelectableElement(d);
        DependencyEvent event = new DependencyEvent(d, this, DependencyEvent.Type.DEPENDENCY_REMOVED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    private void recalcArrows() {
        Iterator<Target> it = this.getVertices();
        while (it.hasNext()) {
            Target t = it.next();
            if (!(t instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t;
            dt.recalcInUses();
            dt.recalcOutUses();
        }
    }

    public Target getTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        return t;
    }

    public DependentTarget getDependentTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        if (t instanceof DependentTarget) {
            return (DependentTarget)t;
        }
        return null;
    }

    public final ArrayList<ClassTarget> getClassTargets() {
        ArrayList<ClassTarget> risul = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            risul.add((ClassTarget)target);
        }
        return risul;
    }

    public List<String> getAllClassnames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = it.next();
            if (!(t instanceof ClassTarget)) continue;
            ClassTarget ct = (ClassTarget)t;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public List<String> getAllClassnamesWithSource() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target t = it.next();
            if (!(t instanceof ClassTarget) || !(ct = (ClassTarget)t).hasSourceCode()) continue;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public void setShowUses(boolean state) {
        this.showUses = state;
    }

    public void setShowExtends(boolean state) {
        this.showExtends = state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @OnThread(value=Tag.Any)
    public static boolean isPackage(File f) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.exists(f);
        }
        return BlueJPackageFile.exists(f);
    }

    @OnThread(value=Tag.Any)
    public static boolean isPackageFileName(String name) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.isProjectFileName(name);
        }
        return BlueJPackageFile.isPackageFileName(name);
    }

    public void targetSelected(Target t) {
        if (t == null) {
            if (this.getState() != 0) {
                this.setState(0);
                this.setStatus(" ");
            }
            return;
        }
        switch (this.getState()) {
            case 1: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(2);
                    this.setStatus(chooseUsesTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 2: {
                if (t == this.fromChoice || !(t instanceof DependentTarget)) break;
                this.setState(0);
                this.addDependency(new UsesDependency(this, this.fromChoice, (DependentTarget)t), true);
                this.setStatus(" ");
                break;
            }
            case 3: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(4);
                    this.setStatus(chooseInhTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 4: {
                if (t == this.fromChoice) break;
                this.setState(0);
                if (t instanceof ClassTarget && this.fromChoice instanceof ClassTarget) {
                    ClassTarget from = (ClassTarget)this.fromChoice;
                    ClassTarget to = (ClassTarget)t;
                    if (to.isInterface()) {
                        ImplementsDependency d = new ImplementsDependency(this, from, to);
                        if (from.isInterface()) {
                            this.userAddImplementsInterfaceDependency(d);
                        } else {
                            this.userAddImplementsClassDependency(d);
                        }
                        this.addDependency(d, true);
                    } else if (!(from.isInterface() || to.isEnum() || from.isEnum())) {
                        ExtendsDependency d = new ExtendsDependency(this, from, to);
                        this.userAddExtendsClassDependency(d);
                        this.addDependency(d, true);
                    }
                }
                this.setStatus(" ");
                break;
            }
        }
    }

    public void showError(String msgId) {
        PkgMgrFrame.showError(this, msgId);
    }

    public void showMessage(String msgId) {
        PkgMgrFrame.showMessage(this, msgId);
    }

    public void showMessageWithText(String msgId, String text) {
        PkgMgrFrame.showMessageWithText(this, msgId, text);
    }

    public void forgetLastSource() {
        this.lastSourceName = "";
    }

    public boolean showSource(String sourcename, int lineNo, String threadName, boolean breakpoint) {
        String msg = " ";
        if (PrefMgr.getFlag("bluej.accessibility.support")) {
            msg = breakpoint ? Config.getString("debugger.accessibility.breakpoint") : Config.getString("debugger.accessibility.paused");
            msg = msg.replace("$", threadName);
        }
        boolean bringToFront = !sourcename.equals(this.lastSourceName);
        this.lastSourceName = sourcename;
        if (!this.showEditorMessage(new File(this.getPath(), sourcename).getPath(), lineNo, msg, false, bringToFront, true, null) && breakpoint) {
            this.showMessageWithText("break-no-source", sourcename);
        }
        return bringToFront;
    }

    private boolean showEditorMessage(String filename, int lineNo, final String message, boolean beep, boolean bringToFront, boolean setStepMark, String help) {
        return this.showEditorMessage(filename, lineNo, new MessageCalculator(){

            @Override
            public String calculateMessage(Editor e) {
                return message;
            }
        }, beep, bringToFront, setStepMark, help);
    }

    private boolean showEditorMessage(String filename, int lineNo, MessageCalculator messageCalc, boolean beep, boolean bringToFront, boolean setStepMark, String help) {
        String fullName = this.getProject().convertPathToPackageName(filename);
        if (fullName == null) {
            return false;
        }
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        ClassTarget t = null;
        if (!packageName.equals(this.getQualifiedName())) {
            Package pkg = this.getProject().getPackage(packageName);
            if (pkg != null) {
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf == null) {
                    pmf = PkgMgrFrame.createFrame(pkg);
                }
                pmf.setVisible(true);
                t = (ClassTarget)pkg.getTarget(className);
            }
        } else {
            t = (ClassTarget)this.getTarget(className);
        }
        if (t == null) {
            return false;
        }
        Editor editor = t.getEditor();
        if (editor != null) {
            if (bringToFront || !editor.isOpen()) {
                t.open();
            }
            editor.displayMessage(messageCalc.calculateMessage(editor), lineNo, 0, beep, setStepMark, help);
        } else {
            Debug.message(t.getDisplayName() + ", line" + lineNo + ": " + messageCalc.calculateMessage(null));
        }
        return true;
    }

    private ErrorShown showEditorDiagnostic(Diagnostic diagnostic, MessageCalculator messageCalc, int errorIndex) {
        String fileName = diagnostic.getFileName();
        if (fileName == null) {
            return ErrorShown.EDITOR_NOT_FOUND;
        }
        String fullName = this.getProject().convertPathToPackageName(diagnostic.getFileName());
        if (fullName == null) {
            return ErrorShown.EDITOR_NOT_FOUND;
        }
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        ClassTarget t = null;
        if (!packageName.equals(this.getQualifiedName())) {
            Package pkg = this.getProject().getPackage(packageName);
            if (pkg != null) {
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf == null) {
                    pmf = PkgMgrFrame.createFrame(pkg);
                }
                pmf.setVisible(true);
                t = (ClassTarget)pkg.getTarget(className);
            }
        } else {
            t = (ClassTarget)this.getTarget(className);
        }
        if (t == null) {
            return ErrorShown.EDITOR_NOT_FOUND;
        }
        Editor editor = t.getEditor();
        if (editor != null) {
            if (messageCalc != null) {
                diagnostic.setMessage(messageCalc.calculateMessage(editor));
            }
            if (this.project.isClosing()) {
                return ErrorShown.ERROR_NOT_SHOWN;
            }
            t.markKnownError();
            boolean shown = editor.displayDiagnostic(diagnostic, errorIndex);
            return shown ? ErrorShown.ERROR_SHOWN : ErrorShown.ERROR_NOT_SHOWN;
        }
        Debug.message(t.getDisplayName() + ", line" + diagnostic.getStartLine() + ": " + diagnostic.getMessage());
        return ErrorShown.EDITOR_NOT_FOUND;
    }

    public void hitBreakpoint(DebuggerThread thread) {
        this.showSource(thread.getClassSourceName(0), thread.getLineNumber(0), thread.getName(), true);
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void hitHalt(DebuggerThread thread) {
        int frame = thread.getSelectedFrame();
        if (this.showSource(thread.getClassSourceName(frame), thread.getLineNumber(frame), thread.getName(), thread.isAtBreakpoint())) {
            this.getProject().getExecControls().setVisible(true);
        }
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void showSourcePosition(String sourceName, int lineNumber) {
        if (this.showSource(sourceName, lineNumber, null, false)) {
            this.getProject().getExecControls().setVisible(true);
        }
    }

    public void exceptionMessage(ExceptionDescription exception) {
        SourceLocation loc;
        String text = exception.getClassName();
        if (text == null) {
            this.reportException(exception.getText());
            return;
        }
        String message = text + ":\n" + exception.getText();
        List<SourceLocation> stack = exception.getStack();
        if (stack == null || stack.size() == 0) {
            return;
        }
        boolean done = false;
        Iterator<SourceLocation> iter = stack.iterator();
        boolean firstTime = true;
        while (!done && iter.hasNext()) {
            loc = iter.next();
            String filename = new File(this.getPath(), loc.getFileName()).getPath();
            int lineNo = loc.getLineNumber();
            done = this.showEditorMessage(filename, lineNo, message, true, true, false, "exception");
            if (!firstTime || done) continue;
            message = message + " (in " + loc.getClassName() + ")";
            firstTime = false;
        }
        if (!done) {
            loc = stack.get(0);
            this.showMessageWithText("error-in-file", loc.getClassName() + ":" + loc.getLineNumber() + "\n" + message);
        }
    }

    public void exceptionMessage(String className, int lineNumber) {
        this.showEditorMessage(className, lineNumber, "", false, true, false, "exception");
    }

    public void reportException(String text) {
        this.showMessageWithText("exception-thrown", text);
    }

    protected static String getResourcePath(Class<?> c) {
        URL srcUrl;
        block7: {
            srcUrl = c.getResource(c.getSimpleName() + ".class");
            try {
                if (srcUrl != null) {
                    if (srcUrl.getProtocol().equals("file")) {
                        File srcFile = new File(srcUrl.toURI());
                        return srcFile.toString();
                    }
                    if (srcUrl.getProtocol().equals("jar")) {
                        int classIndex = srcUrl.toString().indexOf("!");
                        String subUrl = srcUrl.toString().substring(4, classIndex);
                        if (subUrl.startsWith("file:")) {
                            return new File(new URI(subUrl)).toString();
                        }
                        if (classIndex != -1) {
                            return srcUrl.toString().substring(4, classIndex);
                        }
                    }
                    break block7;
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return srcUrl.toString();
    }

    public static boolean checkClassMatchesFile(Class<?> c, File f) {
        block5: {
            try {
                URL srcUrl = c.getResource(c.getSimpleName() + ".class");
                if (srcUrl == null) {
                    return true;
                }
                if (srcUrl != null && srcUrl.getProtocol().equals("file")) {
                    File srcFile = new File(srcUrl.toURI());
                    if (!f.equals(srcFile)) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }

    public void closeAllEditors() {
        for (Target target : this.targets.toArray()) {
            EditableTarget et;
            if (!(target instanceof EditableTarget) || !(et = (EditableTarget)target).editorOpen()) continue;
            et.getEditor().close();
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public String toString() {
        return "Package:" + this.getQualifiedName();
    }

    private class PackageCompileObserver
    extends QuietPackageCompileObserver {
        private int numErrors;

        public PackageCompileObserver(CompileObserver chainObserver) {
            super(chainObserver);
            this.numErrors = 0;
        }

        @Override
        public void startCompile(File[] sources) {
            this.numErrors = 0;
            super.startCompile(sources);
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic) {
            super.compilerMessage(diagnostic);
            if (diagnostic.getType() == Diagnostic.ERROR) {
                return this.errorMessage(diagnostic);
            }
            return this.warningMessage(diagnostic.getFileName(), (int)diagnostic.getStartLine(), diagnostic.getMessage());
        }

        private boolean errorMessage(Diagnostic diagnostic) {
            ++this.numErrors;
            if (diagnostic.getFileName() == null) {
                Package.this.showMessageWithText("compiler-error", diagnostic.getMessage());
                return true;
            }
            String message = diagnostic.getMessage();
            ErrorShown messageShown = message.contains("cannot find symbol - method") ? Package.this.showEditorDiagnostic(diagnostic, new MisspeltMethodChecker(message, (int)diagnostic.getStartColumn(), (int)diagnostic.getStartLine(), Package.this.project), this.numErrors - 1) : Package.this.showEditorDiagnostic(diagnostic, null, this.numErrors - 1);
            switch (messageShown) {
                case EDITOR_NOT_FOUND: {
                    Package.this.showMessageWithText("error-in-file", diagnostic.getFileName() + ":" + diagnostic.getStartLine() + "\n" + message);
                    return true;
                }
                case ERROR_SHOWN: {
                    return true;
                }
            }
            return false;
        }

        private boolean warningMessage(String filename, int lineNo, String message) {
            return true;
        }

        @Override
        public void endCompile(File[] sources, boolean successful) {
            super.endCompile(sources, successful);
            if (successful && this.chainObserver == null && PrefMgr.getFlag("bluej.accessibility.support") && Package.this.getEditor().isVisible()) {
                DialogManager.showText(Package.this.getEditor(), Config.getString("pkgmgr.accessibility.compileDone"));
            }
        }
    }

    private static class MisspeltMethodChecker
    implements MessageCalculator {
        private static final int MAX_EDIT_DISTANCE = 2;
        private final String message;
        private int lineNumber;
        private int column;
        private Project project;

        public MisspeltMethodChecker(String message, int column, int lineNumber, Project project) {
            this.message = message;
            this.column = column;
            this.lineNumber = lineNumber;
            this.project = project;
        }

        private static String chopAtOpeningBracket(String name) {
            int openingBracket = name.indexOf(40);
            if (openingBracket >= 0) {
                return name.substring(0, openingBracket);
            }
            return name;
        }

        private String getLine(TextEditor e) {
            return e.getText(new bluej.parser.SourceLocation(this.lineNumber, 1), new bluej.parser.SourceLocation(this.lineNumber, e.getLineLength(this.lineNumber - 1)));
        }

        private int getLineStart(TextEditor e) {
            return e.getOffsetFromLineColumn(new bluej.parser.SourceLocation(this.lineNumber, 1));
        }

        @Override
        public String calculateMessage(Editor e0) {
            if (e0 == null) {
                return this.message;
            }
            TextEditor e = e0.assumeText();
            String missing = MisspeltMethodChecker.chopAtOpeningBracket(this.message.substring(this.message.lastIndexOf(32) + 1));
            String lineText = this.getLine(e);
            ParsedCUNode pcuNode = e.getParsedNode();
            if (pcuNode == null) {
                return this.message;
            }
            int pos = MisspeltMethodChecker.convertColumn(lineText, this.column) + this.getLineStart(e);
            LinkedList<String> maybeTheyMeant = new LinkedList<String>();
            CodeSuggestions suggests = pcuNode.getExpressionType(pos, e.getSourceDocument());
            AssistContent[] values = ParseUtils.getPossibleCompletions(suggests, this.project.getJavadocResolver(), null);
            if (values != null) {
                for (AssistContent a : values) {
                    String name = a.getName();
                    if (a.getKind() != AssistContent.CompletionKind.METHOD || Utility.editDistance(name.toLowerCase(), missing.toLowerCase()) > 2) continue;
                    maybeTheyMeant.addLast(a.getName());
                }
            }
            if (maybeTheyMeant.isEmpty()) {
                return this.message;
            }
            String augmentedMessage = this.message + "; maybe you meant: " + (String)maybeTheyMeant.getFirst();
            maybeTheyMeant.removeFirst();
            for (String sugg : maybeTheyMeant) {
                augmentedMessage = augmentedMessage + " or " + sugg;
            }
            return augmentedMessage;
        }

        private static int convertColumn(String string, int column) {
            int ccount = 0;
            int lpos = 0;
            int tabIndex = string.indexOf(9);
            while (tabIndex != -1 && lpos < column - 1) {
                lpos += tabIndex - ccount;
                ccount = tabIndex;
                if (lpos >= column - 1) break;
                lpos = (lpos + 8) / 8 * 8;
                tabIndex = string.indexOf(9, ++ccount);
            }
            return ccount += column - lpos;
        }
    }

    private class QuietPackageCompileObserver
    implements EDTCompileObserver {
        protected CompileObserver chainObserver;

        public QuietPackageCompileObserver(CompileObserver chainObserver) {
            this.chainObserver = chainObserver;
        }

        private void markAsCompiling(File[] sources) {
            for (int i = 0; i < sources.length; ++i) {
                Target t;
                String fileName = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(fileName);
                if (fullName == null || !((t = Package.this.getTarget(JavaNames.getBase(fullName))) instanceof ClassTarget)) continue;
                ClassTarget ct = (ClassTarget)t;
                ct.setState(2);
            }
        }

        private void sendEventToExtensions(String filename, int[] errorPosition, String message, int eventType) {
            File[] sources = filename != null ? new File[]{new File(filename)} : new File[]{};
            CompileEvent aCompileEvent = new CompileEvent(eventType, sources);
            aCompileEvent.setErrorPosition(errorPosition);
            aCompileEvent.setErrorMessage(message);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }

        @Override
        public void startCompile(File[] sources) {
            CompileEvent aCompileEvent = new CompileEvent(1, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            Package.this.setStatus(compiling);
            this.markAsCompiling(sources);
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic) {
            int[] errorPosition = new int[]{(int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn()};
            if (diagnostic.getType() == Diagnostic.ERROR) {
                this.errorMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage());
            } else {
                this.warningMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage());
            }
            return false;
        }

        private void errorMessage(String filename, int[] errorPosition, String message) {
            this.sendEventToExtensions(filename, errorPosition, message, 3);
        }

        private void warningMessage(String filename, int[] errorPosition, String message) {
            this.sendEventToExtensions(filename, errorPosition, message, 2);
        }

        @Override
        public void endCompile(File[] sources, boolean successful) {
            for (int i = 0; i < sources.length; ++i) {
                ClassTarget t;
                String filename = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(filename);
                if (fullName == null || (t = (ClassTarget)Package.this.targets.get(JavaNames.getBase(fullName))) == null) continue;
                boolean newCompiledState = successful;
                if (successful) {
                    t.endCompile();
                    Class<?> c = Package.this.loadClass(Package.this.getQualifiedName(t.getIdentifierName()));
                    if (c != null && !Package.checkClassMatchesFile(c, t.getClassFile())) {
                        String conflict = Package.getResourcePath(c);
                        DialogManager.showMessageWithPrefixText(null, "compile-class-library-conflict", t.getIdentifierName() + ":", conflict);
                    }
                    try {
                        ClassInfo info = t.getSourceInfo().getInfo(t.getJavaSourceFile(), t.getPackage());
                        if (info != null) {
                            FileOutputStream out = new FileOutputStream(t.getContextFile());
                            info.getComments().store(out, "BlueJ class context");
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    newCompiledState &= t.upToDate();
                    newCompiledState &= !t.hasKnownError();
                }
                t.setState(newCompiledState ? 0 : 1);
                t.setQueued(false);
                if (!successful || !t.editorOpen()) continue;
                t.getEditor().setCompiled(true);
            }
            Package.this.setStatus(compileDone);
            Package.this.graphChanged();
            int eventId = successful ? 4 : 5;
            CompileEvent aCompileEvent = new CompileEvent(eventId, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            if (this.chainObserver != null) {
                this.chainObserver.endCompile(sources, successful);
            }
        }
    }

    private static enum ErrorShown {
        ERROR_SHOWN,
        ERROR_NOT_SHOWN,
        EDITOR_NOT_FOUND;

    }

    public static interface MessageCalculator {
        public String calculateMessage(Editor var1);
    }
}

