/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.MIDletDeployer;
import bluej.utility.Debug;
import bluej.utility.SortedProperties;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class MIDletDeploymentTableModel
extends AbstractTableModel {
    private List<MIDletTableEntry> midlets;
    private File projectDir;
    private ImageIcon defaultIcon;
    private boolean[] exclude;
    private String[] columnNames = new String[]{Config.getString("midlet.deployment.midlets.classname"), Config.getString("midlet.deployment.midlets.name"), Config.getString("midlet.deployment.midlets.icon")};

    public MIDletDeploymentTableModel(List<String> currentList, File proj, SortedProperties props) {
        this.projectDir = proj;
        this.defaultIcon = this.getDefaultIcon();
        this.fillInTable(currentList, props);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.midlets.size();
    }

    @Override
    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    @Override
    public Object getValueAt(int r, int c) {
        MIDletTableEntry entry = this.midlets.get(r);
        if (c == 0) {
            return entry.getClassName();
        }
        if (c == 1) {
            return entry.getName();
        }
        if (c == 2) {
            return entry.getIcon();
        }
        return "ERROR in method getValueAt for row,col: " + r + "," + c;
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        if (c == 1 || c == 2) {
            MIDletTableEntry entry = this.midlets.get(r);
            if (c == 1) {
                entry.setName((String)value);
            } else {
                try {
                    URL url = new URL((String)value);
                    entry.setIcon(new ImageIcon(url));
                }
                catch (MalformedURLException mue) {
                    Debug.reportError("In setValueAt, could not create ImageIcon from value passed in.");
                }
            }
            this.midlets.set(r, entry);
            this.fireTableCellUpdated(r, c);
        }
    }

    boolean[] getExcluded() {
        return this.exclude;
    }

    private void fillInTable(List<String> current, SortedProperties props) {
        String name;
        String cl;
        this.midlets = new ArrayList<MIDletTableEntry>();
        this.exclude = new boolean[current.size()];
        for (int i = 0; i < this.exclude.length; ++i) {
            this.exclude[i] = false;
        }
        int j = 0;
        int i = 1;
        while ((cl = props.getProperty("midlet" + i + ".class")) != null) {
            if (current.contains(cl)) {
                current.remove(cl);
                name = props.getProperty("midlet" + i + ".name");
                String icon = props.getProperty("midlet" + i + ".icon");
                String excl = props.getProperty("midlet" + i + ".exclude");
                this.exclude[j] = excl.equals("true");
                ++j;
                ImageIcon image = this.defaultIcon;
                try {
                    image = new ImageIcon(new URL(icon));
                }
                catch (MalformedURLException mue) {
                    Debug.reportError("Could not create ImageIcon from midlet.defs info for midlet " + name + ". The icon String passed to URL constructor was " + icon);
                }
                this.midlets.add(new MIDletTableEntry(name, image, cl));
            }
            ++i;
        }
        for (i = 0; i < current.size(); ++i) {
            name = cl = current.get(i);
            int pos = cl.lastIndexOf(".");
            if (pos > 0) {
                name = cl.substring(pos + 1);
            }
            this.midlets.add(new MIDletTableEntry(name, this.defaultIcon, cl));
        }
    }

    private ImageIcon getDefaultIcon() {
        String defaultIconFilename = MIDletDeployer.ICONS_DIR + File.separator + "default.gif";
        File file = new File(this.projectDir, defaultIconFilename);
        if (file.exists()) {
            try {
                return new ImageIcon(file.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                Debug.reportError("For some strange reason BlueJ could not create a default icon. This should never happen. Something is goofy.");
            }
        }
        return new ImageIcon();
    }

    void saveTableToProps(SortedProperties props) {
        int i = 1;
        for (MIDletTableEntry entry : this.midlets) {
            props.setProperty("midlet" + i + ".name", entry.getName());
            props.setProperty("midlet" + i + ".class", entry.getClassName());
            String s = entry.getIcon().getDescription();
            if (s == null) {
                s = " ";
            }
            props.setProperty("midlet" + i + ".icon", s);
            props.setProperty("midlet" + i + ".exclude", this.exclude[i - 1] + "");
            ++i;
        }
    }

    void writeTableToPrintWriter(PrintWriter pw) {
        int i = 1;
        int j = 0;
        for (MIDletTableEntry entry : this.midlets) {
            if (!this.exclude[j]) {
                String s = entry.getIcon().getDescription();
                if (s == null) {
                    s = " ";
                } else {
                    int index = s.lastIndexOf("/icons");
                    s = s.substring(index);
                }
                pw.println("MIDlet-" + i + ": " + entry.getName() + ", " + s + ", " + entry.getClassName());
                ++i;
            }
            ++j;
        }
    }

    void moveRowUp(int row) {
        if (row > 0) {
            MIDletTableEntry temp = this.midlets.get(row - 1);
            this.midlets.set(row - 1, this.midlets.get(row));
            this.midlets.set(row, temp);
            this.fireTableRowsUpdated(row - 1, row);
        }
    }

    void moveRowDown(int row) {
        if (row < this.midlets.size() - 1) {
            MIDletTableEntry temp = this.midlets.get(row + 1);
            this.midlets.set(row + 1, this.midlets.get(row));
            this.midlets.set(row, temp);
            this.fireTableRowsUpdated(row, row + 1);
        }
    }

    private class MIDletTableEntry {
        private ImageIcon icon;
        private String name;
        private String className;

        public MIDletTableEntry(String name, ImageIcon icon, String className) {
            this.name = name;
            this.icon = icon;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }

        public String toString() {
            return this.name + " ," + this.className + " ," + this.icon.getDescription();
        }
    }
}

