/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.Token;
import bluej.parser.CodeSuggestions;
import bluej.parser.DocumentReader;
import bluej.parser.JavaParser;
import bluej.parser.TokenStream;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.JavaTokenFilter;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParentParsedNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.utility.GeneralCache;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.Element;

public abstract class JavaParentNode
extends ParentParsedNode
implements EntityResolver {
    protected GeneralCache<String, JavaEntity> valueEntityCache = new GeneralCache(10);
    protected GeneralCache<String, PackageOrClass> pocEntityCache = new GeneralCache(10);
    protected JavaParentNode parentNode;
    protected Map<String, ParsedNode> classNodes = new HashMap<String, ParsedNode>();
    protected Map<String, FieldNode> variables = new HashMap<String, FieldNode>();

    public JavaParentNode(JavaParentNode parent) {
        super(parent);
        this.parentNode = parent;
    }

    @Override
    protected JavaParentNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public void insertNode(ParsedNode child, int position, int size) {
        this.getNodeTree().insertNode(child, position, size);
        int childType = child.getNodeType();
        String childName = child.getName();
        if (childName != null && childType == 1) {
            this.classNodes.put(childName, child);
        }
    }

    public void insertVariable(FieldNode varNode, int pos, int size) {
        super.insertNode(varNode, pos, size);
        if (!this.variables.containsKey(varNode.getName())) {
            this.variables.put(varNode.getName(), varNode);
        }
    }

    public void insertField(FieldNode child, int position, int size) {
        this.insertVariable(child, position, size);
    }

    @Override
    public void childChangedName(ParsedNode child, String oldName) {
        super.childChangedName(child, oldName);
        if (child.getNodeType() == 1) {
            if (this.classNodes.get(oldName) == child) {
                this.classNodes.remove(oldName);
            }
            this.classNodes.put(child.getName(), child);
        }
        if (child.getNodeType() == 5) {
            if (this.variables.get(oldName) == child) {
                this.variables.remove(oldName);
            }
            this.variables.put(child.getName(), (FieldNode)child);
        }
    }

    @Override
    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        super.childRemoved(child, listener);
        String childName = child.getNode().getName();
        if (childName != null) {
            if (this.classNodes.get(childName) == child.getNode()) {
                this.classNodes.remove(childName);
            }
            if (this.variables.get(childName) == child.getNode()) {
                this.variables.remove(childName);
            }
        }
    }

    public ParsedNode getTypeNode(String name) {
        return this.classNodes.get(name);
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        if (this.parentNode != null) {
            return this.parentNode.resolveQualifiedClass(name);
        }
        return null;
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        ParsedNode cnode = this.classNodes.get(name);
        if (cnode != null) {
            return new TypeEntity(new ParsedReflective((ParsedTypeNode)cnode));
        }
        String accessp = name + ":" + (querySource != null ? querySource.getName() : "");
        PackageOrClass rval = this.pocEntityCache.get(accessp);
        if (rval != null || this.pocEntityCache.containsKey(accessp)) {
            return rval;
        }
        if (this.parentNode != null) {
            rval = this.parentNode.resolvePackageOrClass(name, querySource);
            this.pocEntityCache.put(accessp, rval);
        }
        return rval;
    }

    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource, int fromPosition) {
        return this.resolvePackageOrClass(name, querySource);
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        TypeEntity fieldType;
        FieldNode var = this.variables.get(name);
        if (var != null && (fieldType = var.getFieldType().resolveAsType()) != null) {
            return new ValueEntity(((JavaEntity)fieldType).getType());
        }
        String accessp = name + ":" + (querySource != null ? querySource.getName() : "");
        JavaEntity rval = this.valueEntityCache.get(accessp);
        if (rval != null || this.valueEntityCache.containsKey(accessp)) {
            return rval;
        }
        if (this.parentNode != null) {
            rval = this.parentNode.getValueEntity(name, querySource, this.getOffsetFromParent());
        }
        if (rval == null) {
            rval = this.resolvePackageOrClass(name, querySource, this.getOffsetFromParent());
        }
        this.valueEntityCache.put(accessp, rval);
        return rval;
    }

    public JavaEntity getValueEntity(String name, Reflective querySource, int fromPosition) {
        return this.getValueEntity(name, querySource);
    }

    @Override
    protected CodeSuggestions getExpressionType(int pos, int nodePos, JavaEntity defaultType, Document document) {
        boolean isStaticCtxt;
        GenTypeClass atype;
        this.valueEntityCache.clear();
        this.pocEntityCache.clear();
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNodeAtOrBefore(pos, nodePos);
        if (child != null && child.getEnd() >= pos) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document);
        }
        int startpos = nodePos;
        if (child != null) {
            startpos = child.getEnd();
        }
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(pos) + 1;
        Element lineEl = map.getElement(line - 1);
        startpos = Math.max(startpos, lineEl.getStartOffset());
        int col = startpos - map.getElement(line - 1).getStartOffset() + 1;
        DocumentReader r = new DocumentReader(document, startpos, pos);
        JavaLexer lexer = new JavaLexer(r, line, col, startpos);
        JavaTokenFilter filter = new JavaTokenFilter(lexer);
        LocatableToken token = filter.nextToken();
        LocatableToken prevToken = null;
        while (token.getType() != 1) {
            prevToken = token;
            token = filter.nextToken();
        }
        if (prevToken != null && prevToken.getEndLine() != token.getEndLine() && prevToken.getEndColumn() != token.getEndColumn()) {
            prevToken = null;
        }
        if (prevToken != null && startpos == nodePos) {
            CodeSuggestions suggests;
            int offset = this.getOffsetFromParent();
            int ppos = nodePos - offset;
            child = this.parentNode.getNodeTree().findNodeAtOrBefore(nodePos - 1, ppos);
            if (child != null && child.getNode().getNodeType() == 6 && child.getEnd() == nodePos && (suggests = ExpressionNode.suggestAsExpression(pos, child.getPosition(), this, defaultType, document)) != null) {
                return suggests;
            }
        }
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (atype == null) {
            return null;
        }
        boolean bl = isStaticCtxt = defaultType.resolveAsType() != null;
        if (prevToken != null && !Character.isJavaIdentifierPart(prevToken.getText().codePointAt(0))) {
            prevToken = null;
        }
        return new CodeSuggestions(atype, atype, prevToken, isStaticCtxt, true);
    }

    @Override
    public Token getMarkTokensFor(int pos, int length, int nodePos, Document document) {
        int nextTokLen;
        NodeTree.NodeAndPosition<ParsedNode> np;
        Token tok = new Token(0, 100);
        if (length == 0) {
            return tok;
        }
        Token dummyTok = tok;
        for (np = this.getNodeTree().findNodeAtOrAfter(pos, nodePos); np != null && np.getEnd() == pos; np = np.nextSibling()) {
        }
        int cp = pos;
        while (np != null && np.getPosition() < pos + length) {
            if (cp < np.getPosition()) {
                nextTokLen = np.getPosition() - cp;
                tok.next = JavaParentNode.tokenizeText(document, cp, nextTokLen);
                while (tok.next.id != 100) {
                    tok = tok.next;
                }
                cp = np.getPosition();
            }
            int remaining = pos + length - cp;
            if ((remaining = Math.min(remaining, np.getEnd() - cp)) != 0) {
                tok.next = np.getNode().getMarkTokensFor(cp, remaining, np.getPosition(), document);
                cp += remaining;
                while (tok.next.id != 100) {
                    tok = tok.next;
                }
            }
            np = np.nextSibling();
        }
        if (cp < pos + length) {
            nextTokLen = pos + length - cp;
            tok.next = JavaParentNode.tokenizeText(document, cp, nextTokLen);
            while (tok.next.id != 100) {
                tok = tok.next;
            }
        }
        tok.next = new Token(0, 100);
        return dummyTok.next;
    }

    protected static Token tokenizeText(Document document, int pos, int length) {
        Token dummyTok;
        DocumentReader dr = new DocumentReader(document, pos, pos + length);
        TokenStream lexer = JavaParser.getLexer(dr);
        JavaTokenFilter tokenStream = new JavaTokenFilter(lexer, null);
        Token token = dummyTok = new Token(0, 100);
        int curcol = 1;
        while (length > 0) {
            LocatableToken lt = tokenStream.nextToken();
            if (lt.getLine() > 1 || lt.getColumn() - curcol >= length) {
                token = token.next = new Token(length, 0);
                break;
            }
            if (lt.getColumn() > curcol) {
                token = token.next = new Token(lt.getColumn() - curcol, 0);
                length -= token.length;
                curcol += token.length;
            }
            int tokType = 0;
            if (JavaParser.isPrimitiveType(lt)) {
                tokType = 7;
            } else if (JavaParser.isModifier(lt)) {
                tokType = 4;
            } else if (lt.getType() == 161) {
                tokType = 8;
            } else if (lt.getType() == 160) {
                tokType = 9;
            } else {
                switch (lt.getType()) {
                    case 105: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 158: {
                        tokType = 4;
                        break;
                    }
                    case 62: 
                    case 64: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 106: {
                        tokType = 5;
                        break;
                    }
                    case 72: 
                    case 107: 
                    case 155: 
                    case 156: 
                    case 157: {
                        tokType = 6;
                        break;
                    }
                    case 145: {
                        tokType = 11;
                        break;
                    }
                }
            }
            int toklen = lt.getLength();
            if (lt.getEndLine() > 1) {
                toklen = length;
            }
            token = token.next = new Token(toklen, (byte)tokType);
            length -= toklen;
            curcol += toklen;
        }
        token.next = new Token(0, 100);
        return dummyTok.next;
    }
}

