/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.parser.AssistContent;
import bluej.parser.ConstructorOrMethodReflective;
import bluej.parser.MethodCompletion;
import bluej.pkgmgr.JavadocResolver;
import bluej.utility.JavaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ConstructorCompletion
extends AssistContent {
    private final ConstructorReflective con;
    private final String className;
    private final JavadocResolver javadocResolver;
    private final Map<String, GenTypeParameter> typeArgs;

    public ConstructorCompletion(ConstructorReflective c, Map<String, GenTypeParameter> typeArgs, JavadocResolver javadocResolver) {
        this.con = c;
        this.className = c.getDeclaringType().getSimpleName();
        this.javadocResolver = javadocResolver;
        this.typeArgs = typeArgs;
    }

    @Override
    public AssistContent.Access getAccessPermission() {
        return ConstructorCompletion.fromModifiers(this.con.getModifiers());
    }

    @Override
    public String getDeclaringClass() {
        return this.con.getDeclaringType().getSimpleName();
    }

    @Override
    public String getJavadoc() {
        String jd = this.con.getJavaDoc();
        if (jd == null && this.javadocResolver != null) {
            this.javadocResolver.getJavadoc(this.con);
            jd = this.con.getJavaDoc();
        }
        return jd;
    }

    @Override
    public boolean getJavadocAsync(final AssistContent.JavadocCallback callback, Executor executor) {
        String jd = this.con.getJavaDoc();
        if (jd == null && this.javadocResolver != null) {
            return this.javadocResolver.getJavadocAsync(this.con, new JavadocResolver.AsyncCallback(){

                @Override
                public void gotJavadoc(ConstructorOrMethodReflective method) {
                    if (method.getJavaDoc() == null) {
                        method.setJavaDoc("");
                    }
                    callback.gotJavadoc(ConstructorCompletion.this);
                }
            }, executor);
        }
        return true;
    }

    @Override
    public AssistContent.CompletionKind getKind() {
        return AssistContent.CompletionKind.CONSTRUCTOR;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getName() {
        return this.className;
    }

    @Override
    public List<AssistContent.ParamInfo> getParams() {
        this.getJavadoc();
        ArrayList<AssistContent.ParamInfo> r = new ArrayList<AssistContent.ParamInfo>();
        List<JavaType> paramTypes = this.con.getParamTypes();
        List<String> paramNames = this.con.getParamNames();
        for (int i = 0; i < paramTypes.size(); ++i) {
            JavaType t = this.convertToSolid(paramTypes.get(i));
            String paramName = paramNames == null ? null : paramNames.get(i);
            r.add(new AssistContent.ParamInfo(t.toString(), paramName, MethodCompletion.buildDummyName(t, paramName), this.javadocForParam(paramName)));
        }
        return r;
    }

    @Override
    public String getType() {
        return this.getDeclaringClass();
    }

    private JavaType convertToSolid(JavaType type) {
        if (!type.isPrimitive()) {
            type = this.typeArgs != null ? type.mapTparsToTypes(this.typeArgs).getTparCapture() : type.getErasedType();
        }
        return type;
    }

    @OnThread(value=Tag.Swing)
    private String javadocForParam(String paramName) {
        JavaUtils.Javadoc javadoc = JavaUtils.parseJavadoc(this.getJavadoc());
        if (javadoc == null) {
            return null;
        }
        String target = "param " + paramName;
        for (String block : javadoc.getBlocks()) {
            if (!block.startsWith(target) || !Character.isWhitespace(block.charAt(target.length()))) continue;
            return block.substring(target.length() + 1).trim();
        }
        return null;
    }
}

