/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.CommitFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.FileRenderer;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.SwingWorker;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CommitCommentsFrame
extends EscapeDialog {
    private JList commitFiles;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JTextArea commitText;
    private JButton commitButton;
    private JCheckBox includeLayout;
    private ActivityIndicator progressBar;
    private CommitAction commitAction;
    private CommitWorker commitWorker;
    private Project project;
    private Repository repository;
    private DefaultListModel commitListModel;
    private Set<TeamStatusInfo> changedLayoutFiles;
    private Set<File> packagesToCommmit = new HashSet<File>();
    private static String noFilesToCommit = Config.getString("team.nocommitfiles");

    public CommitCommentsFrame(Project proj) {
        this.project = proj;
        this.changedLayoutFiles = new HashSet<TeamStatusInfo>();
        this.createUI();
        DialogManager.centreDialog(this);
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (show) {
            this.commitAction.setEnabled(false);
            this.commitText.setEnabled(false);
            this.includeLayout.setSelected(false);
            this.includeLayout.setEnabled(false);
            this.changedLayoutFiles.clear();
            this.commitListModel.removeAllElements();
            this.repository = this.project.getRepository();
            if (this.repository != null) {
                block5: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project");
                        if (msg == null) break block5;
                        msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        DialogManager.showErrorText(this, msg);
                    }
                }
                this.startProgress();
                this.commitWorker = new CommitWorker();
                this.commitWorker.start();
            } else {
                super.setVisible(false);
            }
        }
    }

    protected void createUI() {
        this.setTitle(Config.getString("team.commit.title"));
        this.commitListModel = new DefaultListModel();
        this.setLocation(Config.getLocation("bluej.commitdisplay"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.commitdisplay", CommitCommentsFrame.this.getLocation());
            }
        });
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setBorder(BlueJTheme.generalBorderWithStatusBar);
        splitPane.setResizeWeight(0.5);
        this.topPanel = new JPanel();
        JScrollPane commitFileScrollPane = new JScrollPane();
        this.topPanel.setLayout(new BorderLayout());
        JLabel commitFilesLabel = new JLabel(Config.getString("team.commit.files"));
        commitFilesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.topPanel.add((Component)commitFilesLabel, "North");
        this.commitFiles = new JList(this.commitListModel);
        this.commitFiles.setCellRenderer(new FileRenderer(this.project));
        this.commitFiles.setEnabled(false);
        commitFileScrollPane.setViewportView(this.commitFiles);
        this.topPanel.add((Component)commitFileScrollPane, "Center");
        splitPane.setTopComponent(this.topPanel);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        JLabel commentLabel = new JLabel(Config.getString("team.commit.comment"));
        commentLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.bottomPanel.add((Component)commentLabel, "North");
        this.commitText = new JTextArea("");
        this.commitText.setRows(6);
        this.commitText.setColumns(42);
        Dimension size = this.commitText.getPreferredSize();
        size.width = this.commitText.getMinimumSize().width;
        this.commitText.setMinimumSize(size);
        JScrollPane commitTextScrollPane = new JScrollPane(this.commitText);
        commitTextScrollPane.setMinimumSize(size);
        this.bottomPanel.add((Component)commitTextScrollPane, "Center");
        this.commitAction = new CommitAction(this);
        this.commitButton = BlueJTheme.getOkButton();
        this.commitButton.setAction(this.commitAction);
        this.getRootPane().setDefaultButton(this.commitButton);
        JButton closeButton = BlueJTheme.getCancelButton();
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitCommentsFrame.this.commitWorker.abort();
                CommitCommentsFrame.this.commitAction.cancel();
                CommitCommentsFrame.this.setVisible(false);
            }
        });
        DBox buttonPanel = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        buttonPanel.setBorder(BlueJTheme.generalBorder);
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        DBox checkBoxPanel = new DBox(DBoxLayout.Y_AXIS, 0, 5, 0.5f);
        this.includeLayout = new JCheckBox(Config.getString("team.commit.includelayout"));
        this.includeLayout.setEnabled(false);
        this.includeLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox layoutCheck = (JCheckBox)e.getSource();
                if (layoutCheck.isSelected()) {
                    CommitCommentsFrame.this.addModifiedLayouts();
                    if (!CommitCommentsFrame.this.commitButton.isEnabled()) {
                        CommitCommentsFrame.this.commitAction.setEnabled(true);
                    }
                } else {
                    CommitCommentsFrame.this.removeModifiedLayouts();
                    if (CommitCommentsFrame.this.isCommitListEmpty()) {
                        CommitCommentsFrame.this.commitAction.setEnabled(false);
                    }
                }
            }
        });
        checkBoxPanel.add(this.includeLayout);
        checkBoxPanel.add(buttonPanel);
        buttonPanel.add(this.progressBar);
        buttonPanel.add(this.commitButton);
        buttonPanel.add(closeButton);
        this.bottomPanel.add((Component)checkBoxPanel, "South");
        splitPane.setBottomComponent(this.bottomPanel);
        this.getContentPane().add(splitPane);
        this.pack();
    }

    public String getComment() {
        return this.commitText.getText();
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    public void reset() {
        this.commitListModel.clear();
        this.setComment("");
    }

    private void removeModifiedLayouts() {
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            if (this.packagesToCommmit.contains(info.getFile().getParentFile())) continue;
            this.commitListModel.removeElement(info);
        }
        if (this.commitListModel.isEmpty()) {
            this.commitListModel.addElement(noFilesToCommit);
            this.commitText.setEnabled(false);
        }
    }

    private boolean isCommitListEmpty() {
        return this.commitListModel.isEmpty() || this.commitListModel.contains(noFilesToCommit);
    }

    private void addModifiedLayouts() {
        if (this.commitListModel.contains(noFilesToCommit)) {
            this.commitListModel.removeElement(noFilesToCommit);
            this.commitText.setEnabled(true);
        }
        HashSet<File> displayedLayouts = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            File parentFile = info.getFile().getParentFile();
            if (displayedLayouts.contains(parentFile) || this.packagesToCommmit.contains(parentFile)) continue;
            this.commitListModel.addElement(info);
            displayedLayouts.add(info.getFile().getParentFile());
        }
    }

    public Set<File> getChangedLayoutFiles() {
        HashSet<File> files = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            files.add(info.getFile());
        }
        return files;
    }

    private void removeChangedLayoutFile(File file) {
        Iterator<TeamStatusInfo> it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            TeamStatusInfo info = it.next();
            if (!info.getFile().equals(file)) continue;
            it.remove();
            return;
        }
    }

    public Set<TeamStatusInfo> getChangedLayoutInfo() {
        return this.changedLayoutFiles;
    }

    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    public void stopProgress() {
        this.progressBar.setRunning(false);
    }

    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged(boolean hasChanged) {
        this.includeLayout.setEnabled(hasChanged);
    }

    class CommitWorker
    extends SwingWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;

        public CommitWorker() {
            FileFilter filter = CommitCommentsFrame.this.project.getTeamSettingsController().getFileFilter(true);
            this.command = CommitCommentsFrame.this.repository.getStatus(this, filter, false);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void statusComplete(StatusHandle statusHandle) {
            CommitCommentsFrame.this.commitAction.setStatusHandle(statusHandle);
        }

        @Override
        @OnThread(value=Tag.Unique)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            CommitCommentsFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    TeamUtils.handleServerResponse(this.result, CommitCommentsFrame.this);
                    CommitCommentsFrame.this.setVisible(false);
                } else if (this.response != null) {
                    HashSet<File> filesToCommit = new HashSet<File>();
                    LinkedHashSet<File> filesToAdd = new LinkedHashSet<File>();
                    HashSet<File> filesToDelete = new HashSet<File>();
                    HashSet<File> mergeConflicts = new HashSet<File>();
                    HashSet<File> deleteConflicts = new HashSet<File>();
                    HashSet<File> otherConflicts = new HashSet<File>();
                    HashSet<File> needsMerge = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, mergeConflicts, deleteConflicts, otherConflicts, needsMerge, modifiedLayoutFiles);
                    if (!(mergeConflicts.isEmpty() && deleteConflicts.isEmpty() && otherConflicts.isEmpty() && needsMerge.isEmpty())) {
                        this.handleConflicts(mergeConflicts, deleteConflicts, otherConflicts, needsMerge);
                        return;
                    }
                    CommitCommentsFrame.this.commitAction.setFiles(filesToCommit);
                    CommitCommentsFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitCommentsFrame.this.commitAction.setDeletedFiles(filesToDelete);
                }
                if (CommitCommentsFrame.this.commitListModel.isEmpty()) {
                    CommitCommentsFrame.this.commitListModel.addElement(noFilesToCommit);
                } else {
                    CommitCommentsFrame.this.commitText.setEnabled(true);
                    CommitCommentsFrame.this.commitText.requestFocusInWindow();
                    CommitCommentsFrame.this.commitAction.setEnabled(true);
                }
            }
        }

        private void handleConflicts(Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge) {
            String filesList;
            String dlgLabel;
            if (!mergeConflicts.isEmpty()) {
                dlgLabel = "team-resolve-merge-conflicts";
                filesList = this.buildConflictsList(mergeConflicts);
            } else if (!deleteConflicts.isEmpty()) {
                dlgLabel = "team-resolve-conflicts-delete";
                filesList = this.buildConflictsList(deleteConflicts);
            } else if (!otherConflicts.isEmpty()) {
                dlgLabel = "team-update-first";
                filesList = this.buildConflictsList(otherConflicts);
            } else {
                CommitCommentsFrame.this.stopProgress();
                DialogManager.showMessage(CommitCommentsFrame.this, "team-uptodate-failed");
                CommitCommentsFrame.this.setVisible(false);
                return;
            }
            CommitCommentsFrame.this.stopProgress();
            DialogManager.showMessageWithText((Component)CommitCommentsFrame.this, dlgLabel, filesList);
            CommitCommentsFrame.this.setVisible(false);
        }

        private String buildConflictsList(Set<File> conflicts) {
            String filesList = "";
            Iterator<File> i = conflicts.iterator();
            for (int j = 0; j < 10 && i.hasNext(); ++j) {
                File conflictFile = i.next();
                filesList = filesList + "    " + conflictFile.getName() + "\n";
            }
            if (i.hasNext()) {
                filesList = filesList + "    " + Config.getString("team.commit.moreFiles");
            }
            return filesList;
        }

        private void getCommitFileSets(List<TeamStatusInfo> info, Set<File> filesToCommit, Set<File> filesToAdd, Set<File> filesToRemove, Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge, Set<File> modifiedLayoutFiles) {
            CommitFilter filter = new CommitFilter();
            HashMap<File, File> modifiedLayoutDirs = new HashMap<File, File>();
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                boolean isPkgFile = BlueJPackageFile.isPackageFileName(file.getName());
                int status = statusInfo.getStatus();
                if (filter.accept(statusInfo)) {
                    if (!isPkgFile) {
                        CommitCommentsFrame.this.commitListModel.addElement(statusInfo);
                        filesToCommit.add(file);
                    } else if (status == 6 || status == 2 || status == 14) {
                        if (CommitCommentsFrame.this.packagesToCommmit.add(statusInfo.getFile().getParentFile())) {
                            CommitCommentsFrame.this.commitListModel.addElement(statusInfo);
                            File otherPkgFile = (File)modifiedLayoutDirs.remove(file.getParentFile());
                            if (otherPkgFile != null) {
                                CommitCommentsFrame.this.removeChangedLayoutFile(otherPkgFile);
                                filesToCommit.add(otherPkgFile);
                            }
                        }
                        filesToCommit.add(statusInfo.getFile());
                    } else {
                        File parentFile = file.getParentFile();
                        if (!CommitCommentsFrame.this.packagesToCommmit.contains(parentFile)) {
                            modifiedLayoutFiles.add(file);
                            modifiedLayoutDirs.put(parentFile, file);
                            CommitCommentsFrame.this.changedLayoutFiles.add(statusInfo);
                        } else {
                            filesToCommit.add(file);
                        }
                    }
                    if (status == 6) {
                        filesToAdd.add(statusInfo.getFile());
                        continue;
                    }
                    if (status != 2 && status != 14) continue;
                    filesToRemove.add(statusInfo.getFile());
                    continue;
                }
                if (isPkgFile) continue;
                if (status == 9) {
                    mergeConflicts.add(statusInfo.getFile());
                }
                if (status == 8 || status == 12 || status == 13) {
                    deleteConflicts.add(statusInfo.getFile());
                }
                if (status == 14) {
                    otherConflicts.add(statusInfo.getFile());
                }
                if (status != 5) continue;
                needsMerge.add(statusInfo.getFile());
            }
            CommitCommentsFrame.this.setLayoutChanged(!CommitCommentsFrame.this.changedLayoutFiles.isEmpty());
        }
    }
}

