/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.groupwork.svn.SvnStatusHandle;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;

public class SvnStatusCommand
extends SvnCommand {
    private StatusListener listener;
    private FileFilter filter;
    private long currentRevision = -1L;

    public SvnStatusCommand(SvnRepository repository, StatusListener listener, FileFilter filter, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.filter = filter;
    }

    @Override
    protected TeamworkCommandResult doCommand() {
        SVNClientInterface client = this.getClient();
        File projectPath = this.getRepository().getProjectPath().getAbsoluteFile();
        try {
            final LinkedList statusList = new LinkedList();
            client.status(projectPath.getAbsolutePath(), 3, true, true, false, false, new String[0], new StatusCallback(){

                public void doStatus(Status arg0) {
                    statusList.add(arg0);
                }
            });
            Status[] status = statusList.toArray(new Status[statusList.size()]);
            HashSet<File> completed = new HashSet<File>();
            HashMap<File, Set<TeamStatusInfo>> unreported = new HashMap<File, Set<TeamStatusInfo>>();
            for (int i = 0; i < status.length; ++i) {
                String rev;
                File file = new File(status[i].getPath());
                int textStat = status[i].getTextStatus();
                int reposStat = status[i].getRepositoryTextStatus();
                long reposRev = status[i].getReposLastCmtRevisionNumber();
                if (reposRev > this.currentRevision) {
                    this.currentRevision = reposRev;
                }
                TeamStatusInfo rinfo = null;
                if (textStat == 6 || textStat == 4) {
                    rev = "" + status[i].getLastChangedRevisionNumber();
                    rinfo = reposStat == 2 ? new TeamStatusInfo(file, rev, "" + reposRev, 14) : new TeamStatusInfo(file, rev, "", 2);
                } else if (textStat == 5) {
                    if (this.filter.accept(file)) {
                        rinfo = reposStat != 3 ? new TeamStatusInfo(file, "", "", 6) : new TeamStatusInfo(file, "", "" + status[i].getReposLastCmtRevisionNumber(), 12);
                        if (file.isDirectory()) {
                            this.statLocalDir(file);
                        }
                    }
                } else if (textStat == 1) {
                    if (this.filter.accept(file)) {
                        rev = "" + status[i].getLastChangedRevisionNumber();
                        rinfo = reposStat == 4 ? new TeamStatusInfo(file, rev, "", 7) : (reposStat == 2 ? new TeamStatusInfo(file, rev, "" + status[i].getReposLastCmtRevisionNumber(), 3) : new TeamStatusInfo(file, rev, rev, 0));
                    }
                } else if (textStat == 2) {
                    if (this.filter.accept(file)) {
                        rev = "" + status[i].getLastChangedRevisionNumber();
                        rinfo = reposStat == 4 ? new TeamStatusInfo(file, rev, "", 13) : (reposStat == 2 ? new TeamStatusInfo(file, rev, "", 5) : new TeamStatusInfo(file, rev, rev, 4));
                    }
                } else if (textStat == 0) {
                    if (reposStat == 3) {
                        rinfo = new TeamStatusInfo(file, "", "" + reposRev, 1);
                    }
                } else if (textStat == 3) {
                    rinfo = new TeamStatusInfo(file, "", "", 4);
                }
                if (rinfo == null) continue;
                if (!file.exists()) {
                    this.listener.gotStatus(rinfo);
                    continue;
                }
                if (completed.contains(file.getParentFile()) || file.equals(projectPath)) {
                    this.complete(completed, unreported, rinfo);
                    continue;
                }
                HashSet<TeamStatusInfo> s = (HashSet<TeamStatusInfo>)unreported.get(file.getParentFile());
                if (s == null) {
                    s = new HashSet<TeamStatusInfo>();
                }
                s.add(rinfo);
                unreported.put(file.getParentFile(), s);
            }
            this.listener.statusComplete(new SvnStatusHandle(this.getRepository(), this.currentRevision));
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            if (!this.isCancelled()) {
                Debug.reportError("Subversion status command exception", ce);
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
            return new TeamworkCommandAborted();
        }
    }

    private void statLocalDir(File dir) {
        File[] subFiles = dir.listFiles(this.filter);
        for (int i = 0; i < subFiles.length; ++i) {
            this.listener.gotStatus(new TeamStatusInfo(subFiles[i], "", "", 6));
            if (!subFiles[i].isDirectory()) continue;
            this.statLocalDir(subFiles[i]);
        }
    }

    private void complete(Set<File> completed, Map<File, Set<TeamStatusInfo>> unreported, TeamStatusInfo rinfo) {
        this.listener.gotStatus(rinfo);
        int rinfoStat = rinfo.getStatus();
        File file = rinfo.getFile();
        if (file.isDirectory()) {
            completed.add(file);
            Set<TeamStatusInfo> entries = unreported.remove(file);
            if (entries == null) {
                entries = Collections.emptySet();
            }
            for (TeamStatusInfo status : entries) {
                int einfoStat = status.getStatus();
                if (rinfoStat == 13 || rinfoStat == 7) {
                    if (einfoStat == 2 || einfoStat == 1) continue;
                    if (einfoStat == 6) {
                        einfoStat = 13;
                    } else if (einfoStat == 4) {
                        einfoStat = 13;
                    } else if (einfoStat == 5) {
                        einfoStat = 13;
                    } else if (einfoStat == 3) {
                        einfoStat = 7;
                    } else if (einfoStat == 0) {
                        einfoStat = 7;
                    }
                    this.complete(completed, unreported, new TeamStatusInfo(status.getFile(), status.getLocalVersion(), status.getRepositoryVersion(), einfoStat));
                    continue;
                }
                this.complete(completed, unreported, status);
            }
        }
    }
}

