/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import java.io.File;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.LogDate;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnHistoryCommand
extends SvnCommand {
    private LogHistoryListener listener;

    public SvnHistoryCommand(SvnRepository repository, LogHistoryListener listener) {
        super(repository);
        this.listener = listener;
    }

    @Override
    protected TeamworkCommandResult doCommand() {
        SVNClientInterface client = this.getClient();
        File projectPath = this.getRepository().getProjectPath();
        try {
            RevisionRange rr = new RevisionRange(Revision.START, Revision.HEAD);
            client.logMessages(projectPath.getAbsolutePath(), Revision.HEAD, new RevisionRange[]{rr}, false, true, false, new String[]{"svn:author", "svn:date", "svn:log"}, 0L, new LogMessageCallback(){

                public void singleMessage(ChangePath[] paths, long revision, Map revProps, boolean hasChildren) {
                    if (paths.length == 0) {
                        return;
                    }
                    String revisionStr = Long.toString(revision);
                    Object ldate = revProps.get("svn:date");
                    try {
                        Date theDate = new LogDate(ldate.toString()).getDate();
                        String date = "";
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(theDate);
                        date = date + SvnHistoryCommand.padInt(calendar.get(1), 4);
                        date = date + "/" + SvnHistoryCommand.padInt(calendar.get(2) + 1, 2);
                        date = date + "/" + SvnHistoryCommand.padInt(calendar.get(5), 2);
                        date = date + " " + SvnHistoryCommand.padInt(calendar.get(11), 2);
                        date = date + ":" + SvnHistoryCommand.padInt(calendar.get(12), 2);
                        date = date + ":" + SvnHistoryCommand.padInt(calendar.get(13), 2);
                        String[] strPaths = new String[paths.length];
                        for (int j = 0; j < paths.length; ++j) {
                            strPaths[j] = paths[j].getPath();
                            int index = strPaths[j].indexOf(File.separator, 1);
                            strPaths[j] = index != -1 ? strPaths[j].substring(index + 1) : strPaths[j].substring(1);
                        }
                        String author = revProps.get("svn:author").toString();
                        String message = revProps.get("svn:log").toString();
                        HistoryInfo info = new HistoryInfo(strPaths, revisionStr, date, author, message);
                        SvnHistoryCommand.this.listener.logInfoAvailable(info);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            });
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            if (!this.isCancelled()) {
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
            return new TeamworkCommandAborted();
        }
    }

    private static String padInt(int number, int digits) {
        String result = Integer.toString(number);
        while (result.length() < digits) {
            result = "0" + result;
        }
        return result;
    }
}

