/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommandResult;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.actions.PkgMgrAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class TeamAction
extends AbstractAction {
    private PkgMgrFrame pkgMgrFrame;

    public TeamAction(String name) {
        this(Config.getString(name), false);
    }

    public TeamAction(String name, boolean showsDialog) {
        super(showsDialog ? Config.getString(name) + "..." : Config.getString(name));
        if (!Config.isMacOS()) {
            this.putValue("MnemonicKey", new Integer(Config.getMnemonicKey(name)));
        }
        if (Config.hasAcceleratorKey(name)) {
            this.putValue("AcceleratorKey", Config.getAcceleratorKey(name));
        }
    }

    public TeamAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    @OnThread(value=Tag.Swing)
    public void actionPerformed(ActionEvent e) {
        this.pkgMgrFrame = PkgMgrAction.frameFromEvent(e);
        this.actionPerformed(this.pkgMgrFrame);
    }

    @OnThread(value=Tag.Swing)
    public abstract void actionPerformed(PkgMgrFrame var1);

    protected void handleServerResponse(TeamworkCommandResult result) {
        TeamUtils.handleServerResponse(result, this.pkgMgrFrame);
    }

    protected void startProgressBar() {
        this.pkgMgrFrame.startProgress();
    }

    protected void stopProgressBar() {
        this.pkgMgrFrame.stopProgress();
    }

    protected void setStatus(String statusMessage) {
        this.pkgMgrFrame.setStatus(statusMessage);
    }

    protected void clearStatus() {
        this.pkgMgrFrame.clearStatus();
    }
}

