/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportAction
extends TeamAction {
    public ImportAction() {
        super("team.import");
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        Project project = pmf.getProject();
        if (project == null) {
            return;
        }
        this.doImport(pmf, project);
    }

    @OnThread(value=Tag.Swing)
    private void doImport(PkgMgrFrame pmf, final Project project) {
        Repository repository;
        TeamSettingsController tsc;
        block3: {
            tsc = new TeamSettingsController(project.getProjectDir());
            repository = tsc.getRepository(true);
            if (repository == null) {
                return;
            }
            try {
                project.saveAll();
                project.saveAllEditors();
            }
            catch (IOException ioe) {
                String msg = DialogManager.getMessage("team-error-saving-project");
                if (msg == null) break block3;
                msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                DialogManager.showErrorText(pmf, msg);
                return;
            }
        }
        this.setStatus(Config.getString("team.sharing"));
        this.startProgressBar();
        Thread thread = new Thread(){
            TeamworkCommandResult result = null;

            @Override
            public void run() {
                TeamworkCommand command = repository.shareProject();
                this.result = command.getResult();
                if (!this.result.isError()) {
                    AtomicReference files = new AtomicReference();
                    try {
                        EventQueue.invokeAndWait(() -> {
                            project.setTeamSettingsController(tsc);
                            Set<File> projFiles = tsc.getProjectFiles(true);
                            files.set(new HashSet<File>(projFiles));
                        });
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        Debug.reportError(e);
                    }
                    LinkedHashSet<File> newFiles = new LinkedHashSet<File>((Collection)files.get());
                    Set<File> binFiles = TeamUtils.extractBinaryFilesFromSet(newFiles);
                    command = repository.commitAll(newFiles, binFiles, Collections.emptySet(), (Set)files.get(), Config.getString("team.import.initialMessage"));
                    this.result = command.getResult();
                }
                ImportAction.this.stopProgressBar();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportAction.this.handleServerResponse(result);
                        if (!result.isError()) {
                            ImportAction.this.setStatus(Config.getString("team.shared"));
                            DataCollector.teamShareProject(project, repository);
                        } else {
                            ImportAction.this.clearStatus();
                        }
                    }
                });
            }
        };
        thread.start();
    }
}

