/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.gentype.JavaType;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssertPanel
extends JPanel {
    private static final String equalToLabel = Config.getString("debugger.assert.equalTo");
    private static final String sameAsLabel = Config.getString("debugger.assert.sameAs");
    private static final String notSameAsLabel = Config.getString("debugger.assert.notSameAs");
    private static final String notNullLabel = Config.getString("debugger.assert.notNull");
    private static final String assertNullLabel = Config.getString("debugger.assert.null");
    private static final String equalToFloatingPointLabel = Config.getString("debugger.assert.equalToFloatingPoint");
    private JPanel standardPanel;
    private JLabel assertLabel;
    private JLabel deltaLabel;
    private JTextField assertData;
    private JTextField deltaData;
    private JComboBox assertCombo;
    protected JCheckBox assertCheckbox;
    private int[] comboIndexes;
    private boolean[] firstLabelFieldNeeded = new boolean[]{true, true, true, false, false, true};
    private boolean[] secondFieldNeeded = new boolean[]{false, false, false, false, false, true};
    private String[][] labelStatements = new String[][]{{equalToLabel, "assertEquals"}, {sameAsLabel, "assertSame"}, {notSameAsLabel, "assertNotSame"}, {notNullLabel, "assertNotNull"}, {assertNullLabel, "assertNull"}, {equalToFloatingPointLabel, "assertEquals"}};
    private int[] fpIndexes = new int[]{5};
    private int[] primitiveIndexes = new int[]{0};
    private int[] objectIndexes = new int[]{0, 1, 2, 3, 4};

    public AssertPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.assertCheckbox = new JCheckBox(Config.getString("debugger.assert.assertThat"), true);
        this.assertCheckbox.setAlignmentX(0.0f);
        this.assertCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                boolean isSelected = ie.getStateChange() == 1;
                AssertPanel.this.assertCombo.setEnabled(isSelected);
                AssertPanel.this.assertData.setEnabled(isSelected);
                AssertPanel.this.assertLabel.setEnabled(isSelected);
                AssertPanel.this.deltaData.setEnabled(isSelected);
                AssertPanel.this.deltaLabel.setEnabled(isSelected);
            }
        });
        this.standardPanel = new JPanel();
        this.standardPanel.setBorder(BlueJTheme.generalBorder);
        this.standardPanel.setLayout(new BoxLayout(this.standardPanel, 0));
        this.standardPanel.setAlignmentX(0.0f);
        this.assertLabel = new JLabel(Config.getString("debugger.assert.resultIs"));
        this.standardPanel.add(this.assertLabel);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.assertCombo = new JComboBox();
        this.assertCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    AssertPanel.this.itemSelected(AssertPanel.this.assertCombo.getSelectedIndex());
                }
            }
        });
        this.assertData = new JTextField(14);
        this.deltaData = new JTextField(6);
        this.standardPanel.add(this.assertCombo);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.deltaLabel = new JLabel(Config.getString("debugger.assert.delta"));
        this.standardPanel.add(this.assertData);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.standardPanel.add(this.deltaLabel);
        this.standardPanel.add(Box.createHorizontalStrut(5));
        this.standardPanel.add(this.deltaData);
        this.deltaData.setVisible(false);
        this.deltaLabel.setVisible(false);
        this.assertCombo.setEnabled(true);
        this.assertData.setEnabled(true);
        this.assertLabel.setEnabled(true);
        this.deltaData.setEnabled(true);
        this.deltaLabel.setEnabled(true);
        this.add(this.assertCheckbox);
        this.add(this.standardPanel);
    }

    private void itemSelected(int index) {
        if ((index = this.comboIndexes[index]) >= 0) {
            boolean firstNeeded = this.firstLabelFieldNeeded[index] && this.assertCheckbox.isSelected();
            boolean secondNeeded = this.secondFieldNeeded[index] && this.assertCheckbox.isSelected();
            this.assertData.setEnabled(firstNeeded);
            this.deltaLabel.setVisible(this.secondFieldNeeded[index]);
            this.deltaData.setVisible(this.secondFieldNeeded[index]);
            this.deltaLabel.setEnabled(secondNeeded);
            this.deltaData.setEnabled(secondNeeded);
        }
    }

    public void setResultType(JavaType type) {
        if (type.typeIs(JavaType.JT_FLOAT) || type.typeIs(JavaType.JT_DOUBLE)) {
            this.comboIndexes = this.fpIndexes;
            this.deltaData.setText("0.1");
            this.itemSelected(0);
        } else {
            this.comboIndexes = type.isPrimitive() ? this.primitiveIndexes : this.objectIndexes;
        }
        String[] comboLabels = new String[this.comboIndexes.length];
        for (int i = 0; i < comboLabels.length; ++i) {
            comboLabels[i] = this.labelStatements[this.comboIndexes[i]][0];
        }
        this.assertCombo.setModel(new DefaultComboBoxModel<String>(comboLabels));
    }

    public boolean isAssertEnabled() {
        return this.assertCheckbox != null ? this.assertCheckbox.isSelected() : false;
    }

    public boolean isAssertComplete() {
        int index = this.comboIndexes[this.assertCombo.getSelectedIndex()];
        if (this.secondFieldNeeded[index] && this.deltaData.getText().trim().length() == 0) {
            return false;
        }
        return !this.firstLabelFieldNeeded[index] || this.assertData.getText().trim().length() != 0;
    }

    public String getAssertStatement() {
        int index = this.comboIndexes[this.assertCombo.getSelectedIndex()];
        if (this.secondFieldNeeded[index]) {
            return InvokerRecord.makeAssertionStatement(this.labelStatements[index][1], this.assertData.getText(), this.deltaData.getText());
        }
        if (this.firstLabelFieldNeeded[index]) {
            return InvokerRecord.makeAssertionStatement(this.labelStatements[index][1], this.assertData.getText());
        }
        return InvokerRecord.makeAssertionStatement(this.labelStatements[index][1]);
    }

    public void recordAssertion(Package pkg, int testIdentifier, int invocationIdentifier) {
        int index = this.comboIndexes[this.assertCombo.getSelectedIndex()];
        DataCollector.assertTestMethod(pkg, testIdentifier, invocationIdentifier, this.labelStatements[index][1], this.firstLabelFieldNeeded[index] ? this.assertData.getText() : null, this.secondFieldNeeded[index] ? this.deltaData.getText() : null);
    }
}

