/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.Diagnostic;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CompilerAPICompiler
extends Compiler {
    public CompilerAPICompiler() {
        this.setDebug(true);
        this.setDeprecation(true);
    }

    @Override
    public boolean compile(final File[] sources, final CompileObserver observer, final boolean internal, List<String> userOptions, Charset fileCharset) {
        boolean result = true;
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> optionsList = new ArrayList<String>();
        if (jc == null) {
            observer.compilerMessage(new Diagnostic(Diagnostic.ERROR, "The compiler does not appear to be available."));
            return false;
        }
        DiagnosticListener<JavaFileObject> diagListener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(javax.tools.Diagnostic<? extends JavaFileObject> diag) {
                Diagnostic bjDiagnostic;
                String src = null;
                if (diag.getSource() != null) {
                    if (Config.isJava17()) {
                        src = diag.getSource().getName();
                    } else {
                        URI srcUri = sources[0].toURI().resolve(diag.getSource().toUri());
                        src = new File(srcUri).getPath();
                    }
                }
                String message = diag.getMessage(null);
                if (diag.getKind() == Diagnostic.Kind.ERROR) {
                    int diagType = Diagnostic.ERROR;
                    message = CompilerAPICompiler.this.processMessage(src, (int)diag.getLineNumber(), message);
                    long beginCol = diag.getColumnNumber();
                    long endCol = diag.getEndPosition() - diag.getPosition() + beginCol;
                    if (diag.getEndPosition() == -1L) {
                        endCol = beginCol;
                    }
                    bjDiagnostic = new Diagnostic(diagType, message, src, diag.getLineNumber(), beginCol, diag.getLineNumber(), endCol);
                } else if (diag.getKind() == Diagnostic.Kind.WARNING) {
                    if (message.startsWith("bootstrap class path not set in conjunction with -source ")) {
                        return;
                    }
                    if (message.startsWith("\u672a\u4e0e -source") && message.endsWith("\u4e00\u8d77\u8bbe\u7f6e\u5f15\u5bfc\u7c7b\u8def\u5f84")) {
                        return;
                    }
                    if (message.startsWith("\u30d6\u30fc\u30c8\u30b9\u30c8\u30e9\u30c3\u30d7\u30fb\u30af\u30e9\u30b9\u30d1\u30b9\u304c-source") && message.endsWith("\u4e00\u7dd2\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093")) {
                        return;
                    }
                    System.out.println(message);
                    int diagType = Diagnostic.WARNING;
                    long beginCol = diag.getColumnNumber();
                    long endCol = diag.getEndPosition() - diag.getPosition() + beginCol;
                    bjDiagnostic = new Diagnostic(diagType, message, src, diag.getLineNumber(), beginCol, diag.getLineNumber(), endCol);
                } else {
                    int diagType = Diagnostic.NOTE;
                    bjDiagnostic = new Diagnostic(diagType, message);
                    if (internal && (message.endsWith(" uses unchecked or unsafe operations.") || message.endsWith("Some input files use unchecked or unsafe operations.") || message.endsWith("Recompile with -Xlint:unchecked for details."))) {
                        return;
                    }
                }
                observer.compilerMessage(bjDiagnostic);
            }
        };
        try {
            File[] bootClassPath;
            StandardJavaFileManager sjfm = jc.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagListener, null, fileCharset);
            ArrayList pathList = new ArrayList();
            ArrayList<File> outputList = new ArrayList<File>();
            outputList.add(this.getDestDir());
            Collections.addAll(pathList, this.getClassPath());
            sjfm.setLocation(StandardLocation.SOURCE_PATH, outputList);
            sjfm.setLocation(StandardLocation.CLASS_PATH, pathList);
            sjfm.setLocation(StandardLocation.CLASS_OUTPUT, outputList);
            Iterable<? extends JavaFileObject> compilationUnits1 = sjfm.getJavaFileObjectsFromFiles(Arrays.asList(sources));
            if (this.isDebug()) {
                optionsList.add("-g");
            }
            if (this.isDeprecation()) {
                optionsList.add("-deprecation");
            }
            if ((bootClassPath = this.getBootClassPath()) != null && bootClassPath.length != 0) {
                sjfm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, Arrays.asList(bootClassPath));
            }
            optionsList.addAll(userOptions);
            result = jc.getTask(null, sjfm, (DiagnosticListener<? super JavaFileObject>)diagListener, optionsList, null, compilationUnits1).call();
            sjfm.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return result;
    }

    protected String processMessage(String src, int pos, String message) {
        String expected = src + ":" + pos + ": ";
        if (message.startsWith(expected)) {
            message = message.substring(expected.length());
        }
        if (message.contains("cannot resolve symbol") || message.contains("cannot find symbol") || message.contains("incompatible types")) {
            String line3;
            String line2;
            int index1 = message.indexOf(10);
            if (index1 == -1) {
                return message;
            }
            int index2 = message.indexOf(10, index1 + 1);
            if (index2 < index1) {
                line2 = message.substring(index1).trim();
                line3 = "";
            } else {
                line2 = message.substring(index1, index2).trim();
                line3 = message.substring(index2).trim();
            }
            message = message.substring(0, index1);
            if (line2.startsWith("found") && line2.indexOf(58) != -1) {
                message = message + " - found " + line2.substring(line2.indexOf(58) + 2, line2.length());
            }
            if (line3.startsWith("required") && line3.indexOf(58) != -1) {
                message = message + " but expected " + line3.substring(line3.indexOf(58) + 2, line3.length());
            }
            if (line2.startsWith("symbol") && line2.indexOf(58) != -1) {
                message = message + " - " + line2.substring(line2.indexOf(58) + 2, line2.length());
            }
        }
        return message;
    }
}

