/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJPropStringSource;
import bluej.BlueJTheme;
import bluej.Boot;
import bluej.PropParser;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Scanner;
import javafx.scene.Scene;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Config {
    public static final String nl = System.getProperty("line.separator");
    public static final String osname = System.getProperty("os.name", "");
    public static final String DEFAULT_LANGUAGE = "english";
    public static final String BLUEJ_OPENPACKAGE = "bluej.openPackage";
    public static final String bluejDebugLogName = "bluej-debuglog.txt";
    public static final String greenfootDebugLogName = "greenfoot-debuglog.txt";
    public static final Color ENV_COLOUR = new Color(152, 32, 32);
    protected static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final KeyStroke GREENFOOT_SET_PLAYER_NAME_SHORTCUT = KeyStroke.getKeyStroke(80, SHORTCUT_MASK | 0x40);
    private static final String BLUEJ_DEBUG_DOCK_ICON = "vm.icns";
    private static final String GREENFOOT_DEBUG_DOCK_ICON = "greenfootvm.icns";
    private static final String BLUEJ_DEBUG_DOCK_NAME = "BlueJ Virtual Machine";
    private static final String GREENFOOT_DEBUG_DOCK_NAME = "Greenfoot";
    public static Properties moeSystemProps;
    public static Properties moeUserProps;
    public static String compilertype;
    public static String language;
    public static Rectangle screenBounds;
    public static String debugLogName;
    public static List<String> fontOptions;
    private static Boolean isRaspberryPi;
    private static Border focusBorder;
    private static Border normalBorder;
    private static Properties systemProps;
    private static Properties userProps;
    private static Properties greenfootProps;
    private static Properties commandProps;
    private static Properties initialCommandLineProps;
    private static Properties langProps;
    private static Properties langVarProps;
    private static BlueJPropStringSource propSource;
    private static File bluejLibDir;
    private static File userPrefDir;
    private static File greenfootLibDir;
    private static boolean usingMacOSScreenMenubar;
    private static boolean initialised;
    private static boolean isGreenfoot;
    private static Color selectionColour;
    private static Color selectionColour2;
    private static Color highlightColour;
    private static Color highlightColour2;
    private static List<String> debugVMArgs;
    private static boolean isDebugVm;

    public static void initialise(File bluejLibDir, Properties tempCommandLineProps, boolean bootingGreenfoot) {
        Config.initialise(bluejLibDir, tempCommandLineProps, bootingGreenfoot, true);
    }

    private static void initialise(File bluejLibDir, Properties tempCommandLineProps, boolean bootingGreenfoot, boolean createUserhome) {
        if (initialised) {
            return;
        }
        initialised = true;
        initialCommandLineProps = tempCommandLineProps;
        isGreenfoot = bootingGreenfoot;
        screenBounds = Config.calculateScreenBounds();
        Config.bluejLibDir = bluejLibDir;
        greenfootLibDir = new File(bluejLibDir, "greenfoot");
        if (systemProps == null) {
            isDebugVm = false;
            systemProps = Config.loadDefs("bluej.defs", System.getProperties());
            if (Config.isGreenfoot()) {
                greenfootProps = Config.loadDefs("greenfoot.defs", systemProps);
                userProps = new Properties(greenfootProps);
            } else {
                userProps = new Properties(systemProps);
            }
        }
        commandProps = new Properties(userProps);
        commandProps.putAll((Map<?, ?>)tempCommandLineProps);
        commandProps.setProperty("bluej.libdir", bluejLibDir.getAbsolutePath());
        if (createUserhome) {
            Config.initUserHome();
            Config.loadProperties(Config.getApplicationName().toLowerCase(), userProps);
            if (isGreenfoot) {
                debugLogName = greenfootDebugLogName;
            }
            Config.checkDebug(userPrefDir);
        }
        Config.initLanguage();
        moeSystemProps = Config.loadDefs("moe.defs", System.getProperties());
        moeUserProps = new Properties(moeSystemProps);
        Config.loadProperties("moe", moeUserProps);
        String macOSscreenMenuBar = Config.getPropString("bluej.macos.screenmenubar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", macOSscreenMenuBar);
        usingMacOSScreenMenubar = Config.isMacOS() && macOSscreenMenuBar.equals("true");
        boolean themed = Config.getPropBoolean("bluej.useTheme");
        if (themed) {
            MetalLookAndFeel.setCurrentTheme(new BlueJTheme());
        }
        String laf = Config.getPropString("bluej.lookAndFeel", "bluejdefault");
        Config.setLookAndFeel(laf);
        Config.initDebugVMArgs();
        Config.setVMLocale();
        commandProps.setProperty("bluej.version", "3.1.6");
    }

    private static void initLanguage() {
        language = commandProps.getProperty("bluej.language", null);
        if (language == null) {
            language = DEFAULT_LANGUAGE;
            try {
                String langString;
                String iso3lang = Locale.getDefault().getISO3Language();
                int i = 1;
                while ((langString = Config.getPropString("bluej.language" + i, null)) != null) {
                    int secondColon;
                    int colonIndex = langString.indexOf(58);
                    if (colonIndex != -1 && (secondColon = langString.indexOf(58, colonIndex + 1)) != -1 && langString.substring(secondColon + 1).equals(iso3lang)) {
                        language = langString.substring(0, colonIndex);
                        break;
                    }
                    ++i;
                }
                Debug.log("Detected language \"" + language + "\" based on iso639-2 code \"" + iso3lang + "\"");
            }
            catch (MissingResourceException mre) {
                Debug.log("Using default language \"" + language + "\"");
            }
        }
        langProps = Config.loadLanguageLabels(language);
    }

    private static void initUserHome() {
        String propertyName;
        String homeDir = Config.getPropString("bluej.userHome", "$user.home");
        File userHome = new File(homeDir);
        String prefDirName = Config.getBlueJPrefDirName();
        userPrefDir = new File(userHome, prefDirName);
        int nameCounter = 1;
        while (!(userPrefDir.isDirectory() ? userPrefDir.canWrite() : userPrefDir.mkdirs()) && (homeDir = Config.getPropString(propertyName = "bluej.userHome" + ++nameCounter, null)) != null) {
            userHome = new File(homeDir);
            userPrefDir = new File(userHome, prefDirName);
        }
        if (homeDir == null) {
            homeDir = System.getProperty("user.home");
            userHome = new File(homeDir);
            userPrefDir = new File(userHome, prefDirName);
        }
    }

    public static void initializeVMside(File bluejLibDir, File userConfigDir, Properties tempCommandLineProps, boolean bootingGreenfoot, BlueJPropStringSource propSource) {
        isDebugVm = true;
        Config.propSource = propSource;
        userPrefDir = userConfigDir;
        systemProps = new Properties(){

            @Override
            public String getProperty(String key) {
                return propSource.getBlueJPropertyString(key, null);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getBlueJPropertyString(key, def);
            }
        };
        userProps = new Properties(systemProps){

            @Override
            public synchronized Object setProperty(String key, String val) {
                String rval = this.getProperty(key);
                propSource.setUserProperty(key, val);
                return rval;
            }

            @Override
            public String getProperty(String key) {
                return propSource.getBlueJPropertyString(key, null);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getBlueJPropertyString(key, def);
            }
        };
        Config.initialise(bluejLibDir, tempCommandLineProps, bootingGreenfoot, false);
    }

    public static Properties getInitialCommandLineProperties() {
        return initialCommandLineProps;
    }

    public static void initializeStandalone(BlueJPropStringSource propSource) {
        if (initialised) {
            return;
        }
        initialised = true;
        isGreenfoot = true;
        Config.propSource = propSource;
        commandProps = langProps = new Properties(){

            @Override
            public String getProperty(String key) {
                return propSource.getLabel(key);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getLabel(key);
            }
        };
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public static String getVMIconsName() {
        if (Config.isGreenfoot()) {
            return GREENFOOT_DEBUG_DOCK_ICON;
        }
        return BLUEJ_DEBUG_DOCK_ICON;
    }

    public static String getVMDockName() {
        if (Config.isGreenfoot()) {
            return GREENFOOT_DEBUG_DOCK_NAME;
        }
        return BLUEJ_DEBUG_DOCK_NAME;
    }

    public static boolean isDebugVM() {
        return isDebugVm;
    }

    public static boolean isMacOS() {
        return osname.startsWith("Mac");
    }

    public static boolean isRaspberryPi() {
        if (isRaspberryPi == null) {
            boolean result = false;
            if (Config.isLinux()) {
                try {
                    Scanner scanner = new Scanner(new File("/proc/cpuinfo"));
                    while (scanner.hasNextLine()) {
                        String lineFromFile = scanner.nextLine();
                        if (!lineFromFile.startsWith("Hardware") || !lineFromFile.contains("BCM")) continue;
                        result = true;
                        break;
                    }
                    scanner.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            isRaspberryPi = result;
        }
        return isRaspberryPi;
    }

    public static boolean isMacOSLeopard() {
        return osname.startsWith("Mac") && System.getProperty("os.version").compareTo("10.5") >= 0;
    }

    public static boolean isMacOSSnowLeopard() {
        return osname.startsWith("Mac") && System.getProperty("os.version").compareTo("10.6") >= 0;
    }

    public static boolean isWinOS() {
        return osname.startsWith("Windows");
    }

    public static boolean isModernWinOS() {
        return Config.isWinOS() && System.getProperty("os.version").compareTo("6.0") >= 0;
    }

    public static boolean isLinux() {
        return osname.startsWith("Linux");
    }

    public static boolean isSolaris() {
        return osname.startsWith("Solaris");
    }

    public static boolean isJava15() {
        return System.getProperty("java.specification.version").compareTo("1.5") >= 0;
    }

    public static boolean isJava16() {
        return System.getProperty("java.specification.version").compareTo("1.6") >= 0;
    }

    public static boolean isJava17() {
        return System.getProperty("java.specification.version").compareTo("1.7") >= 0;
    }

    public static boolean isOpenJDK() {
        return System.getProperty("java.runtime.name").startsWith("OpenJDK");
    }

    public static boolean usingJava15() {
        return Config.isJava15();
    }

    private static String getBlueJPrefDirName() {
        String programName = "bluej";
        if (isGreenfoot) {
            programName = "greenfoot";
        }
        if (Config.isMacOS()) {
            return "Library/Preferences/org." + programName;
        }
        if (Config.isWinOS()) {
            return programName;
        }
        return "." + programName;
    }

    public static String getApplicationName() {
        if (isGreenfoot) {
            return GREENFOOT_DEBUG_DOCK_NAME;
        }
        return "BlueJ";
    }

    public static boolean usingMacScreenMenubar() {
        return usingMacOSScreenMenubar;
    }

    private static Rectangle calculateScreenBounds() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(d);
    }

    private static void checkDebug(File userdir) {
        if (!Config.isDebugVM() && !"true".equals(commandProps.getProperty("bluej.debug"))) {
            File debugLogFile = new File(userdir, debugLogName);
            try {
                PrintStream outStream = new PrintStream(new FileOutputStream(debugLogFile));
                System.setOut(outStream);
                System.setErr(outStream);
                Debug.setDebugStream(new OutputStreamWriter(outStream));
                Debug.message(Config.getApplicationName() + " run started: " + new Date());
                if (Config.isGreenfoot()) {
                    Debug.message("Greenfoot version: " + Boot.GREENFOOT_VERSION);
                } else {
                    Debug.message("BlueJ version 3.1.6");
                }
                Debug.message("Java version " + System.getProperty("java.version"));
                Debug.message("Virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
                Debug.message("Running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
                Debug.message("Java Home: " + System.getProperty("java.home"));
                Debug.message("----");
                return;
            }
            catch (IOException e) {
                Debug.reportError("Warning: Unable to create debug log file.");
            }
        }
        Debug.setDebugStream(new OutputStreamWriter(System.out));
    }

    public static void handleExit() {
        String name = Config.getApplicationName().toLowerCase();
        Config.saveProperties(name, "properties.heading." + name, userProps);
        Config.saveProperties("moe", "properties.heading.moe", moeUserProps);
    }

    private static Properties loadDefs(String filename, Properties parentProperties) {
        File propsFile = new File(bluejLibDir, filename);
        Properties defs = new Properties(parentProperties);
        try {
            defs.load(new FileInputStream(propsFile));
        }
        catch (Exception e) {
            Debug.reportError("Unable to load definitions file: " + propsFile);
        }
        return defs;
    }

    private static Properties loadLanguageLabels(String language) {
        Properties labels = Config.loadDefs(DEFAULT_LANGUAGE + File.separator + "labels", System.getProperties());
        if (Config.isGreenfoot()) {
            String greenfootLabels = DEFAULT_LANGUAGE + File.separator + "greenfoot/greenfoot-labels";
            File greenfootLabelFile = new File(bluejLibDir, greenfootLabels);
            try {
                labels.load(new FileInputStream(greenfootLabelFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load greenfoot labels file: " + greenfootLabelFile);
            }
            String frameLabels = DEFAULT_LANGUAGE + File.separator + "frame-labels";
            File frameLabelFile = new File(bluejLibDir, frameLabels);
            try {
                labels.load(new FileInputStream(frameLabelFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load greenfoot labels file: " + frameLabelFile);
            }
        }
        if (!DEFAULT_LANGUAGE.equals(language)) {
            String languageFileName = language + File.separator + "labels";
            File languageFile = new File(bluejLibDir, languageFileName);
            try {
                labels.load(new FileInputStream(languageFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load definitions file: " + languageFile);
            }
            if (Config.isGreenfoot()) {
                File greenfootLabels = new File(bluejLibDir, language + File.separator + "greenfoot/greenfoot-labels");
                try {
                    labels.load(new FileInputStream(greenfootLabels));
                }
                catch (Exception e) {
                    Debug.reportError("Unable to load greenfoot labels file: " + greenfootLabels);
                }
                String frameLabels = language + File.separator + "frame-labels";
                File frameLabelFile = new File(bluejLibDir, frameLabels);
                try {
                    labels.load(new FileInputStream(frameLabelFile));
                }
                catch (Exception e) {
                    Debug.reportError("Unable to load frame labels file: " + frameLabelFile);
                }
            }
        }
        return labels;
    }

    private static void loadProperties(String filename, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.load(new FileInputStream(propsFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void saveProperties(String filename, String comment, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.store(new FileOutputStream(propsFile), Config.getString(comment));
        }
        catch (IOException e) {
            Debug.reportError("could not save properties file " + propsFile);
        }
    }

    public static Properties getMoeHelp() {
        return Config.loadDefs(language + File.separator + "moe.help", System.getProperties());
    }

    public static String getString(String strname) {
        return Config.getString(strname, strname);
    }

    public static String getString(String strname, String def) {
        int index;
        if (langVarProps == null) {
            langVarProps = new Properties();
            langVarProps.put("APPNAME", Config.getApplicationName());
        }
        String str = langProps.getProperty(strname, def);
        while ((index = str.indexOf(95)) != -1) {
            str = str.substring(0, index) + str.substring(index + 1);
        }
        index = str.indexOf(64);
        if (index != -1) {
            str = str.substring(0, index);
        }
        str = PropParser.parsePropString(str, langVarProps);
        return str;
    }

    public static int getMnemonicKey(String strname) {
        String str = langProps.getProperty(strname, strname);
        int index = str.indexOf(95);
        int mnemonic = index == -1 || index + 1 >= str.length() ? 0 : str.codePointAt(index + 1);
        return mnemonic;
    }

    public static boolean hasAcceleratorKey(String strname) {
        return langProps.getProperty(strname, strname).indexOf(64) != -1;
    }

    public static KeyStroke getAcceleratorKey(String strname) {
        String keyString;
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String str = langProps.getProperty(strname, strname);
        int index = str.indexOf(64);
        if (str.charAt(++index) == '^') {
            ++index;
            modifiers |= 1;
        }
        if ((keyString = str.substring(index).toUpperCase()).length() == 1) {
            return KeyStroke.getKeyStroke(keyString.codePointAt(0), modifiers);
        }
        KeyStroke k1 = KeyStroke.getKeyStroke(keyString);
        return KeyStroke.getKeyStroke(k1.getKeyCode(), modifiers);
    }

    public static String getSystemPropString(String propName) {
        String sysID = osname != null && osname.startsWith("Windows 9") ? "win9x" : (osname != null && osname.equals("Windows Me") ? "win9x" : (osname != null && osname.startsWith("Windows") ? "win" : (osname != null && osname.startsWith("Linux") ? "linux" : (osname != null && osname.startsWith("SunOS") ? "solaris" : (osname != null && osname.startsWith("Mac") ? "macos" : "")))));
        String value = commandProps.getProperty(sysID + propName);
        if (value == null) {
            value = commandProps.getProperty(propName);
        }
        return value;
    }

    public static String getPropString(String strname) {
        String rval = Config.getPropString(strname, null);
        if (rval == null) {
            rval = strname;
        }
        return rval;
    }

    public static String getPropString(String strname, String def) {
        return Config.getPropString(strname, def, commandProps);
    }

    public static String getPropString(String strname, String def, Properties props) {
        String propVal = props.getProperty(strname, def);
        if (propVal == null) {
            propVal = def;
        }
        if (propVal != null) {
            return PropParser.parsePropString(propVal, props);
        }
        return null;
    }

    public static String getDefaultPropString(String strname, String def) {
        return systemProps.getProperty(strname, def);
    }

    public static int getPropInteger(String intname, int def) {
        int value;
        try {
            value = Integer.parseInt(Config.getPropString(intname, String.valueOf(def)));
        }
        catch (NumberFormatException nfe) {
            return def;
        }
        return value;
    }

    public static boolean getPropBoolean(String propname) {
        return Config.parseBoolean(Config.getPropString(propname, null));
    }

    public static boolean getPropBoolean(String propname, boolean def) {
        String propval = Config.getPropString(propname);
        if (propval == null) {
            return def;
        }
        return Config.parseBoolean(propval);
    }

    private static boolean parseBoolean(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    public static String removeProperty(String propertyName) {
        return (String)userProps.remove(propertyName);
    }

    private static File getImageFile(String propname) {
        String filename = Config.getPropString(propname, null);
        if (filename != null) {
            return new File(bluejLibDir, "images" + File.separator + filename);
        }
        return null;
    }

    @OnThread(value=Tag.Swing)
    public static ImageIcon getImageAsIcon(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return new ImageIcon(u);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @OnThread(value=Tag.FX)
    public static javafx.scene.image.Image getImageAsFXImage(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return new javafx.scene.image.Image(u.toString());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @OnThread(value=Tag.Swing)
    public static ImageIcon getFixedImageAsIcon(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Cannot load null image");
        }
        File image = new File(bluejLibDir, "images" + File.separator + filename);
        try {
            return new ImageIcon(image.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @OnThread(value=Tag.FX)
    public static javafx.scene.image.Image getFixedImageAsFXImage(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Cannot load null image");
        }
        File image = new File(bluejLibDir, "images" + File.separator + filename);
        try {
            return new javafx.scene.image.Image(image.toURI().toURL().toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return Toolkit.getDefaultToolkit().createImage(u);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static String getJDKExecutablePath(String propName, String executableName) {
        String p;
        if (executableName == null) {
            throw new IllegalArgumentException("must provide an executable name");
        }
        String string = p = propName == null ? null : Config.getSystemPropString(propName);
        if (p == null) {
            String jdkPathName = System.getProperty("java.home");
            if (jdkPathName != null) {
                File jdkPath = new File(jdkPathName);
                File binPath = new File(jdkPath, "bin");
                File potentialExe = new File(binPath, executableName);
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                potentialExe = new File(binPath, executableName + ".exe");
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                if ((jdkPath = jdkPath.getParentFile()) != null) {
                    binPath = new File(jdkPath, "bin");
                    potentialExe = new File(binPath, executableName);
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                    potentialExe = new File(binPath, executableName + ".exe");
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                }
            }
            return executableName;
        }
        return p;
    }

    public static File getTemplateDir() {
        return Config.getLanguageFile("templates");
    }

    public static File getTemplateFile(String base) {
        return new File(Config.getTemplateDir(), base + ".tmpl");
    }

    public static File getClassTemplateDir() {
        String path = commandProps.getProperty("bluej.templatePath", "");
        if (path.length() == 0) {
            return Config.getLanguageFile("templates/newclass");
        }
        return new File(path);
    }

    public static File getClassTemplateFile(String base) {
        return new File(Config.getClassTemplateDir(), base + ".tmpl");
    }

    public static File getLanguageFile(String base) {
        return new File(bluejLibDir, language + File.separator + base);
    }

    public static File getDefaultLanguageFile(String base) {
        return new File(bluejLibDir, DEFAULT_LANGUAGE + File.separator + base);
    }

    public static File getUserConfigFile(String base) {
        return new File(userPrefDir, base);
    }

    public static File getUserConfigDir() {
        return userPrefDir;
    }

    public static Color getItemColour(String itemname) {
        try {
            String rgbStr = Config.getPropString(itemname, "255,0,255");
            String[] rgbVal = Utility.split(rgbStr, ",");
            if (rgbVal.length >= 3) {
                int r = Integer.parseInt(rgbVal[0].trim());
                int g = Integer.parseInt(rgbVal[1].trim());
                int b = Integer.parseInt(rgbVal[2].trim());
                return new Color(r, g, b);
            }
            Debug.reportError("Error reading colour [" + itemname + "]");
        }
        catch (Exception e) {
            Debug.reportError("Could not get colour for " + itemname);
        }
        return null;
    }

    public static Color getOptionalItemColour(String itemname) {
        try {
            String rgbStr = Config.getPropString(itemname, null);
            if (rgbStr == null) {
                return null;
            }
            String[] rgbVal = Utility.split(rgbStr, ",");
            if (rgbVal.length >= 3) {
                int r = Integer.parseInt(rgbVal[0].trim());
                int g = Integer.parseInt(rgbVal[1].trim());
                int b = Integer.parseInt(rgbVal[2].trim());
                return new Color(r, g, b);
            }
            Debug.reportError("Error reading colour [" + itemname + "]");
        }
        catch (Exception e) {
            Debug.reportError("Could not get colour for " + itemname);
        }
        return null;
    }

    public static Color getSelectionColour() {
        if (selectionColour == null) {
            selectionColour = Config.getItemColour("colour.selection");
        }
        return selectionColour;
    }

    public static Color getSelectionColour2() {
        if (selectionColour2 == null) {
            selectionColour2 = Config.getItemColour("colour.selection2");
        }
        return selectionColour2;
    }

    public static Color getHighlightColour() {
        if (highlightColour == null) {
            highlightColour = Config.getItemColour("colour.highlight");
        }
        return highlightColour;
    }

    public static Color getHighlightColour2() {
        if (highlightColour2 == null) {
            highlightColour2 = Config.getItemColour("colour.highlight2");
        }
        return highlightColour2;
    }

    public static Font getFont(String propertyName, String defaultFontName, int size) {
        int style;
        String fontName = Config.getPropString(propertyName, defaultFontName);
        if (fontName.endsWith("-bold")) {
            style = 1;
            fontName = fontName.substring(0, fontName.length() - 5);
        } else {
            style = 0;
        }
        return new Font(fontName, style, size);
    }

    public static void putLocation(String itemPrefix, Point p) {
        Config.putPropInteger(itemPrefix + ".x", p.x);
        Config.putPropInteger(itemPrefix + ".y", p.y);
    }

    public static Point getLocation(String itemPrefix) {
        try {
            int x = Config.getPropInteger(itemPrefix + ".x", 16);
            int y = Config.getPropInteger(itemPrefix + ".y", 16);
            if (x > Config.screenBounds.width - 16) {
                x = Config.screenBounds.width - 16;
            }
            if (y > Config.screenBounds.height - 16) {
                y = Config.screenBounds.height - 16;
            }
            return new Point(x, y);
        }
        catch (Exception e) {
            Debug.reportError("Could not get screen location for " + itemPrefix);
            return new Point(16, 16);
        }
    }

    public static void putPropInteger(String intname, int value) {
        String defVal = systemProps.getProperty(intname);
        if (defVal != null) {
            try {
                if (value == Integer.valueOf(defVal)) {
                    userProps.remove(intname);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        userProps.setProperty(intname, Integer.toString(value));
    }

    public static void putPropString(String strname, String value) {
        String defVal = systemProps.getProperty(strname);
        if (!(value == null || defVal != null && defVal.equals(value))) {
            userProps.setProperty(strname, value);
        } else {
            userProps.remove(strname);
        }
    }

    public static void putPropBoolean(String propname, boolean value) {
        String sysval = systemProps.getProperty(propname);
        if (Boolean.valueOf(sysval) == value) {
            userProps.remove(propname);
        } else {
            userProps.setProperty(propname, String.valueOf(value));
        }
    }

    public static File getBlueJLibDir() {
        return bluejLibDir;
    }

    public static File getGreenfootLibDir() {
        return greenfootLibDir;
    }

    public static String getBlueJIconPath() {
        return bluejLibDir.getPath() + "/images";
    }

    private static void setVMLocale() {
        String lang = Config.getPropString("vm.language", null);
        String region = Config.getPropString("vm.country", null);
        if ((lang == null || "".equals(lang)) && (region == null || "".equals(region))) {
            return;
        }
        if (lang == null || lang.equals("")) {
            lang = System.getProperty("user.language");
        }
        if (region == null || region.equals("")) {
            region = System.getProperty("user.country");
        }
        debugVMArgs.add("-Duser.language=" + lang);
        debugVMArgs.add("-Duser.country=" + region);
        Locale loc = new Locale(lang, region);
        Locale.setDefault(loc);
    }

    private static void setLookAndFeel(String laf) {
        try {
            if (laf.equals("default")) {
                return;
            }
            if (laf.equals("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                return;
            }
            if (laf.equals("crossplatform")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                usingMacOSScreenMenubar = false;
                return;
            }
            if (!laf.equals("bluejdefault")) {
                UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lafi.length; ++i) {
                    if (!lafi[i].getName().equals(laf)) continue;
                    UIManager.setLookAndFeel(lafi[i].getClassName());
                    return;
                }
                UIManager.setLookAndFeel(laf);
                return;
            }
            if (Config.isWinOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (Config.isLinux() || Config.isSolaris()) {
                UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
                UIManager.LookAndFeelInfo nimbus = null;
                for (UIManager.LookAndFeelInfo lafInstance : lafi) {
                    if (!lafInstance.getName().equals("Nimbus")) continue;
                    nimbus = lafInstance;
                    break;
                }
                if (nimbus != null) {
                    UIManager.setLookAndFeel(nimbus.getClassName());
                } else {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            }
        }
        catch (ClassNotFoundException e) {
            Debug.log("Could not find look-and-feel class: " + e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            Debug.log("Unsupported look-and-feel: " + e.getMessage());
        }
    }

    private static void initDebugVMArgs() {
        String args = Config.getPropString("bluej.vm.args");
        if (args != null && !args.equals("bluej.vm.args")) {
            List<String> splitArgs = Utility.dequoteCommandLine(args);
            debugVMArgs.addAll(splitArgs);
        }
    }

    public static List<String> getDebugVMArgs() {
        return debugVMArgs;
    }

    public static final boolean isGreenfoot() {
        return isGreenfoot;
    }

    public static boolean isZipFile(File file) {
        try {
            if (file.isDirectory()) {
                return false;
            }
            if (!file.canRead()) {
                throw new IOException();
            }
            if (file.length() < 4L) {
                return false;
            }
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int magicNumber = in.readInt();
            in.close();
            return magicNumber == 1347093252;
        }
        catch (IOException exc) {
            Debug.reportError("Could not read file: " + file.getAbsolutePath(), exc);
            return false;
        }
    }

    @OnThread(value=Tag.FX)
    public static void addEditorStylesheets(Scene scene) {
        String[] stylesheetStems;
        for (String stem : stylesheetStems = new String[]{"frame-style", "editor-catalogue", "editor-error-bar", "editor-error-fix", "editor-expression", "editor-help", "editor-menu", "editor-selection", "editor-slot-choice", "editor-suggestions", "editor-tabs"}) {
            try {
                scene.getStylesheets().add((Object)new File(bluejLibDir + "/stylesheets", stem + ".css").toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                Debug.reportError(e);
            }
        }
    }

    @OnThread(value=Tag.Swing)
    public static Border getFocusBorder() {
        if (focusBorder == null) {
            focusBorder = new CompoundBorder(new LineBorder(Color.BLACK), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(195, 195, 195), new Color(124, 124, 124)));
        }
        return focusBorder;
    }

    @OnThread(value=Tag.Swing)
    public static Border getNormalBorder() {
        if (normalBorder == null) {
            normalBorder = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(124, 124, 124), new Color(195, 195, 195)));
        }
        return normalBorder;
    }

    public static boolean isRetinaDisplay() {
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        if (obj instanceof Float) {
            Float f = (Float)obj;
            int scale = f.intValue();
            return scale == 2;
        }
        return false;
    }

    public static void loadFXFonts() {
        if (!fontOptions.isEmpty()) {
            return;
        }
        for (File file : new File(bluejLibDir + "/fonts").listFiles()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                javafx.scene.text.Font font = javafx.scene.text.Font.loadFont((InputStream)fis, (double)10.0);
                fis.close();
                if (font == null) {
                    Debug.reportError("Unknown problem loading TTF JavaFX font: " + file.getAbsolutePath());
                }
                if (font == null || fontOptions.contains(font.getFamily())) continue;
                fontOptions.add(font.getFamily());
                Collections.sort(fontOptions);
            }
            catch (IOException e) {
                Debug.reportError("Error loading font: " + file.getAbsolutePath(), e);
            }
        }
    }

    static {
        compilertype = "javac";
        debugLogName = bluejDebugLogName;
        fontOptions = new ArrayList<String>();
        isRaspberryPi = null;
        initialised = false;
        isGreenfoot = false;
        debugVMArgs = new ArrayList<String>();
        isDebugVm = true;
    }
}

