/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers.event;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import java.io.File;
import java.rmi.RemoteException;
import rmiextension.wrappers.event.RCompileEventImpl;
import rmiextension.wrappers.event.RCompileListener;

public class RCompileListenerWrapper
implements CompileListener {
    private RCompileListener remoteListener;
    private BProject project;

    public RCompileListenerWrapper(RCompileListener remoteListener, BProject project) {
        this.remoteListener = remoteListener;
        this.project = project;
    }

    private boolean isInThisProject(File[] files) {
        if (files.length <= 0) {
            return true;
        }
        File file = files[0];
        try {
            BPackage[] packages = this.project.getPackages();
            for (int i = 0; i < packages.length; ++i) {
                BPackage pkg = packages[i];
                BClass[] classes = pkg.getClasses();
                for (int j = 0; j < classes.length; ++j) {
                    BClass cls = classes[j];
                    if (!cls.getJavaFile().equals(file)) continue;
                    return true;
                }
            }
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void compileStarted(CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            try {
                RCompileEventImpl rEvent = new RCompileEventImpl(event);
                this.remoteListener.compileStarted(rEvent);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void compileError(CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            try {
                RCompileEventImpl rEvent = new RCompileEventImpl(event);
                this.remoteListener.compileError(rEvent);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void compileWarning(CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            try {
                RCompileEventImpl rEvent = new RCompileEventImpl(event);
                this.remoteListener.compileWarning(rEvent);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void compileSucceeded(CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            try {
                RCompileEventImpl rEvent = new RCompileEventImpl(event);
                this.remoteListener.compileSucceeded(rEvent);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void compileFailed(CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            try {
                RCompileEventImpl rEvent = new RCompileEventImpl(event);
                this.remoteListener.compileFailed(rEvent);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }
}

