/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BClass;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import java.rmi.RemoteException;
import java.util.WeakHashMap;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RClassImpl;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RConstructorImpl;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RFieldImpl;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RObjectImpl;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RPackageImpl;
import rmiextension.wrappers.RProjectImpl;

public class WrapperPool {
    private static WrapperPool instance;
    private WeakHashMap pool = new WeakHashMap();

    private WrapperPool() {
    }

    public static WrapperPool instance() {
        if (instance == null) {
            instance = new WrapperPool();
        }
        return instance;
    }

    public RProjectImpl getWrapper(BProject wrapped) throws RemoteException {
        RProjectImpl wrapper = (RProjectImpl)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RProjectImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public RPackage getWrapper(BPackage wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RPackage wrapper = (RPackage)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RPackageImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public RClass getWrapper(BClass wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RClass wrapper = (RClass)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RClassImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public RConstructor getWrapper(BConstructor wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RConstructor wrapper = (RConstructor)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RConstructorImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public RObject getWrapper(BObject wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RObject wrapper = (RObject)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RObjectImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public RField getWrapper(BField wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RField wrapper = (RField)this.pool.get(wrapped);
        if (wrapper == null) {
            wrapper = new RFieldImpl(wrapped);
            this.pool.put(wrapped, wrapper);
        }
        return wrapper;
    }
}

