/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.PackageAlreadyExistsException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.utility.Debug;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.WrapperPool;
import rmiextension.wrappers.event.RProjectListener;

public class RProjectImpl
extends UnicastRemoteObject
implements RProject {
    private BProject bProject;
    private List listeners = new ArrayList();

    public RProjectImpl(BProject bProject) throws RemoteException {
        this.bProject = bProject;
    }

    public void close() {
        this.notifyClosing();
        try {
            this.bProject.close();
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    public void notifyClosing() {
        ArrayList listeners = new ArrayList(this.listeners);
        for (RProjectListener listener : listeners) {
            try {
                listener.projectClosing();
            }
            catch (RemoteException re) {
                Debug.reportError((String)"Error when scenario closing: ", (Exception)re);
            }
        }
    }

    public File getDir() throws ProjectNotOpenException {
        return this.bProject.getDir();
    }

    public String getName() throws ProjectNotOpenException {
        return this.bProject.getName();
    }

    public RPackage getPackage(String name) throws ProjectNotOpenException, RemoteException {
        BPackage bPackage = this.bProject.getPackage(name);
        RPackage wrapper = null;
        wrapper = WrapperPool.instance().getWrapper(bPackage);
        return wrapper;
    }

    public RPackage newPackage(String fullyQualifiedName) throws ProjectNotOpenException, PackageAlreadyExistsException, RemoteException {
        BPackage bPackage = this.bProject.newPackage(fullyQualifiedName);
        RPackage wrapper = null;
        wrapper = WrapperPool.instance().getWrapper(bPackage);
        return wrapper;
    }

    public RPackage[] getPackages() throws ProjectNotOpenException, RemoteException {
        BPackage[] packages = this.bProject.getPackages();
        int length = packages.length;
        RPackage[] wrapper = new RPackage[length];
        for (int i = 0; i < length; ++i) {
            wrapper[i] = WrapperPool.instance().getWrapper(packages[i]);
        }
        return wrapper;
    }

    public void save() throws ProjectNotOpenException {
        this.bProject.save();
    }

    public void openReadmeEditor() throws ProjectNotOpenException {
        Project thisProject = Project.getProject((File)this.bProject.getDir());
        Package defaultPackage = thisProject.getPackage("");
        ReadmeTarget readmeTarget = defaultPackage.getReadmeTarget();
        readmeTarget.open();
    }

    public void addListener(RProjectListener listener) throws RemoteException {
        this.listeners.add(listener);
    }

    public void removeListener(RProjectListener listener) throws RemoteException {
        this.listeners.remove(listener);
    }
}

