/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import rmiextension.wrappers.InvocationResultWatcher;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.WrapperPool;

public class RPackageImpl
extends UnicastRemoteObject
implements RPackage {
    BPackage bPackage;

    public RPackageImpl(BPackage bPackage) throws RemoteException {
        this.bPackage = bPackage;
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.bPackage.compile(waitCompileEnd);
    }

    public void compileAll(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.bPackage.compileAll(waitCompileEnd);
    }

    public RClass getRClass(String name) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return WrapperPool.instance().getWrapper(this.bPackage.getBClass(name));
    }

    public RClass[] getRClasses() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BClass[] bClasses = this.bPackage.getClasses();
        int length = bClasses.length;
        RClass[] rClasses = new RClass[length];
        for (int i = 0; i < length; ++i) {
            rClasses[i] = WrapperPool.instance().getWrapper(bClasses[i]);
        }
        return rClasses;
    }

    public String getName() throws ProjectNotOpenException, PackageNotFoundException {
        return this.bPackage.getName();
    }

    public RObject getObject(String instanceName) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BObject wrapped = this.bPackage.getObject(instanceName);
        RObject wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    public BObject[] getObjects() throws ProjectNotOpenException, PackageNotFoundException {
        return this.bPackage.getObjects();
    }

    public RProject getProject() throws RemoteException, ProjectNotOpenException {
        return WrapperPool.instance().getWrapper(this.bPackage.getProject());
    }

    public void reload() throws ProjectNotOpenException, PackageNotFoundException {
        this.bPackage.reload();
    }

    public RClass getSelectedClass() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.getRClasses()[0];
    }

    public File getDir() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.bPackage.getDir();
    }

    public RClass newClass(String className) throws RemoteException, ProjectNotOpenException, PackageNotFoundException, MissingJavaFileException {
        BClass wrapped = this.bPackage.newClass(className);
        RClass wrapper = WrapperPool.instance().getWrapper(wrapped);
        this.bPackage.reload();
        return wrapper;
    }

    public String invokeMethod(String className, String methodName, String[] argTypes, String[] args) {
        Package pkg = this.getPackage();
        Class cl = pkg.loadClass(className);
        Object theMethod = null;
        for (View mClassView = View.getView((Class)cl); mClassView != null; mClassView = mClassView.getSuper()) {
            MethodView[] methods = mClassView.getDeclaredMethods();
            block1: for (int i = 0; i < methods.length; ++i) {
                if ((methods[i].getModifiers() & 2) != 0 || (methods[i].getModifiers() & 8) == 0 || !methods[i].getName().equals(methodName) || methods[i].getParameterCount() != argTypes.length) continue;
                Class[] params = methods[i].getParameters();
                for (int j = 0; j < params.length; ++j) {
                    if (!params[j].getName().equals(argTypes[j])) continue block1;
                }
                return RPackageImpl.invokeCallable(PkgMgrFrame.findFrame((Package)pkg), (CallableView)methods[i], null, args);
            }
        }
        throw new IllegalArgumentException("method not found");
    }

    public String invokeConstructor(String className, String[] argTypes, String[] args) {
        Package pkg = this.getPackage();
        Class cl = pkg.loadClass(className);
        View mClassView = View.getView((Class)cl);
        ConstructorView[] constructors = mClassView.getConstructors();
        block0: for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterCount() != argTypes.length) continue;
            Class[] params = constructors[i].getParameters();
            for (int j = 0; j < params.length; ++j) {
                if (!params[j].getName().equals(argTypes[j])) continue block0;
            }
            return RPackageImpl.invokeCallable(PkgMgrFrame.findFrame((Package)pkg), (CallableView)constructors[i], null, args);
        }
        throw new IllegalArgumentException("constructor not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String invokeCallable(PkgMgrFrame pmf, CallableView cv, ObjectWrapper ow, String[] argVals) {
        InvocationResultWatcher watcher = new InvocationResultWatcher();
        Invoker invoker = ow == null ? new Invoker(pmf, cv, (ResultWatcher)watcher) : new Invoker(pmf, (MethodView)cv, ow, (ResultWatcher)watcher);
        InvocationResultWatcher invocationResultWatcher = watcher;
        synchronized (invocationResultWatcher) {
            invoker.invokeDirect(argVals);
            try {
                watcher.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (watcher.errorMsg != null) {
            return "!" + watcher.errorMsg;
        }
        if (watcher.resultObj == null) {
            return null;
        }
        ObjectWrapper newOw = ObjectWrapper.getWrapper((PkgMgrFrame)pmf, (ObjectBench)pmf.getObjectBench(), (DebuggerObject)watcher.resultObj, (GenTypeClass)watcher.resultObj.getGenType(), (String)"result");
        pmf.getObjectBench().addObject(newOw);
        Package pkg = pmf.getPackage();
        pkg.getDebugger().addObject(pkg.getId(), newOw.getName(), newOw.getObject());
        return newOw.getName();
    }

    private Package getPackage() {
        try {
            Class<?> bPackageClass = this.bPackage.getClass();
            Field packageId = bPackageClass.getDeclaredField("packageId");
            packageId.setAccessible(true);
            Object identifier = packageId.get(this.bPackage);
            Class<?> identifierClass = identifier.getClass();
            Method getBluejPackage = identifierClass.getDeclaredMethod("getBluejPackage", new Class[0]);
            getBluejPackage.setAccessible(true);
            Package pkg = (Package)getBluejPackage.invoke(identifier, (Object[])null);
            return pkg;
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return null;
    }

    public void close() throws RemoteException {
        try {
            PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)this.bPackage.getFrame();
            pkgMgrFrame.doClose(false, true);
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
    }
}

