/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BClass;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BMethod;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.editor.Editor;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.swing.SwingUtilities;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.WrapperPool;

public class RClassImpl
extends UnicastRemoteObject
implements RClass {
    BClass bClass;

    RClassImpl(BClass bClass) throws RemoteException {
        this.bClass = bClass;
        if (bClass == null) {
            throw new NullPointerException("Argument can't be null");
        }
    }

    public RClassImpl() throws RemoteException {
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.bClass.compile(waitCompileEnd);
    }

    public void edit() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        final Editor editor = this.bClass.getEditor();
        if (editor != null) {
            Thread t = new Thread(){

                public void run() {
                    editor.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(t);
        }
    }

    public RConstructor getConstructor(Class[] signature) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor bConstructor = this.bClass.getConstructor(signature);
        RConstructor rConstructor = WrapperPool.instance().getWrapper(bConstructor);
        return rConstructor;
    }

    public RConstructor[] getConstructors() throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor[] bConstructors = this.bClass.getConstructors();
        int length = bConstructors.length;
        RConstructor[] rConstructors = new RConstructor[length];
        for (int i = 0; i < length; ++i) {
            rConstructors[i] = WrapperPool.instance().getWrapper(bConstructors[i]);
        }
        return rConstructors;
    }

    public BMethod getDeclaredMethod(String methodName, Class[] params) throws ProjectNotOpenException, ClassNotFoundException {
        return null;
    }

    public BMethod[] getDeclaredMethods() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getDeclaredMethods();
    }

    public RField getField(String fieldName) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BField wrapped = this.bClass.getField(fieldName);
        RField wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    public BField[] getFields() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getFields();
    }

    public RPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BPackage wrapped = this.bClass.getPackage();
        RPackage wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    public RClass getSuperclass() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        BClass wrapped = this.bClass.getSuperclass();
        RClass wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    public boolean isCompiled() throws ProjectNotOpenException, PackageNotFoundException {
        return this.bClass.isCompiled();
    }

    public String getToString() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getName();
    }

    public String getQualifiedName() throws RemoteException, ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getName();
    }

    public File getJavaFile() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.bClass.getJavaFile();
    }

    public void remove() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        this.bClass.remove();
    }

    public void setReadOnly(boolean b) throws RemoteException, ProjectNotOpenException, PackageNotFoundException {
        this.bClass.getEditor().setReadOnly(b);
    }
}

