/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.event.ClassListener;
import bluej.extensions.event.CompileListener;
import bluej.extensions.event.InvocationListener;
import bluej.pkgmgr.PkgMgrFrame;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Map;
import rmiextension.ProjectManager;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.RProjectImpl;
import rmiextension.wrappers.WrapperPool;
import rmiextension.wrappers.event.RClassListener;
import rmiextension.wrappers.event.RClassListenerWrapper;
import rmiextension.wrappers.event.RCompileListener;
import rmiextension.wrappers.event.RCompileListenerWrapper;
import rmiextension.wrappers.event.RInvocationListener;
import rmiextension.wrappers.event.RInvocationListenerWrapper;

public class RBlueJImpl
extends UnicastRemoteObject
implements RBlueJ {
    BlueJ blueJ;
    Map listeners = new Hashtable();

    public RBlueJImpl(BlueJ blueJ) throws RemoteException {
        this.blueJ = blueJ;
    }

    public void addCompileListener(RCompileListener listener, File projectPath) {
        BProject[] projects = this.blueJ.getOpenProjects();
        BProject project = null;
        for (int i = 0; i < projects.length; ++i) {
            BProject prj = projects[i];
            try {
                if (!prj.getDir().equals(projectPath)) continue;
                project = prj;
                continue;
            }
            catch (ProjectNotOpenException e) {
                e.printStackTrace();
            }
        }
        RCompileListenerWrapper wrapper = new RCompileListenerWrapper(listener, project);
        this.listeners.put(listener, wrapper);
        this.blueJ.addCompileListener((CompileListener)wrapper);
    }

    public void addInvocationListener(RInvocationListener listener) {
        RInvocationListenerWrapper wrapper = new RInvocationListenerWrapper(listener);
        this.listeners.put(listener, wrapper);
        this.blueJ.addInvocationListener((InvocationListener)wrapper);
    }

    public void addClassListener(RClassListener listener) throws RemoteException {
        RClassListenerWrapper wrapper = new RClassListenerWrapper(listener);
        this.listeners.put(listener, wrapper);
        this.blueJ.addClassListener((ClassListener)wrapper);
    }

    public String getBlueJPropertyString(String property, String def) {
        return this.blueJ.getBlueJPropertyString(property, def);
    }

    public String getExtensionPropertyString(String property, String def) {
        return this.blueJ.getExtensionPropertyString(property, def);
    }

    public String getLabel(String key) {
        return this.blueJ.getLabel(key);
    }

    public RProject[] getOpenProjects() throws RemoteException {
        BProject[] bProjects = this.blueJ.getOpenProjects();
        int length = bProjects.length;
        RProject[] rProjects = new RProject[length];
        for (int i = 0; i < length; ++i) {
            rProjects[i] = WrapperPool.instance().getWrapper(bProjects[i]);
        }
        return rProjects;
    }

    public File getSystemLibDir() {
        File f = this.blueJ.getSystemLibDir();
        return f.getAbsoluteFile();
    }

    public RProject newProject(File directory) throws RemoteException {
        ProjectManager.instance().addNewProject(directory);
        BProject wrapped = this.blueJ.newProject(directory);
        RProjectImpl wrapper = WrapperPool.instance().getWrapper(wrapped);
        ProjectManager.instance().removeNewProject(directory);
        return wrapper;
    }

    public RProject openProject(String directory) throws RemoteException {
        return WrapperPool.instance().getWrapper(this.blueJ.openProject(new File(directory)));
    }

    public void removeCompileListener(RCompileListener listener) {
        RCompileListenerWrapper wrapper = (RCompileListenerWrapper)this.listeners.get(listener);
        this.listeners.remove(listener);
        this.blueJ.removeCompileListener((CompileListener)wrapper);
    }

    public void removeInvocationListener(RInvocationListener listener) {
        RInvocationListenerWrapper wrapper = (RInvocationListenerWrapper)this.listeners.get(listener);
        this.listeners.remove(listener);
        this.blueJ.removeInvocationListener((InvocationListener)wrapper);
    }

    public void removeClassListener(RClassListener listener) throws RemoteException {
        ClassListener wrapper = (ClassListener)this.listeners.remove(listener);
        this.blueJ.removeClassListener(wrapper);
    }

    public void setExtensionPropertyString(String property, String value) {
        this.blueJ.setExtensionPropertyString(property, value);
    }

    public void exit() throws RemoteException {
        BProject[] bProjects = this.blueJ.getOpenProjects();
        int length = bProjects.length;
        for (int i = 0; i < length; ++i) {
            RProjectImpl rpImpl = WrapperPool.instance().getWrapper(bProjects[i]);
            rpImpl.notifyClosing();
        }
        PkgMgrFrame[] frames = PkgMgrFrame.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            frames[i].doClose(false, true);
        }
    }
}

