/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.Config;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ApplicationListener;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import greenfoot.core.GreenfootLauncherBlueJVM;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import rmiextension.BlueJRMIServer;
import rmiextension.ProjectManager;

public class RMIExtension
extends Extension
implements ApplicationListener {
    private BlueJ theBlueJ;

    public void startup(BlueJ bluej) {
        this.theBlueJ = bluej;
        ProjectManager.init(bluej);
        try {
            new BlueJRMIServer(this.theBlueJ);
        }
        catch (IOException e) {
            Debug.reportError((String)"Could not launch RMI server", (Exception)e);
            System.exit(1);
        }
        this.theBlueJ.addApplicationListener((ApplicationListener)this);
    }

    public void maybeOpenProject(File projectPath) {
        boolean openOrphans = "true".equals(Config.getPropString((String)"bluej.autoOpenLastProject"));
        if (!(openOrphans && PkgMgrFrame.hadOrphanPackages() || this.theBlueJ.getOpenProjects().length != 0)) {
            this.openProject(projectPath);
        }
    }

    public void openProject(File projectPath) {
        BProject project = this.theBlueJ.openProject(projectPath);
        if (project == null) {
            Debug.reportError((String)("Could not open scenario: " + projectPath));
        }
    }

    public void newProject(File projectPath) {
        ProjectManager.instance().addNewProject(projectPath);
        BProject project = this.theBlueJ.newProject(projectPath);
        if (project == null) {
            Debug.reportError((String)("Could not open scenario: " + projectPath));
        }
        ProjectManager.instance().removeNewProject(projectPath);
    }

    public boolean isCompatible() {
        return true;
    }

    public String getVersion() {
        return "2003.03";
    }

    public String getName() {
        return "greenfoot Extension";
    }

    public String getDescription() {
        return "greenfoot extension";
    }

    public URL getURL() {
        try {
            return new URL("http://www.greenfoot.org");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void blueJReady(ApplicationEvent event) {
        GreenfootLauncherBlueJVM.getInstance().launch(this);
    }
}

