/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.extensions.BPackage;
import bluej.extensions.BlueJ;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import greenfoot.core.GreenfootLauncherDebugVM;
import greenfoot.core.GreenfootMain;
import greenfoot.core.ProjectProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import rmiextension.BlueJRMIServer;
import rmiextension.ObjectBench;
import rmiextension.Project;

public class ProjectManager
implements PackageListener {
    private static ProjectManager instance;
    private List<BPackage> openedPackages = new ArrayList<BPackage>();
    private List<File> projectsInCreation = new ArrayList<File>();
    private String launchClass = GreenfootLauncherDebugVM.class.getName();
    private static final String launcherName = "greenfootLauncher";
    private static BlueJ bluej;

    private ProjectManager() {
    }

    public static ProjectManager instance() {
        if (bluej == null) {
            throw new IllegalStateException("Projectmanager has not been initialised.");
        }
        if (instance == null) {
            instance = new ProjectManager();
        }
        return instance;
    }

    public static void init(BlueJ bluej) {
        ProjectManager.bluej = bluej;
    }

    private void launchProject(Project project) {
        if (!ProjectManager.instance().isProjectOpen(project)) {
            File projectDir = new File(project.getDir());
            int versionOK = this.checkVersion(projectDir);
            if (versionOK != 2) {
                try {
                    if (versionOK == 1) {
                        project.getPackage().getProject().getPackage("").reload();
                    }
                    ObjectBench.createObject(project, this.launchClass, launcherName, new String[]{project.getDir(), project.getName(), BlueJRMIServer.getBlueJService()});
                }
                catch (Exception e) {
                    Debug.reportError((String)"Could not create greenfoot launcher.", (Exception)e);
                    e.printStackTrace();
                    System.exit(1);
                }
            } else if (bluej.getOpenProjects().length == 1) {
                ((PkgMgrFrame)bluej.getCurrentFrame()).doClose(true, true);
                File startupProject = new File(bluej.getSystemLibDir(), "startupProject");
                bluej.openProject(startupProject);
            }
        }
    }

    private int checkVersion(File projectDir) {
        if (this.isNewProject(projectDir)) {
            ProjectProperties newProperties = new ProjectProperties(projectDir);
            newProperties.setApiVersion(GreenfootMain.getAPIVersion().toString());
            newProperties.save();
        }
        return GreenfootMain.updateApi(projectDir, null);
    }

    private boolean isNewProject(File projectDir) {
        return this.projectsInCreation.contains(projectDir);
    }

    public void addNewProject(File projectDir) {
        this.projectsInCreation.add(projectDir);
    }

    public void removeNewProject(File projectDir) {
        this.projectsInCreation.remove(projectDir);
    }

    private boolean isProjectOpen(Project prj) {
        boolean projectIsOpen = false;
        File prjFile = null;
        try {
            prjFile = prj.getPackage().getProject().getDir();
        }
        catch (ProjectNotOpenException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < this.openedPackages.size(); ++i) {
            BPackage openPkg = this.openedPackages.get(i);
            File openPrj = null;
            try {
                openPrj = openPkg.getProject().getDir();
            }
            catch (ProjectNotOpenException e2) {
                // empty catch block
            }
            if (openPrj == null || prjFile == null || !openPrj.equals(prjFile)) continue;
            projectIsOpen = true;
        }
        return projectIsOpen;
    }

    public void packageOpened(PackageEvent event) {
        BPackage pkg = event.getPackage();
        Project project = new Project(pkg);
        if (!this.isProjectOpen(project)) {
            this.launchProject(project);
        }
        this.openedPackages.add(event.getPackage());
    }

    public void packageClosing(PackageEvent event) {
        this.openedPackages.remove(event.getPackage());
    }
}

