/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.extensions.BlueJ;
import bluej.extensions.event.PackageListener;
import bluej.utility.Debug;
import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.Permission;
import rmiextension.ProjectManager;
import rmiextension.wrappers.RBlueJImpl;

public class BlueJRMIServer {
    private static final String HOST = "127.0.0.1";
    private static final String BLUEJ_SERVICE = "BlueJService";
    private static int port;
    private int registryStartAttempts = 0;
    private static final int MAX_REGISTRY_START_ATTEMPTS = 10;

    public static String getBlueJService() {
        if (port == 0) {
            throw new IllegalStateException("Registry not started.");
        }
        return "//127.0.0.1:" + port + "/" + BLUEJ_SERVICE;
    }

    public static void forceHostForServer() {
        System.setProperty("java.rmi.server.hostname", HOST);
    }

    public BlueJRMIServer(BlueJ blueJ) throws IOException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager(){

                public void checkPermission(Permission perm) {
                }

                public void checkPermission(Permission perm, Object context) {
                }
            });
        }
        this.startRegistry();
        blueJ.addPackageListener((PackageListener)ProjectManager.instance());
        RBlueJImpl rBlueJ = new RBlueJImpl(blueJ);
        Naming.rebind(BlueJRMIServer.getBlueJService(), rBlueJ);
    }

    private void startRegistry() throws IOException {
        BlueJRMIServer.forceHostForServer();
        boolean success = false;
        while (!success && this.registryStartAttempts < 10) {
            try {
                port = this.getFreePort();
            }
            catch (IOException e1) {
                Debug.reportError((String)("Could not obtain a free port number. Attempt number: " + this.registryStartAttempts));
                e1.printStackTrace();
                ++this.registryStartAttempts;
                continue;
            }
            try {
                LocateRegistry.createRegistry(port);
                success = true;
            }
            catch (RemoteException re) {
                Debug.reportError((String)("Could not start registry. Attempt number: " + this.registryStartAttempts));
                re.printStackTrace();
                ++this.registryStartAttempts;
            }
        }
        if (!success) {
            throw new IOException("Could not start the registry.");
        }
    }

    private int getFreePort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        int freePort = s.getLocalPort();
        s.close();
        return freePort;
    }
}

