/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.BlueJPropStringSource;
import bluej.extensions.ProjectNotOpenException;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import rmiextension.BlueJRMIServer;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;

public class BlueJRMIClient
implements BlueJPropStringSource {
    RBlueJ blueJ = null;
    private static BlueJRMIClient instance;
    private RPackage pkg;

    public BlueJRMIClient(String prjDir, String rmiServiceName) {
        BlueJRMIServer.forceHostForServer();
        instance = this;
        try {
            this.blueJ = (RBlueJ)Naming.lookup(rmiServiceName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (NotBoundException e) {
            e.printStackTrace();
        }
        if (this.blueJ != null) {
            try {
                RProject[] openProjects = this.blueJ.getOpenProjects();
                RProject prj = null;
                for (int i = 0; i < openProjects.length; ++i) {
                    prj = openProjects[i];
                    File passedDir = new File(prjDir);
                    if (prj.getDir().equals(passedDir)) break;
                }
                this.pkg = prj.getPackage("");
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (ProjectNotOpenException e) {
                e.printStackTrace();
            }
        }
    }

    public static BlueJRMIClient instance() {
        return instance;
    }

    public RBlueJ getBlueJ() {
        return this.blueJ;
    }

    public RPackage getPackage() {
        return this.pkg;
    }

    public String getBlueJPropertyString(String property, String def) {
        try {
            String val = this.blueJ.getExtensionPropertyString(property, null);
            if (val == null) {
                val = this.blueJ.getBlueJPropertyString(property, def);
            }
            return val;
        }
        catch (RemoteException re) {
            return def;
        }
    }

    public String getLabel(String key) {
        try {
            return this.blueJ.getLabel(key);
        }
        catch (RemoteException re) {
            return key;
        }
    }

    public void setUserProperty(String property, String val) {
        try {
            this.blueJ.setExtensionPropertyString(property, val);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

