/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import java.util.ArrayList;

public class Version {
    private int breakingNumber;
    private int nonBreakingNumber;
    private int internalNumber;
    private boolean badVersion = false;

    public Version(String versionString) {
        String candidate;
        String[] endSplit;
        if (versionString == null) {
            this.badVersion = true;
            return;
        }
        String[] split = versionString.split("\\.");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        String lastString = null;
        for (String s : split) {
            try {
                numbers.add(new Integer(Integer.parseInt(s)));
            }
            catch (NumberFormatException nfe) {
                lastString = s;
                break;
            }
        }
        if (numbers.size() < 3 && lastString != null && (endSplit = lastString.split("[^0-9]+")).length > 0 && lastString.startsWith(candidate = endSplit[0])) {
            numbers.add(new Integer(Integer.parseInt(candidate)));
        }
        if (numbers.size() == 3) {
            this.breakingNumber = (Integer)numbers.get(0);
            this.nonBreakingNumber = (Integer)numbers.get(1);
            this.internalNumber = (Integer)numbers.get(2);
        } else {
            this.badVersion = true;
        }
    }

    public boolean isOlderAndBreaking(Version other) {
        return this.breakingNumber < other.breakingNumber || this.badVersion || other.badVersion;
    }

    public boolean isNonBreaking(Version other) {
        return this.nonBreakingNumber != other.nonBreakingNumber || this.badVersion || other.badVersion;
    }

    public boolean isInternal(Version other) {
        return this.internalNumber != other.internalNumber || this.badVersion || other.badVersion;
    }

    public boolean isBad() {
        return this.badVersion;
    }

    public String toString() {
        return this.breakingNumber + "." + this.nonBreakingNumber + "." + this.internalNumber;
    }
}

