/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.utility.Utility;
import greenfoot.platforms.GreenfootUtilDelegate;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.ShadowRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenfootUtil {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static GreenfootUtilDelegate delegate;
    private static final Color urlColor;

    public static void initialise(GreenfootUtilDelegate newDelegate) {
        delegate = newDelegate;
    }

    public static String extractClassName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        String name = qualifiedName;
        if (index >= 0) {
            name = qualifiedName.substring(index + 1);
        }
        return name;
    }

    public static String extractPackageName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        String name = "";
        if (index >= 0) {
            name = qualifiedName.substring(0, index);
        }
        return name;
    }

    public static JComponent createSpacer(int axis, int width) {
        JPanel spacer = new JPanel();
        spacer.setMinimumSize(new Dimension(0, 0));
        Dimension size = new Dimension();
        size.width = 0;
        size.height = 0;
        if (axis == 0) {
            size.width = width;
        } else {
            size.height = width;
        }
        spacer.setPreferredSize(size);
        spacer.setMaximumSize(size);
        spacer.setBorder(null);
        return spacer;
    }

    public static JLabel createHelpLabel() {
        JLabel helpLabel = new JLabel();
        Font smallFont = helpLabel.getFont().deriveFont(2, 11.0f);
        helpLabel.setFont(smallFont);
        return helpLabel;
    }

    public static Image getScaledImage(Image inputImage, int w, int h) {
        ImageWaiter waiter = new ImageWaiter(inputImage);
        waiter.waitDimensions();
        int inputw = waiter.width;
        int inputh = waiter.height;
        if (w == inputw && h == inputh) {
            return inputImage;
        }
        BufferedImage rImage = GraphicsUtilities.createCompatibleTranslucentImage(w, h);
        Graphics2D graphics = rImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (inputw <= w && inputh <= h) {
            int xoffs = (w - inputw) / 2;
            int yoffs = (h - inputh) / 2;
            waiter.drawWait(graphics, xoffs, yoffs);
        } else {
            float xscale = (float)w / (float)inputw;
            float yscale = (float)h / (float)inputh;
            float scale = xscale < yscale ? xscale : yscale;
            int neww = (int)((float)inputw * scale);
            int newh = (int)((float)inputh * scale);
            if (neww > inputw) {
                neww = inputw;
            }
            if (newh > inputh) {
                newh = inputh;
            }
            if (neww < 1) {
                neww = 1;
            }
            if (newh < 1) {
                newh = 1;
            }
            if (neww < w && newh < h) {
                ++neww;
                ++newh;
            }
            int xoffs = (w - neww) / 2;
            int yoffs = (h - newh) / 2;
            waiter.drawWait(graphics, xoffs, yoffs, neww, newh);
        }
        return rImage;
    }

    public static void copyDir(File src, File dst) {
        if (!src.isDirectory()) {
            return;
        }
        if (!dst.exists()) {
            dst.mkdirs();
        }
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File newDst = new File(dst, file.getName());
            if (file.isDirectory()) {
                GreenfootUtil.copyDir(file, newDst);
                continue;
            }
            GreenfootUtil.copyFile(file, newDst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) {
        if (!src.isFile() || dst.isDirectory()) {
            return;
        }
        dst.getParentFile().mkdirs();
        if (dst.exists()) {
            dst.delete();
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buffer = new byte[8192];
            int read = 0;
            while (read != -1) {
                os.write(buffer, 0, read);
                read = is.read(buffer);
            }
            os.flush();
            is.close();
            os.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getScenarioFromFileBrowser(Component parent) {
        return delegate.getScenarioFromFileBrowser(parent);
    }

    public static String getNewProjectName(Component parent) {
        return delegate.getNewProjectName(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getURL(String filename, String dir) {
        int sepLoc;
        if (filename == null) {
            throw new NullPointerException("Filename must not be null.");
        }
        ClassLoader currentLoader = delegate.getCurrentClassLoader();
        URL url = null;
        boolean pathContainsDir = false;
        if (dir != null && (sepLoc = filename.lastIndexOf(System.getProperty("file.separator"))) > 0) {
            String pathOnly = filename.substring(0, sepLoc);
            pathContainsDir = pathOnly.endsWith(dir);
        }
        boolean pathContainsColon = filename.contains(":");
        boolean dirSearched = false;
        if (!pathContainsColon && !pathContainsDir) {
            url = currentLoader.getResource(dir + "/" + filename);
            dirSearched = true;
        }
        if (url == null) {
            url = currentLoader.getResource(filename);
        }
        if (url == null && !dirSearched) {
            url = currentLoader.getResource(dir + "/" + filename);
            dirSearched = true;
        }
        if (url == null) {
            File f = new File(filename);
            try {
                if (f.canRead()) {
                    url = f.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (AccessControlException ace) {
                // empty catch block
            }
        }
        if (url == null) {
            InputStream s = null;
            try {
                url = new URL(filename);
                s = url.openStream();
                s.close();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            catch (IOException e) {
                url = null;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("Could not find file: " + filename);
        }
        return url;
    }

    public static void createSkeleton(String className, String superClassName, File file, String templateFileName) throws IOException {
        delegate.createSkeleton(className, superClassName, file, templateFileName);
    }

    public static String getGreenfootLogoPath() {
        return delegate.getGreenfootLogoPath();
    }

    public static boolean canBeInstantiated(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        int modifiers = cls.getModifiers();
        return (0x600 & modifiers) == 0;
    }

    public static BufferedImage createDragShadow(BufferedImage image) {
        BufferedImage dragImage = ShadowRenderer.createDropShadow(image, 3, 0.3f, Color.BLACK);
        Graphics2D g2 = dragImage.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return dragImage;
    }

    public static JButton createButton(Action action) {
        JButton button = new JButton(action);
        button.setFocusable(false);
        return button;
    }

    private static Font deriveUnderlinedFont(Font f) {
        Map<TextAttribute, ?> attr = f.getAttributes();
        attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        Font underLineFont = f.deriveFont(attr);
        return underLineFont;
    }

    public static void makeLink(JLabel label, final String url) {
        label.setCursor(new Cursor(12));
        label.setForeground(urlColor);
        Font f = label.getFont();
        Font underLineFont = GreenfootUtil.deriveUnderlinedFont(f);
        label.setFont(underLineFont);
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Utility.openWebBrowser((String)url);
            }
        });
    }

    public static void makeGreenfootTitle(Frame frame) {
        String title = frame.getTitle();
        String newTitle = title.replaceAll("BlueJ", "Greenfoot");
        frame.setTitle(newTitle);
    }

    public static void makeGreenfootTitle(Dialog dialog) {
        String title = dialog.getTitle();
        String newTitle = title.replaceAll("BlueJ", "Greenfoot");
        dialog.setTitle(newTitle);
    }

    static {
        urlColor = new Color(0, 90, 200);
    }

    public static class ImageWaiter
    implements ImageObserver {
        public int width;
        public int height;
        public boolean done;
        public boolean gotDimensions;
        public Image src;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImageWaiter(Image src) {
            this.src = src;
            this.done = false;
            this.gotDimensions = false;
            ImageWaiter imageWaiter = this;
            synchronized (imageWaiter) {
                this.width = src.getWidth(this);
                this.height = src.getHeight(this);
                if (this.width != -1 && this.height != -1) {
                    this.gotDimensions = true;
                }
            }
        }

        public synchronized void waitDimensions() {
            try {
                while (!this.gotDimensions) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void drawWait(Graphics canvas, int x, int y) {
            this.done = canvas.drawImage(this.src, x, y, this);
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }

        public synchronized void drawWait(Graphics canvas, int x, int y, int w, int h) {
            this.done = canvas.drawImage(this.src, x, y, w, h, this);
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }

        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if (!this.gotDimensions) {
                if ((infoflags & 1) != 0) {
                    this.width = width;
                }
                if ((infoflags & 2) != 0) {
                    this.height = height;
                }
                if (this.width != -1 && this.height != -1) {
                    this.gotDimensions = true;
                    this.notify();
                    return false;
                }
                return true;
            }
            if ((infoflags & 0xF0) != 0) {
                this.done = true;
                this.notify();
                return false;
            }
            return true;
        }
    }
}

