/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlayer;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundStream
extends Sound {
    private URL url;
    private boolean stop;
    private boolean pause;
    private SoundPlayer player;
    private SourceDataLine line;
    private AudioInputStream stream;
    private AudioFormat format;
    private boolean hasPlayed = false;

    public SoundStream(URL url, SoundPlayer player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.url = url;
        this.stop = false;
        this.player = player;
        this.open();
    }

    private void open() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.stream = AudioSystem.getAudioInputStream(this.url);
        this.format = this.stream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println("Converting");
            this.format = this.getCompatibleFormat(this.format);
            this.stream = AudioSystem.getAudioInputStream(this.format, this.stream);
            info = new DataLine.Info(SourceDataLine.class, this.format);
        }
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open(this.format);
    }

    public synchronized void stop() {
        this.stop = true;
        this.notifyAll();
    }

    public synchronized void pause() {
        this.pause = true;
    }

    public synchronized void resume() {
        this.pause = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        if (this.hasPlayed) {
            throw new IllegalStateException("This sound has already been played.");
        }
        this.hasPlayed = true;
        try {
            int frameSize = this.format.getFrameSize();
            byte[] buffer = new byte[4096 * frameSize];
            int bytesInBuffer = 0;
            int bytesRead = this.stream.read(buffer, 0, buffer.length - bytesInBuffer);
            while (bytesRead != -1 && !this.stop) {
                this.line.start();
                int bytesToWrite = (bytesInBuffer += bytesRead) / frameSize * frameSize;
                this.line.write(buffer, 0, bytesToWrite);
                int remaining = bytesInBuffer - bytesToWrite;
                if (remaining > 0) {
                    System.arraycopy(buffer, bytesToWrite, buffer, 0, remaining);
                }
                bytesInBuffer = remaining;
                bytesRead = this.stream.read(buffer, bytesInBuffer, buffer.length - bytesInBuffer);
                SoundStream soundStream = this;
                synchronized (soundStream) {
                    while (this.pause) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            this.line.drain();
        }
        catch (IOException e1) {
            Debug.reportError((String)"Error when streaming sound.", (Exception)e1);
        }
        finally {
            if (this.line != null) {
                this.line.close();
            }
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
            }
            this.player.soundFinished(this);
        }
    }

    public String toString() {
        return this.url + " " + super.toString();
    }
}

