/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundCache;
import greenfoot.sound.SoundClip;
import greenfoot.sound.SoundStream;
import greenfoot.util.GreenfootUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundPlayer
implements SimulationListener {
    private List<Sound> playingSounds = new ArrayList<Sound>();
    private static SoundPlayer instance;
    private SoundCache soundCache = new SoundCache();
    private static final int maxClipSize = 500000;

    private SoundPlayer() {
    }

    public static synchronized SoundPlayer getInstance() {
        if (instance == null) {
            instance = new SoundPlayer();
        }
        return instance;
    }

    public synchronized void stop() {
        for (Sound sound : this.playingSounds) {
            sound.stop();
        }
        this.playingSounds.clear();
    }

    public synchronized void pause() {
        for (Sound sound : this.playingSounds) {
            sound.pause();
        }
    }

    public synchronized void resume() {
        for (Sound sound : this.playingSounds) {
            sound.resume();
        }
    }

    public void play(String file) throws IOException, UnsupportedAudioFileException, LineUnavailableException, SecurityException, IllegalArgumentException {
        SoundClip sound = this.soundCache.get(file);
        if (sound != null) {
            this.playingSounds.add(sound);
            sound.play();
        } else {
            URL url = GreenfootUtil.getURL(file, "sounds");
            int size = url.openConnection().getContentLength();
            if (size == -1 || size > 500000) {
                final SoundStream soundStream = new SoundStream(url, this);
                this.playingSounds.add(soundStream);
                Thread t = new Thread(){

                    public void run() {
                        try {
                            soundStream.play();
                        }
                        catch (IllegalArgumentException e) {
                        }
                        catch (SecurityException e) {
                        }
                        catch (LineUnavailableException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                            // empty catch block
                        }
                    }
                };
                t.start();
            } else {
                sound = new SoundClip(file, url, this);
                this.soundCache.put(sound);
                this.playingSounds.add(sound);
                sound.play();
            }
        }
    }

    synchronized void soundFinished(Sound s) {
        this.playingSounds.remove(s);
    }

    public void simulationChanged(SimulationEvent e) {
        if (e.getType() == 3) {
            this.stop();
        } else if (e.getType() == 1 || e.getType() == 0) {
            // empty if block
        }
    }
}

