/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlayer;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundClip
extends Sound
implements LineListener {
    private Clip soundClip;
    private SoundPlayer player;
    private String name;
    private URL url;
    private boolean isPlaying;
    private long startTime;
    private static final int EXTEA_SLEEP_DELAY = 300;

    public SoundClip(String name, URL url, SoundPlayer player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, SecurityException, IllegalArgumentException {
        this.name = name;
        this.player = player;
        this.url = url;
        this.isPlaying = false;
    }

    private void open() throws LineUnavailableException, IOException, UnsupportedAudioFileException, IllegalArgumentException, SecurityException {
        AudioInputStream stream = AudioSystem.getAudioInputStream(this.url);
        AudioFormat format = stream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            format = this.getCompatibleFormat(format);
            stream = AudioSystem.getAudioInputStream(format, stream);
            info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
        }
        this.soundClip = (Clip)AudioSystem.getLine(info);
        this.soundClip.open(stream);
        this.soundClip.addLineListener(this);
    }

    public void stop() {
        this.soundClip.stop();
        this.soundClip.setMicrosecondPosition(0L);
        this.isPlaying = false;
        this.soundClip.close();
    }

    public void pause() {
        this.soundClip.stop();
    }

    public void resume() {
        this.soundClip.start();
    }

    public void play() throws IllegalArgumentException, SecurityException, LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.open();
        this.isPlaying = true;
        this.soundClip.setMicrosecondPosition(0L);
        this.soundClip.start();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            long sleepTime = this.soundClip.getMicrosecondLength() / 1000L - (System.currentTimeMillis() - this.startTime);
            this.delayedClose(sleepTime);
        } else if (event.getType() == LineEvent.Type.START) {
            this.startTime = System.currentTimeMillis();
        }
    }

    private void delayedClose(final long sleepTime) {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(sleepTime + 300L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SoundClip.this.isPlaying = false;
                SoundClip.this.player.soundFinished(SoundClip.this);
                SoundClip.this.stop();
            }
        }.start();
    }

    public String toString() {
        return this.url + " " + super.toString();
    }
}

