/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.prefmgr.PrefMgr;
import greenfoot.Actor;
import greenfoot.ObjectTracker;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.GProject;
import greenfoot.core.ProjectProperties;
import greenfoot.core.WorldHandler;
import greenfoot.core.WorldInvokeListener;
import greenfoot.gui.DragGlassPane;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.input.InputManager;
import greenfoot.localdebugger.LocalObject;
import greenfoot.platforms.WorldHandlerDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rmiextension.wrappers.RObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldHandlerDelegateIDE
implements WorldHandlerDelegate,
ObjectBenchInterface {
    protected final Color envOpColour = Config.getItemColour((String)"colour.menu.environOp");
    private WorldHandler worldHandler;
    private GProject project;
    private GreenfootFrame frame;
    private JLabel worldTitle = new JLabel();
    private String lastWorldClass;

    public WorldHandlerDelegateIDE(GreenfootFrame frame) {
        this.worldTitle.setBorder(BorderFactory.createEmptyBorder(18, 0, 4, 0));
        this.worldTitle.setHorizontalAlignment(0);
        this.frame = frame;
    }

    private JPopupMenu makePopupMenu(final Actor obj) {
        JPopupMenu menu = new JPopupMenu();
        ObjectWrapper.createMethodMenuItems((JPopupMenu)menu, obj.getClass(), (InvokeListener)new WorldInvokeListener(obj, this, this.frame, this.project), (DebuggerObject)LocalObject.getLocalObject(obj), null);
        JMenuItem m = this.getInspectMenuItem(obj);
        m.setFont(PrefMgr.getStandoutMenuFont());
        m.setForeground(this.envOpColour);
        menu.add(m);
        m = new JMenuItem(Config.getString((String)"world.handlerDelegate.remove"));
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldHandlerDelegateIDE.this.worldHandler.getWorld().removeObject(obj);
                WorldHandlerDelegateIDE.this.worldHandler.repaint();
            }
        });
        m.setFont(PrefMgr.getStandoutMenuFont());
        m.setForeground(this.envOpColour);
        menu.add(m);
        return menu;
    }

    private JMenuItem getInspectMenuItem(final Object obj) {
        JMenuItem m = new JMenuItem(Config.getString((String)"world.handlerDelegate.inspect"));
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame parent = (JFrame)WorldHandlerDelegateIDE.this.worldHandler.getWorldCanvas().getTopLevelAncestor();
                LocalObject dObj = LocalObject.getLocalObject(obj);
                String instanceName = "";
                try {
                    RObject rObject = ObjectTracker.getRObject(obj);
                    instanceName = rObject.getInstanceName();
                }
                catch (ProjectNotOpenException e1) {
                    e1.printStackTrace();
                }
                catch (PackageNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (RemoteException e1) {
                    e1.printStackTrace();
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
                WorldHandlerDelegateIDE.this.frame.getInspectorInstance(dObj, instanceName, null, null, parent);
            }
        });
        return m;
    }

    @Override
    public boolean maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Actor obj = this.worldHandler.getObject(e.getX(), e.getY());
            if (obj != null) {
                JPopupMenu menu = this.makePopupMenu(obj);
                menu.show(this.worldHandler.getWorldCanvas(), e.getX(), e.getY());
            }
            return true;
        }
        return false;
    }

    @Override
    public void discardWorld(World world) {
        ObjectTracker.forgetRObject(world);
        ArrayList<Actor> oldActors = new ArrayList<Actor>(WorldVisitor.getObjectsListInPaintOrder(world));
        for (Actor oldActor : oldActors) {
            ObjectTracker.forgetRObject(oldActor);
        }
    }

    @Override
    public void setWorld(World oldWorld, final World newWorld) {
        if (newWorld != null) {
            this.lastWorldClass = newWorld.getClass().getName();
        }
        if (oldWorld != null) {
            this.discardWorld(oldWorld);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WorldHandlerDelegateIDE.this.createWorldTitle(newWorld);
                MouseListener[] listeners = WorldHandlerDelegateIDE.this.worldTitle.getMouseListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    WorldHandlerDelegateIDE.this.worldTitle.removeMouseListener(listeners[i]);
                }
                WorldHandlerDelegateIDE.this.worldTitle.addMouseListener(new MouseAdapter(){

                    public void mouseReleased(MouseEvent e) {
                        this.maybeShowPopup(e);
                    }

                    public void mousePressed(MouseEvent e) {
                        this.maybeShowPopup(e);
                    }

                    private void maybeShowPopup(MouseEvent e) {
                        if (e.isPopupTrigger() && WorldHandlerDelegateIDE.this.worldHandler.getWorld() != null) {
                            JPopupMenu menu = new JPopupMenu();
                            ObjectWrapper.createMethodMenuItems((JPopupMenu)menu, newWorld.getClass(), (InvokeListener)new WorldInvokeListener(newWorld, WorldHandlerDelegateIDE.this, WorldHandlerDelegateIDE.this.frame, WorldHandlerDelegateIDE.this.project), (DebuggerObject)LocalObject.getLocalObject(newWorld), null);
                            JMenuItem m = WorldHandlerDelegateIDE.this.getInspectMenuItem(newWorld);
                            menu.add(m);
                            menu.show(WorldHandlerDelegateIDE.this.worldTitle, e.getX(), e.getY());
                        }
                    }
                });
            }
        });
    }

    private void createWorldTitle(World newWorld) {
        if (newWorld == null) {
            return;
        }
        String className = newWorld.getClass().getName();
        String objName = className.substring(0, 1).toLowerCase() + className.substring(1);
        this.worldTitle.setText(objName);
        this.worldTitle.setEnabled(true);
    }

    @Override
    public void dragFinished(Object o) {
        this.worldHandler.finishDrag(o);
    }

    public void fireObjectEvent(Actor actor) {
        class GNamedValue
        implements NamedValue {
            private String name;

            public GNamedValue(String instanceName) {
                this.name = instanceName;
            }

            public JavaType getGenType() {
                return null;
            }

            public String getName() {
                return this.name;
            }

            public boolean isFinal() {
                return false;
            }

            public boolean isInitialized() {
                return true;
            }
        }
        GNamedValue value = null;
        try {
            RObject rObj = ObjectTracker.getRObject(actor);
            value = new GNamedValue(rObj.getInstanceName());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Object[] listeners = this.worldHandler.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ObjectBenchListener.class) continue;
            ((ObjectBenchListener)listeners[i + 1]).objectEvent(new ObjectBenchEvent((Object)this, 1, (NamedValue)value));
        }
    }

    public void addObjectBenchListener(ObjectBenchListener listener) {
        this.worldHandler.getListenerList().add(ObjectBenchListener.class, listener);
    }

    public void removeObjectBenchListener(ObjectBenchListener listener) {
        this.worldHandler.getListenerList().remove(ObjectBenchListener.class, listener);
    }

    public boolean hasObject(String name) {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Actor actor;
        if (SwingUtilities.isLeftMouseButton(e) && (actor = this.worldHandler.getObject(e.getX(), e.getY())) != null) {
            this.fireObjectEvent(actor);
        }
    }

    public void attachProject(Object project) {
        this.project = (GProject)project;
        ProjectProperties probs = this.project.getProjectProperties();
        this.lastWorldClass = probs.getString("world.lastInstantiated");
    }

    public Component getWorldTitle() {
        return this.worldTitle;
    }

    @Override
    public void setWorldHandler(WorldHandler handler) {
        this.worldHandler = handler;
    }

    @Override
    public void instantiateNewWorld() {
        Class<?> cls = this.getLastWorldClass();
        if (cls == null) {
            try {
                List<Class<?>> worldClasses = this.project.getDefaultPackage().getWorldClasses();
                if (worldClasses.isEmpty()) {
                    return;
                }
                cls = worldClasses.get(0);
            }
            catch (ProjectNotOpenException pnoe) {
                return;
            }
            catch (RemoteException re) {
                re.printStackTrace();
                return;
            }
        }
        try {
            World w = (World)cls.newInstance();
            this.worldHandler.setWorld(w);
        }
        catch (LinkageError e) {
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Throwable ise) {
            ise.printStackTrace();
        }
    }

    @Override
    public Class<?> getLastWorldClass() {
        if (this.lastWorldClass == null) {
            return null;
        }
        try {
            List<Class<?>> worldClasses = this.project.getDefaultPackage().getWorldClasses();
            for (Class<?> worldClass : worldClasses) {
                if (!worldClass.getName().equals(this.lastWorldClass)) continue;
                return worldClass;
            }
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return null;
    }

    @Override
    public InputManager getInputManager() {
        InputManager inputManager = new InputManager();
        DragGlassPane.getInstance().addMouseListener(inputManager);
        DragGlassPane.getInstance().addMouseMotionListener(inputManager);
        DragGlassPane.getInstance().addKeyListener(inputManager);
        inputManager.setIdleListeners(this.worldHandler, this.worldHandler, this.worldHandler);
        inputManager.setDragListeners(null, DragGlassPane.getInstance(), DragGlassPane.getInstance());
        inputManager.setMoveListeners(this.worldHandler, this.worldHandler, this.worldHandler);
        return inputManager;
    }
}

