/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import bluej.Config;
import bluej.runtime.ExecServer;
import bluej.utility.BlueJFileReader;
import bluej.utility.FileUtility;
import greenfoot.platforms.GreenfootUtilDelegate;
import greenfoot.util.FileChoosers;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;

public class GreenfootUtilDelegateIDE
implements GreenfootUtilDelegate {
    public void createSkeleton(String className, String superClassName, File file, String templateFileName) throws IOException {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        ((Dictionary)translations).put("CLASSNAME", className);
        if (superClassName != null) {
            ((Dictionary)translations).put("SUPERCLASSNAME", superClassName);
        }
        File libDir = Config.getGreenfootLibDir();
        File template = new File(libDir, "templates/" + templateFileName);
        BlueJFileReader.translateFile((File)template, (File)file, translations);
    }

    public File getScenarioFromFileBrowser(Component parent) {
        return FileChoosers.getScenario(parent);
    }

    public String getNewProjectName(Component parent) {
        return FileUtility.getFileName((Component)parent, (String)Config.getString((String)"greenfoot.utilDelegate.newScenario"), (String)Config.getString((String)"pkgmgr.newPkg.buttonLabel"), (boolean)false, null, (boolean)true);
    }

    public ClassLoader getCurrentClassLoader() {
        return ExecServer.getCurrentClassLoader();
    }

    public String getGreenfootLogoPath() {
        File libDir = Config.getGreenfootLibDir();
        return libDir.getAbsolutePath() + "/imagelib/other/greenfoot.png";
    }
}

