/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import com.sun.jdi.ObjectReference;
import greenfoot.Actor;
import greenfoot.World;
import greenfoot.localdebugger.LocalArray;
import greenfoot.localdebugger.LocalBooleanArray;
import greenfoot.localdebugger.LocalByteArray;
import greenfoot.localdebugger.LocalCharArray;
import greenfoot.localdebugger.LocalClass;
import greenfoot.localdebugger.LocalDoubleArray;
import greenfoot.localdebugger.LocalFloatArray;
import greenfoot.localdebugger.LocalIntArray;
import greenfoot.localdebugger.LocalLongArray;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LocalObject
extends DebuggerObject {
    private static Field[] noFields = new Field[0];
    protected Object object;
    private Map genericParams = null;
    private static String[] actorIncludeFields = new String[]{"x", "y", "rotation", "image", "world"};
    private static String[] worldIncludeFields = new String[]{"width", "height", "cellSize", "backgroundImage"};

    public static LocalObject getLocalObject(Object o) {
        if (o != null && o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return new LocalBooleanArray((boolean[])o);
            }
            if (o instanceof byte[]) {
                return new LocalByteArray((byte[])o);
            }
            if (o instanceof char[]) {
                return new LocalCharArray((char[])o);
            }
            if (o instanceof int[]) {
                return new LocalIntArray((int[])o);
            }
            if (o instanceof long[]) {
                return new LocalLongArray((long[])o);
            }
            if (o instanceof float[]) {
                return new LocalFloatArray((float[])o);
            }
            if (o instanceof double[]) {
                return new LocalDoubleArray((double[])o);
            }
            return new LocalArray((Object[])o);
        }
        return new LocalObject(o);
    }

    public static LocalObject getLocalObject(Object o, Map genericParams) {
        if (o != null && o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return new LocalBooleanArray((boolean[])o);
            }
            if (o instanceof byte[]) {
                return new LocalByteArray((byte[])o);
            }
            if (o instanceof char[]) {
                return new LocalCharArray((char[])o);
            }
            if (o instanceof int[]) {
                return new LocalIntArray((int[])o);
            }
            if (o instanceof long[]) {
                return new LocalLongArray((long[])o);
            }
            if (o instanceof float[]) {
                return new LocalFloatArray((float[])o);
            }
            if (o instanceof double[]) {
                return new LocalDoubleArray((double[])o);
            }
            return new LocalArray((Object[])o);
        }
        return new LocalObject(o, genericParams);
    }

    protected LocalObject(Object o) {
        this.object = o;
    }

    protected LocalObject(Object o, Map genericParams) {
        this.object = o;
        this.genericParams = genericParams;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LocalObject) {
            Object otherObj = ((LocalObject)((Object)other)).object;
            return this.object.equals(otherObj);
        }
        return false;
    }

    public String getClassName() {
        return this.object.getClass().getName();
    }

    public String getGenClassName() {
        if (this.object == null) {
            return "";
        }
        if (this.genericParams != null) {
            return new GenTypeClass((Reflective)new JavaReflective(this.object.getClass()), this.genericParams).toString();
        }
        return this.getClassName();
    }

    public String getStrippedGenClassName() {
        if (this.object == null) {
            return "";
        }
        if (this.genericParams != null) {
            return new GenTypeClass((Reflective)new JavaReflective(this.object.getClass()), this.genericParams).toString(true);
        }
        return JavaNames.stripPrefix((String)this.getClassName());
    }

    public DebuggerClass getClassRef() {
        return new LocalClass(this.object.getClass());
    }

    public GenTypeClass getGenType() {
        JavaReflective r = new JavaReflective(this.object.getClass());
        if (this.genericParams != null) {
            return new GenTypeClass((Reflective)r, this.genericParams);
        }
        return new GenTypeClass((Reflective)r);
    }

    public Map getGenericParams() {
        HashMap r = null;
        if (this.genericParams != null) {
            r = new HashMap();
            r.putAll(this.genericParams);
        } else if (!this.isRaw()) {
            r = new HashMap();
        }
        return r;
    }

    private boolean isRaw() {
        return !JavaUtils.getJavaUtils().getTypeParams(this.object.getClass()).isEmpty() && this.genericParams == null;
    }

    public boolean isArray() {
        return this.object.getClass().isArray();
    }

    public boolean isNullObject() {
        return this.object == null;
    }

    private Field[] getAllFields() {
        if (this.object == null) {
            return noFields;
        }
        ArrayList<AccessibleObject> allFields = new ArrayList<AccessibleObject>();
        for (Class<?> c = this.object.getClass(); c != null; c = c.getSuperclass()) {
            AccessibleObject[] declFields = c.getDeclaredFields();
            AccessibleObject.setAccessible(declFields, true);
            for (int j = 0; j < declFields.length; ++j) {
                AccessibleObject field = declFields[j];
                if (!this.keepField(c, (Field)field)) continue;
                allFields.add(field);
            }
        }
        return allFields.toArray(noFields);
    }

    private Field getStaticFieldSlot(int slot) {
        Field[] fields = this.getAllFields();
        int staticCount = -1;
        int index = 0;
        while (staticCount != slot) {
            if ((fields[index].getModifiers() & 8) != 0) {
                ++staticCount;
            }
            ++index;
        }
        return fields[index - 1];
    }

    private Field getInstanceFieldSlot(int slot) {
        Field[] fields = this.getAllFields();
        int instanceCount = -1;
        int index = 0;
        while (instanceCount != slot) {
            if ((fields[index].getModifiers() & 8) == 0) {
                ++instanceCount;
            }
            ++index;
        }
        return fields[index - 1];
    }

    public int getStaticFieldCount() {
        Field[] fields = this.getAllFields();
        int staticCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) == 0) continue;
            ++staticCount;
        }
        return staticCount;
    }

    public int getInstanceFieldCount() {
        Field[] fields = this.getAllFields();
        int instanceCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) != 0) continue;
            ++instanceCount;
        }
        return instanceCount;
    }

    public String getStaticFieldName(int slot) {
        return this.getStaticFieldSlot(slot).getName();
    }

    public String getInstanceFieldName(int slot) {
        return this.getInstanceFieldSlot(slot).getName();
    }

    public String getInstanceFieldType(int slot) {
        Field f = this.getInstanceFieldSlot(slot);
        JavaType fieldType = JavaUtils.getJavaUtils().getFieldType(f);
        return fieldType.toString();
    }

    private LocalObject getFieldObject(Field field, JavaType expectedType) {
        GenTypeClass expectedCtype = expectedType.asClass();
        try {
            Object o;
            if (expectedCtype != null && !this.isRaw() && (o = field.get(this.object)) != null) {
                Class<?> c = o.getClass();
                if (this.genericParams != null) {
                    expectedType.mapTparsToTypes(this.genericParams);
                }
                GenTypeClass g = expectedCtype.mapToDerived((Reflective)new JavaReflective(c));
                Map m = g.getMap();
                return LocalObject.getLocalObject(o, m);
            }
            o = field.get(this.object);
            return LocalObject.getLocalObject(o);
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = this.getStaticFieldSlot(slot);
        try {
            return LocalObject.getLocalObject(field.get(this.object));
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public DebuggerObject getInstanceFieldObject(int slot) {
        Field field = this.getInstanceFieldSlot(slot);
        try {
            return LocalObject.getLocalObject(field.get(this.object));
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public DebuggerObject getInstanceFieldObject(int slot, JavaType expectedType) {
        Field field = this.getInstanceFieldSlot(slot);
        return this.getFieldObject(field, expectedType);
    }

    public DebuggerObject getFieldObject(int slot) {
        Field field = this.getAllFields()[slot];
        try {
            return LocalObject.getLocalObject(field.get(this.object));
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public DebuggerObject getFieldObject(int slot, JavaType expectedType) {
        Field field = this.getAllFields()[slot];
        return this.getFieldObject(field, expectedType);
    }

    public DebuggerObject getFieldObject(String name) {
        try {
            Field field = this.object.getClass().getField(name);
            return LocalObject.getLocalObject(field.get(this.object));
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String getFieldValueString(int slot) {
        Field f = this.getAllFields()[slot];
        Object v = null;
        try {
            v = f.get(this.object);
            if (!f.getType().isPrimitive()) {
                if (v == null) {
                    v = Config.getString((String)"debugger.null");
                } else {
                    if (v instanceof String) {
                        return "\"" + v + "\"";
                    }
                    v = "<object reference>";
                }
            }
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return v.toString();
    }

    public String getFieldValueTypeString(int slot) {
        Field f = this.getAllFields()[slot];
        JavaType fieldType = JavaUtils.getJavaUtils().getFieldType(f);
        return fieldType.toString();
    }

    public ObjectReference getObjectReference() {
        return null;
    }

    public List getStaticFields(boolean includeModifiers) {
        if (this.object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getClassRef().getStaticFields(includeModifiers);
    }

    public List getInstanceFields(boolean includeModifiers) {
        ArrayList<String> r = new ArrayList<String>();
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getAllFields();
        for (int i = 0; i < fields.length; ++i) {
            JavaType fieldType;
            GenTypeClass fieldClassType;
            int mods = fields[i].getModifiers();
            if ((mods & 8) != 0) continue;
            String desc = "";
            if (includeModifiers) {
                if (Modifier.isPublic(mods)) {
                    desc = "public ";
                } else if (Modifier.isProtected(mods)) {
                    desc = "protected ";
                } else if (Modifier.isPrivate(mods)) {
                    desc = "private ";
                }
            }
            if ((fieldClassType = (fieldType = JavaUtils.getJavaUtils().getFieldType(fields[i])).asClass()) != null) {
                GenTypeClass fieldDeclType = this.getGenType().mapToSuper(fields[i].getDeclaringClass().getName());
                fieldType = fieldType.mapTparsToTypes(fieldDeclType.getMap());
            }
            desc = desc + fieldType.toString(true) + " ";
            desc = desc + fields[i].getName();
            if (!fieldNames.add(fields[i].getName())) {
                desc = desc + " (hidden)";
            }
            desc = desc + " = ";
            try {
                Object fieldval;
                desc = fields[i].getType().isPrimitive() ? desc + fields[i].get(this.object) : ((fieldval = fields[i].get(this.object)) instanceof String ? desc + '\"' + fieldval.toString() + '\"' : (fieldval == null ? desc + Config.getString((String)"debugger.null") : desc + "<object reference>"));
            }
            catch (IllegalAccessException iae) {
                desc = desc + "?";
            }
            r.add(desc);
        }
        return r;
    }

    public boolean staticFieldIsPublic(int slot) {
        Field field = this.getStaticFieldSlot(slot);
        int mods = field.getModifiers();
        return Modifier.isPublic(mods);
    }

    public boolean instanceFieldIsPublic(int slot) {
        Field field = this.getInstanceFieldSlot(slot);
        int mods = field.getModifiers();
        return Modifier.isPublic(mods);
    }

    public boolean staticFieldIsObject(int slot) {
        Field field = this.getStaticFieldSlot(slot);
        return !field.getType().isPrimitive() && this.fieldNotNull(field);
    }

    public boolean instanceFieldIsObject(int slot) {
        Field field = this.getInstanceFieldSlot(slot);
        return !field.getType().isPrimitive() && this.fieldNotNull(field);
    }

    public boolean fieldIsObject(int slot) {
        Field field = this.getAllFields()[slot];
        return !field.getType().isPrimitive() && this.fieldNotNull(field);
    }

    public boolean fieldNotNull(Field field) {
        try {
            Object v = field.get(this.object);
            return v != null;
        }
        catch (IllegalAccessException iae) {
            return false;
        }
    }

    public List getAllFields(boolean includeModifiers) {
        return null;
    }

    private boolean keepField(Class cls, Field field) {
        if (cls.equals(World.class)) {
            for (int i = 0; i < worldIncludeFields.length; ++i) {
                String includeName = worldIncludeFields[i];
                if (!includeName.equals(field.getName())) continue;
                return true;
            }
            return false;
        }
        if (cls.equals(Actor.class)) {
            for (int i = 0; i < actorIncludeFields.length; ++i) {
                String includeName = actorIncludeFields[i];
                if (!includeName.equals(field.getName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Object getObject() {
        return this.object;
    }
}

