/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.debugger.DebuggerObject;
import greenfoot.localdebugger.LocalObject;
import java.util.ArrayList;
import java.util.List;

public class LocalArray
extends LocalObject {
    private int length;

    protected LocalArray(Object[] object) {
        super(object);
        this.length = object.length;
    }

    protected LocalArray(Object object, int length) {
        super(object);
        this.length = length;
    }

    public int getInstanceFieldCount() {
        return this.length;
    }

    public String getInstanceFieldName(int slot) {
        return "[" + String.valueOf(slot) + "]";
    }

    public DebuggerObject getInstanceFieldObject(int slot) {
        Object val = ((Object[])this.object)[slot];
        return LocalArray.getLocalObject(val);
    }

    public List getInstanceFields(boolean includeModifiers) {
        ArrayList<String> fields = new ArrayList<String>(this.length);
        for (int i = 0; i < this.length; ++i) {
            String valString = this.getValueString(i);
            fields.add("[" + i + "]" + " = " + valString);
        }
        return fields;
    }

    public String getValueString(int index) {
        Object value = ((Object[])this.object)[index];
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Enum) {
            Enum enumv = (Enum)value;
            return enumv.name();
        }
        return "<object reference>";
    }

    public boolean instanceFieldIsPublic(int slot) {
        return true;
    }

    public boolean instanceFieldIsObject(int slot) {
        return ((Object[])this.object)[slot] != null;
    }
}

