/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.inspector;

import bluej.debugmgr.inspector.Inspector;
import greenfoot.gui.inspector.UpdateTask;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Timer;
import java.util.TimerTask;

public class InspectorUpdater
implements WindowListener {
    private Inspector inspector;
    private Timer timer;
    private static final int PERIOD = 500;

    public InspectorUpdater(Inspector inspector) {
        this.inspector = inspector;
        inspector.addWindowListener((WindowListener)this);
        if (inspector.isVisible()) {
            this.start();
        }
    }

    public void start() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new UpdateTask(this.inspector), 500L, 500L);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        this.start();
    }

    public void windowClosed(WindowEvent e) {
        this.stop();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
        this.start();
    }

    public void windowIconified(WindowEvent e) {
        this.stop();
    }
}

