/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import bluej.Config;
import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.gui.input.mouse.MouseEventData;
import greenfoot.gui.input.mouse.PriorityManager;
import greenfoot.gui.input.mouse.WorldLocator;
import java.awt.event.MouseEvent;

public class MousePollingManager
implements TriggeredMouseListener,
TriggeredMouseMotionListener {
    private boolean polledInThisAct;
    private boolean polledThisData;
    private MouseEventData currentData = new MouseEventData();
    private MouseEventData futureData = new MouseEventData();
    private MouseEventData potentialNewDragData = new MouseEventData();
    private WorldLocator locator;
    private MouseEventData dragStartData;
    private boolean isDragging;
    private boolean gotNewEvent;

    public MousePollingManager(WorldLocator locator) {
        this.locator = locator;
    }

    public void newActStarted() {
        this.polledInThisAct = false;
    }

    private void registerEventRecieved() {
        this.gotNewEvent = true;
        this.polledThisData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeMouseData() {
        if (this.polledInThisAct) {
            return;
        }
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            if (!this.polledThisData && !this.gotNewEvent) {
                this.polledThisData = true;
                this.polledInThisAct = true;
                return;
            }
            MouseEventData newData = new MouseEventData();
            this.currentData = this.futureData;
            this.futureData = newData;
            this.potentialNewDragData = new MouseEventData();
            this.gotNewEvent = false;
        }
        this.polledInThisAct = true;
        this.polledThisData = true;
    }

    public boolean isMousePressed(Object obj) {
        this.freezeMouseData();
        return this.currentData.isMousePressed(obj);
    }

    public boolean isMouseClicked(Object obj) {
        this.freezeMouseData();
        return this.currentData.isMouseClicked(obj);
    }

    public boolean isMouseDragged(Object obj) {
        this.freezeMouseData();
        return this.currentData.isMouseDragged(obj);
    }

    public boolean isMouseDragEnded(Object obj) {
        this.freezeMouseData();
        return this.currentData.isMouseDragEnded(obj);
    }

    public boolean isMouseMoved(Object obj) {
        this.freezeMouseData();
        return this.currentData.isMouseMoved(obj);
    }

    public MouseInfo getMouseInfo() {
        this.freezeMouseData();
        return this.currentData.getMouseInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent e) {
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded(null)) {
                mouseData = this.potentialNewDragData;
            }
            if (!PriorityManager.isHigherPriority(e, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            Actor actor = this.locator.getTopMostActorAt(e);
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            mouseData.mouseClicked(x, y, button, e.getClickCount(), actor);
            this.isDragging = false;
        }
    }

    private int getButton(MouseEvent e) {
        int button = e.getButton();
        if (Config.isMacOS() && button == 1 && (e.getModifiersEx() & 0x80) == 128) {
            button = 3;
        }
        return button;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded(null)) {
                mouseData = this.potentialNewDragData;
            }
            this.dragStartData = new MouseEventData();
            Actor actor = this.locator.getTopMostActorAt(e);
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            this.dragStartData.mousePressed(x, y, button, actor);
            if (!PriorityManager.isHigherPriority(e, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            mouseData.mousePressed(x, y, button, actor);
            this.isDragging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            if (this.isDragging) {
                if (this.futureData.isMouseDragEnded(null)) {
                    this.futureData = this.potentialNewDragData;
                }
                if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                    return;
                }
                this.registerEventRecieved();
                int x = this.locator.getTranslatedX(e);
                int y = this.locator.getTranslatedY(e);
                int button = this.getButton(e);
                Actor clickActor = this.locator.getTopMostActorAt(e);
                this.futureData.mouseClicked(x, y, button, 1, clickActor);
                Actor actor = this.dragStartData.getActor();
                this.futureData.mouseDragEnded(x, y, button, actor);
                this.isDragging = false;
                this.potentialNewDragData = new MouseEventData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            this.isDragging = true;
            if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            this.futureData.mouseDragged(x, y, button, this.dragStartData.getActor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent e) {
        MouseEventData mouseEventData = this.futureData;
        synchronized (mouseEventData) {
            if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            Actor actor = this.locator.getTopMostActorAt(e);
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            this.futureData.mouseMoved(x, y, button, actor);
            this.isDragging = false;
        }
    }

    public void listeningEnded() {
    }

    public void listeningStarted(Object obj) {
    }
}

