/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import greenfoot.gui.export.ImageEditCanvas;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageEditPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private ImageEditCanvas imageCanvas;
    private int lastX;
    private int lastY;
    private JSlider zoomSlider;
    private int width;
    private int height;
    private JLabel bigLabel;
    private JLabel smallLabel;

    public ImageEditPanel(int width, int height) {
        this.width = width;
        this.height = height;
        this.setPreferredSize(new Dimension(width + 2, height + 2));
    }

    public void setImage(BufferedImage snapShot) {
        if (this.imageCanvas == null) {
            this.imageCanvas = new ImageEditCanvas(this.width, this.height, snapShot);
            this.imageCanvas.fit();
            this.buildUI();
        } else {
            double oldMinScale = this.imageCanvas.getMinimumScale();
            this.imageCanvas.setImage(snapShot);
            double newMinScale = this.imageCanvas.getMinimumScale();
            if (newMinScale != oldMinScale) {
                this.imageCanvas.fit();
                this.adjustSlider();
            }
        }
    }

    private void buildUI() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.imageCanvas.addMouseMotionListener(this);
        this.imageCanvas.addMouseListener(this);
        this.imageCanvas.addMouseWheelListener(this);
        this.imageCanvas.setCursor(Cursor.getPredefinedCursor(12));
        this.zoomSlider = new JSlider(1);
        this.zoomSlider.setOpaque(false);
        try {
            URL url = new File(GreenfootUtil.getGreenfootLogoPath()).toURI().toURL();
            BufferedImage iconImage = GraphicsUtilities.loadCompatibleImage(url);
            this.bigLabel = new JLabel(new ImageIcon(iconImage.getScaledInstance(-1, 15, 1)));
            this.smallLabel = new JLabel(new ImageIcon(iconImage.getScaledInstance(-1, 10, 1)));
            this.zoomSlider.setPaintLabels(true);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.adjustSlider();
        Dimension maxSize = this.zoomSlider.getMaximumSize();
        maxSize.height = this.imageCanvas.getMaximumSize().height;
        this.zoomSlider.setMaximumSize(maxSize);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int scale = source.getValue();
                ImageEditPanel.this.imageCanvas.setScale((double)scale / 100.0);
            }
        });
        Box border = new Box(2);
        border.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        border.add(this.imageCanvas);
        this.add(Box.createHorizontalGlue());
        this.add(border);
        this.add(this.zoomSlider);
        this.add(Box.createHorizontalGlue());
    }

    private void adjustSlider() {
        int min = (int)(this.imageCanvas.getMinimumScale() * 100.0);
        int max = 100;
        int scale = (int)(this.imageCanvas.getScale() * 100.0);
        this.zoomSlider.setMinimum(min);
        this.zoomSlider.setMaximum(max);
        this.zoomSlider.setValue(scale);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(this.zoomSlider.getMinimum(), this.smallLabel);
        ((Dictionary)labels).put(this.zoomSlider.getMaximum(), this.bigLabel);
        this.zoomSlider.setLabelTable(labels);
        this.zoomSlider.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 0) {
            this.imageCanvas.setCursor(Cursor.getPredefinedCursor(13));
            int dx = e.getX() - this.lastX;
            int dy = e.getY() - this.lastY;
            this.imageCanvas.move(dx, dy);
            this.lastX = e.getX();
            this.lastY = e.getY();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.lastX = e.getX();
            this.lastY = e.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.imageCanvas.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int scroll = e.getUnitsToScroll();
        this.zoomSlider.setValue(this.zoomSlider.getValue() - scroll);
    }

    public BufferedImage getImage() {
        if (this.imageCanvas == null) {
            return null;
        }
        BufferedImage newImage = GraphicsUtilities.createCompatibleImage(this.width, this.height);
        Graphics2D g = newImage.createGraphics();
        this.imageCanvas.paintImage(g);
        g.dispose();
        return newImage;
    }
}

