/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageEditCanvas
extends JPanel {
    private BufferedImage image;
    private Dimension size;
    private double x;
    private double y;
    private double scaleFactor = 1.0;
    private double minScaleFactor;
    int snapThreshold = 7;

    public ImageEditCanvas(int width, int height, BufferedImage image) {
        this.size = new Dimension(width, height);
        this.setOpaque(false);
        this.setImage(image);
    }

    public void setSnapThreshold(int threshold) {
        this.snapThreshold = threshold;
    }

    public void setImage(BufferedImage image) {
        double minScaleFactorY;
        this.image = image;
        double minScaleFactorX = this.size.getWidth() / (double)image.getWidth();
        double d = this.minScaleFactor = minScaleFactorX < (minScaleFactorY = this.size.getHeight() / (double)image.getHeight()) ? minScaleFactorX : minScaleFactorY;
        if (this.minScaleFactor > 1.0) {
            this.minScaleFactor = 1.0;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintImage(g);
    }

    public void paintImage(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTx = g2.getTransform();
        double xSnapped = this.x;
        double ySnapped = this.y;
        if (this.scaleFactor == this.minScaleFactor) {
            double xs = ((double)(this.image.getWidth() / 2) + xSnapped) * this.scaleFactor;
            double ys = ((double)(this.image.getHeight() / 2) + ySnapped) * this.scaleFactor;
            if (Math.abs(xs) < (double)this.snapThreshold && Math.abs(ys) < (double)this.snapThreshold) {
                xSnapped = -this.image.getWidth() / 2;
                ySnapped = -this.image.getHeight() / 2;
            }
        }
        g2.translate(this.size.width / 2, this.size.height / 2);
        g2.scale(this.scaleFactor, this.scaleFactor);
        g2.translate(xSnapped, ySnapped);
        g2.drawImage((Image)this.image, 0, 0, null);
        g2.setTransform(oldTx);
    }

    public void fit() {
        this.x = (int)((double)(-this.image.getWidth()) / 2.0);
        this.y = (int)((double)(-this.image.getHeight()) / 2.0);
        this.setScale(this.minScaleFactor);
    }

    public void move(int dx, int dy) {
        this.x += (double)dx / this.scaleFactor;
        this.y += (double)dy / this.scaleFactor;
        this.repaint();
    }

    public double getScale() {
        return this.scaleFactor;
    }

    public void setScale(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        if (scaleFactor < this.minScaleFactor) {
            this.scaleFactor = this.minScaleFactor;
        }
        this.repaint();
    }

    public double getMinimumScale() {
        return this.minScaleFactor;
    }

    public Dimension getMaximumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }
}

