/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.Config;
import bluej.utility.MiksGridLayout;
import bluej.utility.SwingWorker;
import greenfoot.core.GProject;
import greenfoot.export.WebPublisher;
import greenfoot.export.mygame.ExistingScenarioChecker;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.gui.export.ExportPane;
import greenfoot.gui.export.ImageEditPanel;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPublishPane
extends ExportPane {
    public static final int IMAGE_WIDTH = 120;
    public static final int IMAGE_HEIGHT = 70;
    public static final String FUNCTION = "PUBLISH";
    private static final Color background = new Color(166, 188, 202);
    private static final Color headingColor = new Color(40, 75, 125);
    private static final String serverURL = ExportPublishPane.ensureTrailingSlash(Config.getPropString((String)"greenfoot.gameserver.address", (String)"http://greenfootgallery.org"));
    private static final String createAccountUrl = Config.getPropString((String)"greenfoot.gameserver.createAccount.address", (String)"http://greenfootgallery.org/users/new");
    private static final String serverName = Config.getPropString((String)"greenfoot.gameserver.name", (String)"Greenfoot Gallery");
    private static final String helpLine1 = Config.getString((String)"export.publish.help") + " " + serverName;
    private JTextField titleField;
    private JTextField shortDescriptionField;
    private JTextArea descriptionArea;
    private JTextField urlField;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private ImageEditPanel imagePanel;
    private JCheckBox includeSource;
    private SwingWorker commonTagsLoader;
    private JCheckBox[] popTags = new JCheckBox[7];
    private JTextArea tagArea;
    private GProject project;
    private boolean firstActivation = true;
    private ScenarioInfo publishedScenarioInfo;
    private String publishedUserName;
    private ExistingScenarioChecker scenarioChecker;
    private JButton continueButton;

    public ExportPublishPane(GProject project) {
        this.project = project;
        this.makePane();
    }

    public BufferedImage getImage() {
        return this.imagePanel.getImage();
    }

    public void setImage(BufferedImage snapShot) {
        this.imagePanel.setImage(snapShot);
        this.imagePanel.repaint();
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public String getShortDescription() {
        return this.shortDescriptionField.getText();
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public String getURL() {
        return this.urlField.getText();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public boolean includeSourceCode() {
        return this.includeSource.isSelected();
    }

    private void setHasSource(boolean hasSource) {
        this.includeSource.setSelected(hasSource);
    }

    private void setLocked(boolean locked) {
        this.lockScenario.setSelected(locked);
    }

    private void setTags(List<String> tags) {
        StringBuilder newTags = new StringBuilder();
        boolean isFirstNewTag = true;
        for (String tag : tags) {
            boolean isPopTag = false;
            for (int i = 0; i < this.popTags.length; ++i) {
                JCheckBox popTag = this.popTags[i];
                if (!popTag.getText().equals(tag)) continue;
                popTag.setSelected(true);
                isPopTag = true;
                break;
            }
            if (isPopTag) continue;
            if (!isFirstNewTag) {
                newTags.append(System.getProperty("line.separator"));
            }
            isFirstNewTag = false;
            newTags.append(tag);
        }
        this.tagArea.setText(newTags.toString());
    }

    private void setUrl(String url) {
        this.urlField.setText(url);
    }

    private void setLongDescription(String longDescription) {
        this.descriptionArea.setText(longDescription);
    }

    private void setShortDescripton(String shortDescription) {
        this.shortDescriptionField.setText(shortDescription);
    }

    private void setTitle(String title) {
        this.titleField.setText(title);
        this.checkForExistingScenario();
    }

    private void setUserName(String name) {
        this.userNameField.setText(name);
        this.checkForExistingScenario();
    }

    private void makePane() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        Box helpBox = new Box(0);
        helpBox.setAlignmentX(0.0f);
        JLabel helpText1 = new JLabel(helpLine1 + " (");
        helpBox.add(helpText1);
        JLabel serverLink = new JLabel(serverURL);
        GreenfootUtil.makeLink(serverLink, serverURL);
        helpBox.add(serverLink);
        helpBox.add(new JLabel(")"));
        this.add(helpBox);
        Font smallFont = new JLabel().getFont().deriveFont(2, 11.0f);
        this.add(Box.createVerticalStrut(12));
        JPanel infoPanel = new JPanel(new BorderLayout(22, 18));
        infoPanel.setAlignmentX(0.0f);
        infoPanel.setBackground(background);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(12, 22, 12, 22));
        infoPanel.setBorder(border);
        JLabel text = new JLabel(Config.getString((String)"export.publish.info") + " " + serverName, 0);
        text.setForeground(headingColor);
        infoPanel.add((Component)text, "North");
        Box leftPanel = new Box(1);
        JPanel titleAndDescPanel = new JPanel((LayoutManager)new MiksGridLayout(6, 2, 8, 8));
        titleAndDescPanel.setBackground(background);
        this.imagePanel = new ImageEditPanel(120, 70);
        this.imagePanel.setBackground(background);
        Box textPanel = new Box(1);
        text = new JLabel(Config.getString((String)"export.publish.image1"));
        text.setAlignmentX(1.0f);
        text.setFont(smallFont);
        textPanel.add(text);
        text = new JLabel(Config.getString((String)"export.publish.image2"));
        text.setAlignmentX(1.0f);
        text.setFont(smallFont);
        textPanel.add(text);
        titleAndDescPanel.add(textPanel);
        titleAndDescPanel.add(this.imagePanel);
        text = new JLabel(Config.getString((String)"export.publish.title"), 11);
        text.setFont(smallFont);
        titleAndDescPanel.add(text);
        this.titleField = new JTextField(this.project.getName());
        this.titleField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                String text = ExportPublishPane.this.titleField.getText();
                return text.length() > 0;
            }
        });
        this.titleField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExportPublishPane.this.checkForExistingScenario();
            }
        });
        titleAndDescPanel.add(this.titleField);
        text = new JLabel(Config.getString((String)"export.publish.shortDescription"), 11);
        text.setFont(smallFont);
        titleAndDescPanel.add(text);
        this.shortDescriptionField = new JTextField();
        titleAndDescPanel.add(this.shortDescriptionField);
        text = new JLabel(Config.getString((String)"export.publish.longDescription"), 11);
        text.setVerticalAlignment(1);
        text.setFont(smallFont);
        titleAndDescPanel.add(text);
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setRows(6);
        JScrollPane description = new JScrollPane(this.descriptionArea);
        titleAndDescPanel.add(description);
        text = new JLabel(Config.getString((String)"export.publish.url"), 11);
        text.setFont(smallFont);
        titleAndDescPanel.add(text);
        this.urlField = new JTextField();
        titleAndDescPanel.add(this.urlField);
        titleAndDescPanel.add(Box.createVerticalStrut(8));
        leftPanel.add((Component)titleAndDescPanel, "Center");
        JPanel sourceAndLockPanel = new JPanel(new FlowLayout(1, 8, 0));
        sourceAndLockPanel.setBackground(background);
        this.includeSource = new JCheckBox(Config.getString((String)"export.publish.includeSource"));
        this.includeSource.setOpaque(false);
        this.includeSource.setSelected(false);
        this.includeSource.setFont(smallFont);
        sourceAndLockPanel.add(this.includeSource);
        this.lockScenario.setFont(smallFont);
        sourceAndLockPanel.add(this.lockScenario);
        leftPanel.add((Component)sourceAndLockPanel, "South");
        infoPanel.add((Component)leftPanel, "Center");
        JPanel tagPanel = new JPanel((LayoutManager)new MiksGridLayout(3, 1, 8, 8));
        tagPanel.setBackground(background);
        JPanel popPanel = new JPanel((LayoutManager)new MiksGridLayout(8, 1, 8, 0));
        popPanel.setBackground(background);
        JLabel popLabel = new JLabel(Config.getString((String)"export.publish.tags.popular"), 10);
        popLabel.setFont(smallFont);
        popPanel.add(popLabel);
        for (int i = 0; i < this.popTags.length; ++i) {
            JCheckBox popTag = new JCheckBox(Config.getString((String)"export.publish.tags.loading"));
            popTag.setBackground(background);
            popTag.setFont(smallFont);
            popTag.setEnabled(false);
            this.popTags[i] = popTag;
            popPanel.add(popTag);
        }
        tagPanel.add(popPanel);
        Box textPanel2 = new Box(1);
        JLabel additionalLabel = new JLabel(Config.getString((String)"export.publish.tags.additional1"), 10);
        additionalLabel.setFont(smallFont);
        textPanel2.add(additionalLabel);
        JLabel additionalLabel2 = new JLabel(Config.getString((String)"export.publish.tags.additional2"), 0);
        additionalLabel2.setFont(smallFont);
        textPanel2.add(additionalLabel2);
        tagPanel.add(textPanel2);
        this.tagArea = new JTextArea();
        this.tagArea.setRows(3);
        JScrollPane tagScroller = new JScrollPane(this.tagArea);
        tagPanel.add(tagScroller);
        infoPanel.add((Component)tagPanel, "East");
        this.add(infoPanel);
        this.add(Box.createVerticalStrut(16));
        JPanel loginPanel = new JPanel(new FlowLayout(1, 8, 4));
        loginPanel.setBackground(background);
        loginPanel.setAlignmentX(0.0f);
        CompoundBorder border2 = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12));
        loginPanel.setBorder(border2);
        JLabel text2 = new JLabel(Config.getString((String)"export.publish.login"));
        text2.setForeground(headingColor);
        text2.setVerticalAlignment(1);
        loginPanel.add(text2);
        text2 = new JLabel(Config.getString((String)"export.publish.username"), 11);
        text2.setFont(smallFont);
        loginPanel.add(text2);
        this.userNameField = new JTextField(10);
        this.userNameField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                String text = ExportPublishPane.this.userNameField.getText();
                return text.length() > 0;
            }
        });
        this.userNameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExportPublishPane.this.checkForExistingScenario();
            }
        });
        loginPanel.add(this.userNameField);
        text2 = new JLabel(Config.getString((String)"export.publish.password"), 11);
        text2.setFont(smallFont);
        loginPanel.add(text2);
        this.passwordField = new JPasswordField(10);
        loginPanel.add(this.passwordField);
        JLabel createAccountLabel = new JLabel(Config.getString((String)"export.publish.createAccount"));
        createAccountLabel.setBackground(background);
        createAccountLabel.setHorizontalAlignment(4);
        GreenfootUtil.makeLink(createAccountLabel, createAccountUrl);
        loginPanel.add(createAccountLabel);
        this.add(loginPanel);
        this.add(Box.createVerticalStrut(10));
    }

    private void setPopularTags(List<String> tags) {
        int minLength = this.popTags.length < tags.size() ? this.popTags.length : tags.size();
        for (int i = 0; i < minLength; ++i) {
            JCheckBox checkBox = this.popTags[i];
            checkBox.setText(tags.get(i));
            checkBox.setEnabled(true);
            this.setTags(this.getTags());
        }
    }

    public List<String> getTags() {
        LinkedList<String> tagList = new LinkedList<String>();
        for (int i = 0; i < this.popTags.length; ++i) {
            JCheckBox checkBox = this.popTags[i];
            if (!checkBox.isSelected()) continue;
            tagList.add(checkBox.getText());
        }
        String currentTags = this.tagArea.getText().trim();
        String[] tags = currentTags.split("\\s");
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i].trim();
            if (tag.equals("")) continue;
            tagList.add(tag);
        }
        return tagList;
    }

    private void loadStoredScenarioInfo() {
        ScenarioInfo info = new ScenarioInfo();
        if (info.load(this.project.getProjectProperties())) {
            this.setTitle(info.getTitle());
            this.setShortDescripton(info.getShortDescription());
            this.setLongDescription(info.getLongDescription());
            this.setUrl(info.getUrl());
            this.setTags(info.getTags());
            this.setLocked(info.isLocked());
            this.setHasSource(info.getHasSource());
        }
    }

    private void updateInfoFromFields(ScenarioInfo scenarioInfo) {
        scenarioInfo.setTitle(this.getTitle());
        scenarioInfo.setShortDescription(this.getShortDescription());
        scenarioInfo.setLongDescription(this.getDescription());
        scenarioInfo.setUrl(this.getURL());
        scenarioInfo.setTags(this.getTags());
        scenarioInfo.setLocked(this.lockScenario());
        scenarioInfo.setHasSource(this.includeSourceCode());
    }

    private void checkForExistingScenario() {
        this.checkForExistingScenario(false);
    }

    private void checkForExistingScenario(boolean forceRecheck) {
        String userName = this.getUserName();
        String title = this.getTitle();
        if (userName == null || userName.equals("")) {
            return;
        }
        if (title == null || title.equals("")) {
            return;
        }
        if (this.scenarioChecker == null) {
            this.scenarioChecker = new ExistingScenarioChecker(){
                private String updateText = " " + Config.getString((String)"export.dialog.continue.update");

                public void scenarioExistenceCheckFailed(Exception reason) {
                    ExportPublishPane.this.continueButton.setText(this.getStrippedText());
                }

                public void scenarioExistenceChecked(ScenarioInfo info) {
                    String currentText = this.getStrippedText();
                    if (info != null) {
                        ExportPublishPane.this.continueButton.setText(currentText + this.updateText);
                    } else {
                        ExportPublishPane.this.continueButton.setText(currentText);
                    }
                }

                private String getStrippedText() {
                    String currentText = ExportPublishPane.this.continueButton.getText();
                    int i = currentText.indexOf(this.updateText);
                    if (i != -1) {
                        currentText = currentText.substring(0, i);
                    }
                    return currentText;
                }
            };
        }
        this.scenarioChecker.startScenarioExistenceCheck(serverURL, userName, title, forceRecheck);
    }

    @Override
    public void activated(JButton continueButton) {
        this.continueButton = continueButton;
        this.checkForExistingScenario();
        if (this.firstActivation) {
            this.firstActivation = false;
            this.commonTagsLoader = new SwingWorker(){

                public void finished() {
                    List l = (List)this.getValue();
                    if (l != null) {
                        ExportPublishPane.this.setPopularTags(l);
                    }
                }

                public Object construct() {
                    WebPublisher client = new WebPublisher();
                    List<String> tags = null;
                    try {
                        String hostAddress = serverURL;
                        if (!hostAddress.endsWith("/")) {
                            hostAddress = hostAddress + "/";
                        }
                        tags = client.getCommonTags(hostAddress, ExportPublishPane.this.popTags.length);
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return tags;
                }
            };
            this.commonTagsLoader.start();
            SwingUtilities.invokeLater(new Thread(){

                public void run() {
                    ExportPublishPane.this.setUserName(Config.getPropString((String)"publish.username", (String)""));
                    ExportPublishPane.this.loadStoredScenarioInfo();
                }
            });
        }
    }

    @Override
    public boolean prePublish() {
        this.publishedScenarioInfo = new ScenarioInfo();
        this.updateInfoFromFields(this.publishedScenarioInfo);
        this.publishedUserName = this.userNameField.getText();
        return true;
    }

    @Override
    public void postPublish(boolean success) {
        if (success) {
            this.publishedScenarioInfo.store(this.project.getProjectProperties());
            Config.putPropString((String)"publish.username", (String)this.publishedUserName);
            this.checkForExistingScenario(true);
        }
    }

    public static String ensureTrailingSlash(String hostname) {
        if (hostname.endsWith("/")) {
            return hostname;
        }
        return hostname + "/";
    }
}

